/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.dht;

import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.torrent.InfoHash;
import com.acgist.snail.net.torrent.TorrentSession;
import com.acgist.snail.net.torrent.dht.DhtClient;
import com.acgist.snail.net.torrent.dht.NodeContext;
import com.acgist.snail.net.torrent.dht.NodeSession;
import com.acgist.snail.utils.CollectionUtils;
import com.acgist.snail.utils.NetUtils;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public final class DhtLauncher
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DhtLauncher.class);
    private final InfoHash infoHash;
    private final List<InetSocketAddress> peerNodes;

    private DhtLauncher(TorrentSession torrentSession) {
        this.infoHash = torrentSession.infoHash();
        this.peerNodes = new ArrayList<InetSocketAddress>();
    }

    public static final DhtLauncher newInstance(TorrentSession torrentSession) {
        return new DhtLauncher(torrentSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList<InetSocketAddress> nodes;
        LOGGER.debug("\u6267\u884cDHT\u5b9a\u65f6\u4efb\u52a1", new Object[0]);
        List<InetSocketAddress> list = this.peerNodes;
        synchronized (list) {
            nodes = new ArrayList<InetSocketAddress>(this.peerNodes);
            this.peerNodes.clear();
        }
        try {
            List<InetSocketAddress> list2 = this.pick();
            if (CollectionUtils.isNotEmpty(nodes)) {
                this.joinNodes(nodes);
                list2.addAll(nodes);
            }
            this.findPeers(list2);
        }
        catch (Exception e) {
            LOGGER.error("\u6267\u884cDHT\u5b9a\u65f6\u4efb\u52a1\u5f02\u5e38", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String host, Integer port) {
        List<InetSocketAddress> list = this.peerNodes;
        synchronized (list) {
            this.peerNodes.add(NetUtils.buildSocketAddress(host, port));
        }
    }

    private List<InetSocketAddress> pick() {
        return NodeContext.getInstance().findNode(this.infoHash.getInfoHash()).stream().filter(NodeSession::markVerify).map(node -> NetUtils.buildSocketAddress(node.getHost(), node.getPort())).collect(Collectors.toList());
    }

    private void joinNodes(List<InetSocketAddress> peerNodes) {
        NodeContext nodeContext = NodeContext.getInstance();
        peerNodes.forEach(address -> nodeContext.newNodeSession(address.getHostString(), address.getPort()));
    }

    private void findPeers(List<InetSocketAddress> list) {
        if (CollectionUtils.isEmpty(list)) {
            LOGGER.debug("DHT\u5b9a\u65f6\u4efb\u52a1\u6ca1\u6709\u8282\u70b9\u53ef\u7528", new Object[0]);
            return;
        }
        byte[] infoHashValue = this.infoHash.getInfoHash();
        for (InetSocketAddress socketAddress : list) {
            DhtClient.newInstance(socketAddress).getPeers(infoHashValue);
        }
    }
}

