/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.dht;

import com.acgist.snail.utils.BeanUtils;
import com.acgist.snail.utils.MapUtils;
import com.acgist.snail.utils.NetUtils;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public abstract class DhtMessage {
    protected final byte[] t;
    protected final String y;
    protected InetSocketAddress socketAddress;

    protected DhtMessage(byte[] t, String y) {
        this.t = t;
        this.y = y;
    }

    public byte[] getT() {
        return this.t;
    }

    public String getY() {
        return this.y;
    }

    public InetSocketAddress getSocketAddress() {
        return this.socketAddress;
    }

    public void setSocketAddress(InetSocketAddress socketAddress) {
        this.socketAddress = socketAddress;
    }

    protected boolean ipv4() {
        String host = this.socketAddress.getHostString();
        return NetUtils.ipv4(host);
    }

    protected boolean ipv6() {
        String host = this.socketAddress.getHostString();
        return NetUtils.ipv6(host);
    }

    public byte[] getNodeId() {
        return this.getBytes("id");
    }

    public Integer getInteger(String key) {
        return MapUtils.getInteger(this.get(), key);
    }

    public Long getLong(String key) {
        return MapUtils.getLong(this.get(), key);
    }

    public String getString(String key) {
        return MapUtils.getString(this.get(), key);
    }

    public byte[] getBytes(String key) {
        return MapUtils.getBytes(this.get(), key);
    }

    public List<Object> getList(String key) {
        return MapUtils.getList(this.get(), key);
    }

    public Object get(String key) {
        return MapUtils.get(this.get(), key);
    }

    protected abstract Map<String, Object> get();

    public abstract void put(String var1, Object var2);

    public abstract byte[] toBytes();

    public int hashCode() {
        return Arrays.hashCode(this.t);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof DhtMessage) {
            DhtMessage message = (DhtMessage)object;
            return Arrays.equals(this.t, message.t);
        }
        return false;
    }

    public String toString() {
        return BeanUtils.toString(this, this.t, this.y);
    }
}

