/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.dht;

import com.acgist.snail.config.DhtConfig;
import com.acgist.snail.format.BEncodeDecoder;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.NetException;
import com.acgist.snail.net.UdpMessageHandler;
import com.acgist.snail.net.torrent.TorrentContext;
import com.acgist.snail.net.torrent.TorrentSession;
import com.acgist.snail.net.torrent.dht.DhtContext;
import com.acgist.snail.net.torrent.dht.DhtMessage;
import com.acgist.snail.net.torrent.dht.DhtRequest;
import com.acgist.snail.net.torrent.dht.DhtResponse;
import com.acgist.snail.net.torrent.dht.NodeContext;
import com.acgist.snail.net.torrent.dht.NodeSession;
import com.acgist.snail.net.torrent.dht.request.AnnouncePeerRequest;
import com.acgist.snail.net.torrent.dht.request.FindNodeRequest;
import com.acgist.snail.net.torrent.dht.request.GetPeersRequest;
import com.acgist.snail.net.torrent.dht.request.PingRequest;
import com.acgist.snail.net.torrent.dht.response.FindNodeResponse;
import com.acgist.snail.net.torrent.dht.response.GetPeersResponse;
import com.acgist.snail.utils.StringUtils;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.function.Predicate;

public final class DhtMessageHandler
extends UdpMessageHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DhtMessageHandler.class);
    private static final Predicate<DhtResponse> RESPONSE_SUCCESS = response -> response != null && response.success();

    public DhtMessageHandler() {
        this(null);
    }

    public DhtMessageHandler(InetSocketAddress socketAddress) {
        super(socketAddress);
    }

    @Override
    public void onReceive(ByteBuffer buffer, InetSocketAddress socketAddress) throws NetException {
        BEncodeDecoder decoder = BEncodeDecoder.newInstance(buffer).next();
        if (decoder.isEmpty()) {
            LOGGER.warn("\u5904\u7406DHT\u6d88\u606f\u9519\u8bef\uff08\u683c\u5f0f\uff09\uff1a{}", decoder);
            return;
        }
        String y = decoder.getString("y");
        if ("q".equals(y)) {
            DhtRequest request = DhtRequest.valueOf(decoder);
            request.setSocketAddress(socketAddress);
            this.onRequest(request, socketAddress);
        } else if ("r".equals(y)) {
            DhtResponse response = DhtResponse.valueOf(decoder);
            response.setSocketAddress(socketAddress);
            this.onResponse(response);
        } else {
            LOGGER.warn("\u5904\u7406DHT\u6d88\u606f\u9519\u8bef\uff08\u672a\u77e5\u7c7b\u578b\uff09\uff1a{}", y);
        }
    }

    private void onRequest(DhtRequest request, InetSocketAddress socketAddress) {
        DhtResponse response;
        DhtConfig.QType type = request.getQ();
        if (type == null) {
            LOGGER.warn("\u5904\u7406DHT\u8bf7\u6c42\u5931\u8d25\uff08\u672a\u77e5\u7c7b\u578b\uff09\uff1a{}", new Object[]{type});
            response = DhtResponse.buildErrorResponse(request.getT(), DhtConfig.ErrorCode.CODE_204, "\u4e0d\u652f\u6301\u7684\u8bf7\u6c42\u7c7b\u578b");
        } else {
            LOGGER.debug("\u5904\u7406DHT\u8bf7\u6c42\uff1a{}", new Object[]{type});
            response = switch (type) {
                case DhtConfig.QType.PING -> this.ping(request);
                case DhtConfig.QType.FIND_NODE -> this.findNode(request);
                case DhtConfig.QType.GET_PEERS -> this.getPeers(request);
                case DhtConfig.QType.ANNOUNCE_PEER -> this.announcePeer(request);
                default -> {
                    LOGGER.warn("\u5904\u7406DHT\u8bf7\u6c42\u5931\u8d25\uff08\u7c7b\u578b\u672a\u9002\u914d\uff09\uff1a{}", new Object[]{type});
                    yield DhtResponse.buildErrorResponse(request.getT(), DhtConfig.ErrorCode.CODE_202, "\u672a\u9002\u914d\u7684\u8bf7\u6c42\u7c7b\u578b");
                }
            };
        }
        this.pushMessage(response, socketAddress);
    }

    private void onResponse(DhtResponse response) {
        DhtRequest request = DhtContext.getInstance().response(response);
        if (request == null) {
            LOGGER.warn("\u5904\u7406DHT\u54cd\u5e94\u5931\u8d25\uff1a\u6ca1\u6709\u5bf9\u5e94\u8bf7\u6c42", new Object[0]);
            return;
        }
        DhtConfig.QType type = request.getQ();
        if (type == null) {
            LOGGER.warn("\u5904\u7406DHT\u54cd\u5e94\u5931\u8d25\uff08\u672a\u77e5\u7c7b\u578b\uff09\uff1a{}", new Object[]{type});
            return;
        }
        if (!RESPONSE_SUCCESS.test(response)) {
            LOGGER.warn("\u5904\u7406DHT\u54cd\u5e94\u5931\u8d25\uff08\u5931\u8d25\u54cd\u5e94\uff09\uff1a{}", response);
            return;
        }
        LOGGER.debug("\u5904\u7406DHT\u54cd\u5e94\uff1a{}", new Object[]{type});
        switch (type) {
            case PING: {
                this.ping(request, response);
                break;
            }
            case FIND_NODE: {
                this.findNode(request, response);
                break;
            }
            case GET_PEERS: {
                this.getPeers(request, response);
                break;
            }
            case ANNOUNCE_PEER: {
                this.announcePeer(request, response);
                break;
            }
            default: {
                LOGGER.warn("\u5904\u7406DHT\u54cd\u5e94\u5931\u8d25\uff08\u7c7b\u578b\u672a\u9002\u914d\uff09\uff1a{}", new Object[]{type});
            }
        }
    }

    public NodeSession ping() {
        LOGGER.debug("\u53d1\u9001DHT\u8bf7\u6c42\uff1aping", new Object[0]);
        PingRequest request = PingRequest.newRequest();
        this.pushRequest(request, this.socketAddress);
        request.lockResponse();
        DhtResponse response = request.getResponse();
        if (RESPONSE_SUCCESS.test(response)) {
            return NodeContext.getInstance().newNodeSession(response.getNodeId(), this.socketAddress.getHostString(), this.socketAddress.getPort());
        }
        LOGGER.warn("\u53d1\u9001Ping\u8bf7\u6c42\u5931\u8d25\uff1a{}-{}", this.socketAddress, response);
        return null;
    }

    private DhtResponse ping(DhtRequest request) {
        return PingRequest.execute(request);
    }

    private void ping(DhtRequest request, DhtResponse response) {
        request.unlockResponse();
    }

    public void findNode(byte[] target) {
        LOGGER.debug("\u53d1\u9001DHT\u8bf7\u6c42\uff1afindNode", new Object[0]);
        FindNodeRequest request = FindNodeRequest.newRequest(target);
        this.pushRequest(request, this.socketAddress);
    }

    private DhtResponse findNode(DhtRequest request) {
        return FindNodeRequest.execute(request);
    }

    private void findNode(DhtRequest request, DhtResponse response) {
        FindNodeResponse.newInstance(response).getNodes();
    }

    public void getPeers(byte[] infoHash) {
        LOGGER.debug("\u53d1\u9001DHT\u8bf7\u6c42\uff1agetPeers", new Object[0]);
        GetPeersRequest request = GetPeersRequest.newRequest(infoHash);
        this.pushRequest(request, this.socketAddress);
    }

    private DhtResponse getPeers(DhtRequest request) {
        return GetPeersRequest.execute(request);
    }

    private void getPeers(DhtRequest request, DhtResponse response) {
        TorrentSession torrentSession;
        byte[] token;
        byte[] infoHash = request.getBytes("info_hash");
        String infoHashHex = StringUtils.hex(infoHash);
        GetPeersResponse getPeersResponse = GetPeersResponse.newInstance(response);
        if (getPeersResponse.hasPeers()) {
            getPeersResponse.getPeers(infoHashHex);
        }
        if (getPeersResponse.hasNodes()) {
            getPeersResponse.getNodes();
        }
        if ((token = getPeersResponse.getToken()) != null && (torrentSession = TorrentContext.getInstance().torrentSession(infoHashHex)) != null && torrentSession.uploadable()) {
            this.announcePeer(token, infoHash, request.getSocketAddress());
        }
    }

    public void announcePeer(byte[] token, byte[] infoHash) {
        this.announcePeer(token, infoHash, this.socketAddress);
    }

    private void announcePeer(byte[] token, byte[] infoHash, InetSocketAddress socketAddress) {
        LOGGER.debug("\u53d1\u9001DHT\u8bf7\u6c42\uff1aannouncePeer", new Object[0]);
        AnnouncePeerRequest request = AnnouncePeerRequest.newRequest(token, infoHash);
        this.pushRequest(request, socketAddress);
    }

    private DhtResponse announcePeer(DhtRequest request) {
        return AnnouncePeerRequest.execute(request);
    }

    private void announcePeer(DhtRequest request, DhtResponse response) {
        LOGGER.debug("\u5904\u7406DHT\u54cd\u5e94\uff1aAnnouncePeer", new Object[0]);
    }

    private void pushRequest(DhtRequest request, InetSocketAddress socketAddress) {
        request.setSocketAddress(socketAddress);
        DhtContext.getInstance().request(request);
        this.pushMessage(request, socketAddress);
    }

    private void pushMessage(DhtMessage message, InetSocketAddress socketAddress) {
        ByteBuffer buffer = ByteBuffer.wrap(message.toBytes());
        try {
            this.send(buffer, socketAddress);
        }
        catch (NetException e) {
            LOGGER.error("DHT\u6d88\u606f\u53d1\u9001\u5f02\u5e38", e);
        }
    }
}

