/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.dht;

import com.acgist.snail.config.DhtConfig;
import com.acgist.snail.format.BEncodeDecoder;
import com.acgist.snail.format.BEncodeEncoder;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.torrent.dht.DhtContext;
import com.acgist.snail.net.torrent.dht.DhtMessage;
import com.acgist.snail.net.torrent.dht.DhtResponse;
import com.acgist.snail.net.torrent.dht.NodeContext;
import com.acgist.snail.net.torrent.dht.NodeSession;
import com.acgist.snail.utils.BeanUtils;
import com.acgist.snail.utils.CollectionUtils;
import com.acgist.snail.utils.NetUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DhtRequest
extends DhtMessage {
    private static final Logger LOGGER = LoggerFactory.getLogger(DhtRequest.class);
    private final DhtConfig.QType q;
    private final Map<String, Object> a;
    private final long timestamp;
    private DhtResponse response;

    protected DhtRequest(DhtConfig.QType q) {
        this(DhtContext.getInstance().buildRequestId(), "q", q, new LinkedHashMap<String, Object>());
        this.put("id", NodeContext.getInstance().getNodeId());
    }

    private DhtRequest(byte[] t, String y, DhtConfig.QType q, Map<String, Object> a) {
        super(t, y);
        this.q = q;
        this.a = a;
        this.timestamp = System.currentTimeMillis();
    }

    public static final DhtRequest valueOf(BEncodeDecoder decoder) {
        byte[] t = decoder.getBytes("t");
        String y = decoder.getString("y");
        DhtConfig.QType q = DhtConfig.QType.of(decoder.getString("q"));
        Map<String, Object> a = decoder.getMap("a");
        return new DhtRequest(t, y, q, a);
    }

    public DhtConfig.QType getQ() {
        return this.q;
    }

    public Map<String, Object> getA() {
        return this.a;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public DhtResponse getResponse() {
        return this.response;
    }

    public void setResponse(DhtResponse response) {
        this.response = response;
    }

    public boolean hasResponse() {
        return this.response != null;
    }

    @Override
    public final Map<String, Object> get() {
        return this.a;
    }

    @Override
    public final void put(String key, Object value) {
        this.a.put(key, value);
    }

    @Override
    public final byte[] toBytes() {
        LinkedHashMap<String, Object> request = new LinkedHashMap<String, Object>();
        request.put("t", this.t);
        request.put("y", this.y);
        request.put("q", this.q.getValue());
        request.put("a", this.a);
        return BEncodeEncoder.encodeMap(request);
    }

    protected boolean nodesIPv4() {
        List<Object> want = this.getList("want");
        return this.nodesContain(want, "n4");
    }

    protected boolean nodesIPv6() {
        List<Object> want = this.getList("want");
        return this.nodesContain(want, "n6");
    }

    private boolean nodesContain(List<?> list, String value) {
        if (CollectionUtils.isEmpty(list)) {
            return false;
        }
        for (Object object : list) {
            byte[] bytes;
            if (!(object instanceof byte[]) || !value.equals(new String(bytes = (byte[])object))) continue;
            return true;
        }
        return false;
    }

    protected static final byte[] serializeNodes(List<NodeSession> nodes) {
        if (CollectionUtils.isEmpty(nodes)) {
            return new byte[0];
        }
        List availableNodes = nodes.stream().filter(node -> NetUtils.ip(node.getHost())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(availableNodes)) {
            return new byte[0];
        }
        ByteBuffer buffer = ByteBuffer.allocate(26 * availableNodes.size());
        for (NodeSession node2 : availableNodes) {
            buffer.put(node2.getId());
            buffer.putInt(NetUtils.ipToInt(node2.getHost()));
            buffer.putShort(NetUtils.portToShort(node2.getPort()));
        }
        return buffer.array();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockResponse() {
        if (!this.hasResponse()) {
            DhtRequest dhtRequest = this;
            synchronized (dhtRequest) {
                if (!this.hasResponse()) {
                    try {
                        this.wait(5000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        LOGGER.debug("\u7ebf\u7a0b\u7b49\u5f85\u5f02\u5e38", e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockResponse() {
        DhtRequest dhtRequest = this;
        synchronized (dhtRequest) {
            this.notifyAll();
        }
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.t);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof DhtRequest) {
            DhtRequest request = (DhtRequest)object;
            return Arrays.equals(this.t, request.t);
        }
        return false;
    }

    @Override
    public String toString() {
        return BeanUtils.toString(this, new Object[]{this.t, this.y, this.q, this.a});
    }
}

