/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.dht;

import com.acgist.snail.config.DhtConfig;
import com.acgist.snail.format.BEncodeDecoder;
import com.acgist.snail.format.BEncodeEncoder;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.torrent.dht.DhtMessage;
import com.acgist.snail.net.torrent.dht.NodeContext;
import com.acgist.snail.net.torrent.dht.NodeSession;
import com.acgist.snail.utils.BeanUtils;
import com.acgist.snail.utils.CollectionUtils;
import com.acgist.snail.utils.NetUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DhtResponse
extends DhtMessage {
    private static final Logger LOGGER = LoggerFactory.getLogger(DhtResponse.class);
    private final Map<String, Object> r;
    private final List<Object> e;

    protected DhtResponse(byte[] t) {
        this(t, "r", new LinkedHashMap<String, Object>(), null);
        this.put("id", NodeContext.getInstance().getNodeId());
    }

    protected DhtResponse(byte[] t, String y, Map<String, Object> r, List<Object> e) {
        super(t, y);
        this.r = r;
        this.e = e;
    }

    public static final DhtResponse valueOf(BEncodeDecoder decoder) {
        byte[] t = decoder.getBytes("t");
        String y = decoder.getString("y");
        Map<String, Object> r = decoder.getMap("r");
        List<Object> e = decoder.getList("e");
        return new DhtResponse(t, y, r, e);
    }

    public Map<String, Object> getR() {
        return this.r;
    }

    public List<Object> getE() {
        return this.e;
    }

    @Override
    protected Map<String, Object> get() {
        return this.r;
    }

    @Override
    public final void put(String key, Object value) {
        this.r.put(key, value);
    }

    @Override
    public final byte[] toBytes() {
        LinkedHashMap<String, Object> response = new LinkedHashMap<String, Object>();
        response.put("t", this.t);
        response.put("y", this.y);
        if (this.r != null) {
            response.put("r", this.r);
        }
        if (this.e != null) {
            response.put("e", this.e);
        }
        return BEncodeEncoder.encodeMap(response);
    }

    protected List<NodeSession> deserializeNodes(String key) {
        return DhtResponse.deserializeNodes(this.getBytes(key));
    }

    private static final List<NodeSession> deserializeNodes(byte[] bytes) {
        NodeSession session;
        if (bytes == null) {
            return List.of();
        }
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        ArrayList<NodeSession> list = new ArrayList<NodeSession>();
        while ((session = DhtResponse.deserializeNode(buffer)) != null) {
            list.add(session);
        }
        return list;
    }

    private static final NodeSession deserializeNode(ByteBuffer buffer) {
        if (buffer.hasRemaining()) {
            byte[] nodeId = new byte[20];
            buffer.get(nodeId);
            String host = NetUtils.intToIP(buffer.getInt());
            int port = NetUtils.portToInt(buffer.getShort());
            return NodeContext.getInstance().newNodeSession(nodeId, host, port);
        }
        return null;
    }

    public boolean success() {
        return CollectionUtils.isEmpty(this.e);
    }

    public int errorCode() {
        Object value = this.getErrorMessage(0);
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.intValue();
        }
        LOGGER.warn("DHT\u4e0d\u652f\u6301\u7684\u9519\u8bef\u7f16\u7801\u7c7b\u578b\uff1a{}", value);
        return DhtConfig.ErrorCode.CODE_201.getCode();
    }

    public String errorMessage() {
        Object value = this.getErrorMessage(1);
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            return new String(bytes);
        }
        if (value instanceof String) {
            String string = (String)value;
            return string;
        }
        LOGGER.warn("DHT\u4e0d\u652f\u6301\u7684\u9519\u8bef\u63cf\u8ff0\u7c7b\u578b\uff1a{}", value);
        return "\u672a\u77e5\u9519\u8bef";
    }

    private Object getErrorMessage(int index) {
        if (this.e != null && this.e.size() > index) {
            return this.e.get(index);
        }
        return null;
    }

    public static final DhtResponse buildErrorResponse(byte[] id, DhtConfig.ErrorCode code, String message) {
        return DhtResponse.buildErrorResponse(id, code.getCode(), message);
    }

    public static final DhtResponse buildErrorResponse(byte[] id, int code, String message) {
        List<Object> list = List.of(Integer.valueOf(code), message);
        return new DhtResponse(id, "r", null, list);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.t);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof DhtResponse) {
            DhtResponse response = (DhtResponse)object;
            return Arrays.equals(this.t, response.t);
        }
        return false;
    }

    @Override
    public String toString() {
        return BeanUtils.toString(this, this.t, this.y, this.r, this.e);
    }
}

