/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.dht;

import com.acgist.snail.config.DhtConfig;
import com.acgist.snail.config.SymbolConfig;
import com.acgist.snail.context.IContext;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.torrent.dht.DhtClient;
import com.acgist.snail.net.torrent.dht.NodeSession;
import com.acgist.snail.utils.ArrayUtils;
import com.acgist.snail.utils.NetUtils;
import com.acgist.snail.utils.NumberUtils;
import com.acgist.snail.utils.StringUtils;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.CRC32C;

public final class NodeContext
implements IContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeContext.class);
    private static final NodeContext INSTANCE = new NodeContext();
    private static final int MAX_NODE_SIZE = 8;
    private static final byte[] IPV4_MASK = NumberUtils.intToBytes(0x30F3FFF);
    private static final byte[] IPV6_MASK = NumberUtils.longToBytes(72909780498219007L);
    private final byte[] nodeId = ArrayUtils.random(20);
    private final List<NodeSession> nodes = new ArrayList<NodeSession>();

    public static final NodeContext getInstance() {
        return INSTANCE;
    }

    private NodeContext() {
        this.register();
    }

    public byte[] getNodeId() {
        return this.nodeId;
    }

    public byte[] buildNodeId(String ip) {
        LOGGER.debug("\u751f\u6210NodeId\uff1a{}", ip);
        byte[] ipBytes = NetUtils.ipToBytes(ip);
        byte[] mask = ipBytes.length == 4 ? IPV4_MASK : IPV6_MASK;
        int length = mask.length;
        for (int index = 0; index < length; ++index) {
            int n = index;
            ipBytes[n] = (byte)(ipBytes[n] & mask[index]);
        }
        SecureRandom random = NumberUtils.random();
        byte rand = (byte)random.nextInt();
        byte r = (byte)(rand & 7);
        CRC32C crc32c = new CRC32C();
        ipBytes[0] = (byte)(ipBytes[0] | r << 5);
        crc32c.update(ipBytes, 0, length);
        int crc = (int)crc32c.getValue();
        this.nodeId[0] = (byte)(crc >> 24);
        this.nodeId[1] = (byte)(crc >> 16);
        this.nodeId[2] = (byte)(crc >> 8 & 0xF8 | random.nextInt() & 7);
        System.arraycopy(ArrayUtils.random(16), 0, this.nodeId, 3, 16);
        this.nodeId[19] = rand;
        return this.nodeId;
    }

    private void register() {
        char colon = SymbolConfig.Symbol.COLON.toChar();
        DhtConfig.getInstance().getNodes().forEach((nodeId, address) -> {
            int index = address.lastIndexOf(colon);
            if (index > 0) {
                String host = address.substring(0, index);
                String port = address.substring(index + 1);
                if (StringUtils.isNotEmpty(host) && StringUtils.isNumeric(port)) {
                    this.newNodeSession(StringUtils.unhex(nodeId), host, Integer.valueOf(port));
                } else {
                    LOGGER.warn("\u6ce8\u518c\u9ed8\u8ba4DHT\u8282\u70b9\u5931\u8d25\uff1a{} - {}", nodeId, address);
                }
            } else {
                LOGGER.warn("\u6ce8\u518c\u9ed8\u8ba4DHT\u8282\u70b9\u5931\u8d25\uff1a{} - {}", nodeId, address);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NodeSession> nodes() {
        List<NodeSession> list = this.nodes;
        synchronized (list) {
            return new ArrayList<NodeSession>(this.nodes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NodeSession> resize() {
        List<NodeSession> list = this.nodes;
        synchronized (list) {
            int oldSize = this.nodes.size();
            if (oldSize < 1024) {
                return this.nodes();
            }
            SecureRandom random = NumberUtils.random();
            Iterator<NodeSession> iterator = this.nodes.iterator();
            while (iterator.hasNext()) {
                boolean remove;
                NodeSession session = iterator.next();
                if (!(remove = (switch (session.getStatus()) {
                    case NodeSession.Status.UNUSE -> {
                        if (random.nextInt(oldSize) >= 1024) {
                            yield true;
                        }
                        yield false;
                    }
                    case NodeSession.Status.VERIFY -> true;
                    default -> false;
                }))) continue;
                iterator.remove();
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u6574\u7406\u8282\u70b9\u957f\u5ea6\uff1a{} - {}", oldSize, this.nodes.size());
            }
            return this.nodes();
        }
    }

    public NodeSession newNodeSession(String host, Integer port) {
        DhtClient client = DhtClient.newInstance(host, port);
        NodeSession nodeSession = client.ping();
        if (nodeSession != null) {
            nodeSession.setStatus(NodeSession.Status.AVAILABLE);
        }
        return nodeSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeSession newNodeSession(byte[] nodeId, String host, Integer port) {
        if (nodeId.length != 20) {
            LOGGER.warn("\u6dfb\u52a0Node\u5931\u8d25\uff1a{} - {} - {}", nodeId, host, port);
            return null;
        }
        List<NodeSession> list = this.nodes;
        synchronized (list) {
            int[] nodeIndex = this.close(nodeId);
            int index = nodeIndex[0];
            int signum = nodeIndex[1];
            if (signum == 0) {
                return this.nodes.get(index);
            }
            NodeSession nodeSession = NodeSession.newInstance(nodeId, host, port);
            LOGGER.debug("\u6dfb\u52a0Node\uff1a{}", nodeSession);
            this.nodes.add(index, nodeSession);
            return nodeSession;
        }
    }

    public List<NodeSession> findNode(String target) {
        return this.findNode(StringUtils.unhex(target));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NodeSession> findNode(byte[] target) {
        ArrayList<NodeSession> closeNodes;
        List<NodeSession> list = this.nodes;
        synchronized (list) {
            int nodeSize = this.nodes.size();
            if (nodeSize <= 8) {
                closeNodes = this.nodes.stream().filter(NodeSession::useable).collect(Collectors.toList());
            } else {
                closeNodes = new ArrayList();
                int[] nodeIndex = this.close(target);
                int index = nodeIndex[0];
                int size = 0;
                int leftPos = 1;
                int rightPos = 0;
                while (size < 8 && leftPos + rightPos < nodeSize) {
                    NodeSession leftNode = this.select(index - leftPos, nodeSize);
                    if (leftNode.useable()) {
                        ++size;
                        closeNodes.add(0, leftNode);
                    }
                    ++leftPos;
                    NodeSession rightNode = this.select(index + rightPos, nodeSize);
                    if (rightNode.useable()) {
                        ++size;
                        closeNodes.add(rightNode);
                    }
                    ++rightPos;
                }
            }
        }
        return closeNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void available(byte[] nodeId) {
        List<NodeSession> list = this.nodes;
        synchronized (list) {
            NodeSession node = this.select(nodeId);
            if (node != null) {
                node.setStatus(NodeSession.Status.AVAILABLE);
            }
        }
    }

    private NodeSession select(int index, int nodeSize) {
        if (index < 0) {
            index += nodeSize;
        } else if (index >= nodeSize) {
            index -= nodeSize;
        }
        return this.nodes.get(index);
    }

    private NodeSession select(byte[] nodeId) {
        for (NodeSession nodeSession : this.nodes) {
            if (!Arrays.equals(nodeId, nodeSession.getId())) continue;
            return nodeSession;
        }
        return null;
    }

    private int[] close(byte[] nodeId) {
        NodeSession nodeSession;
        int index = 0;
        int signum = 1;
        for (int jndex = 0; jndex < this.nodes.size() && (signum = Arrays.compareUnsigned(nodeId, (nodeSession = this.nodes.get(jndex)).getId())) > 0; ++jndex) {
            index = jndex + 1;
        }
        return new int[]{index, signum};
    }
}

