/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.dht;

import com.acgist.snail.utils.BeanUtils;
import java.util.Arrays;

public final class NodeSession
implements Comparable<NodeSession> {
    private final byte[] id;
    private final String host;
    private final int port;
    private Status status;

    private NodeSession(byte[] id, String host, int port) {
        this.id = id;
        this.host = host;
        this.port = port;
        this.status = Status.UNUSE;
    }

    public static final NodeSession newInstance(byte[] id, String host, int port) {
        return new NodeSession(id, host, port);
    }

    public boolean useable() {
        return this.status != Status.VERIFY;
    }

    public boolean markVerify() {
        if (this.status == Status.UNUSE) {
            this.status = Status.VERIFY;
        }
        return true;
    }

    public byte[] getId() {
        return this.id;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    @Override
    public int compareTo(NodeSession target) {
        return Arrays.compareUnsigned(this.id, target.id);
    }

    public int hashCode() {
        return Arrays.hashCode(this.id);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof NodeSession) {
            NodeSession session = (NodeSession)object;
            return Arrays.equals(this.id, session.id);
        }
        return false;
    }

    public String toString() {
        return BeanUtils.toString(this, this.id, this.host, this.port);
    }

    public static enum Status {
        UNUSE,
        VERIFY,
        AVAILABLE;

    }
}

