/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.dht.request;

import com.acgist.snail.config.DhtConfig;
import com.acgist.snail.config.PeerConfig;
import com.acgist.snail.config.SystemConfig;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.torrent.TorrentContext;
import com.acgist.snail.net.torrent.TorrentSession;
import com.acgist.snail.net.torrent.dht.DhtContext;
import com.acgist.snail.net.torrent.dht.DhtRequest;
import com.acgist.snail.net.torrent.dht.DhtResponse;
import com.acgist.snail.net.torrent.dht.response.AnnouncePeerResponse;
import com.acgist.snail.net.torrent.peer.PeerContext;
import com.acgist.snail.net.torrent.peer.PeerSession;
import com.acgist.snail.utils.StringUtils;
import java.net.InetSocketAddress;
import java.util.Arrays;

public final class AnnouncePeerRequest
extends DhtRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnouncePeerRequest.class);

    private AnnouncePeerRequest() {
        super(DhtConfig.QType.ANNOUNCE_PEER);
    }

    public static final AnnouncePeerRequest newRequest(byte[] token, byte[] infoHash) {
        AnnouncePeerRequest request = new AnnouncePeerRequest();
        request.put("port", SystemConfig.getTorrentPortExt());
        request.put("token", token);
        request.put("info_hash", infoHash);
        request.put("implied_port", DhtConfig.IMPLIED_PORT_AUTO);
        return request;
    }

    public static final AnnouncePeerResponse execute(DhtRequest request) {
        byte[] token = request.getBytes("token");
        if (!Arrays.equals(token, DhtContext.getInstance().token())) {
            return AnnouncePeerResponse.newInstance(DhtResponse.buildErrorResponse(request.getT(), DhtConfig.ErrorCode.CODE_203, "Token\u9519\u8bef"));
        }
        byte[] infoHash = request.getBytes("info_hash");
        String infoHashHex = StringUtils.hex(infoHash);
        TorrentSession torrentSession = TorrentContext.getInstance().torrentSession(infoHashHex);
        if (torrentSession != null) {
            Integer peerPort = request.getInteger("port");
            Integer impliedPort = request.getInteger("implied_port");
            InetSocketAddress socketAddress = request.getSocketAddress();
            String peerHost = socketAddress.getHostString();
            boolean impliedPortAuto = DhtConfig.IMPLIED_PORT_AUTO.equals(impliedPort);
            if (impliedPortAuto) {
                peerPort = socketAddress.getPort();
            }
            PeerSession peerSession = PeerContext.getInstance().newPeerSession(infoHashHex, torrentSession.statistics(), peerHost, peerPort, PeerConfig.Source.DHT);
            if (impliedPortAuto) {
                peerSession.flags((byte)4);
            }
        } else {
            LOGGER.debug("\u58f0\u660ePeer\u79cd\u5b50\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a{}", infoHashHex);
        }
        return AnnouncePeerResponse.newInstance(request);
    }
}

