/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.dht.request;

import com.acgist.snail.config.DhtConfig;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.torrent.TorrentContext;
import com.acgist.snail.net.torrent.TorrentSession;
import com.acgist.snail.net.torrent.dht.DhtRequest;
import com.acgist.snail.net.torrent.dht.NodeContext;
import com.acgist.snail.net.torrent.dht.NodeSession;
import com.acgist.snail.net.torrent.dht.response.GetPeersResponse;
import com.acgist.snail.net.torrent.peer.PeerContext;
import com.acgist.snail.net.torrent.peer.PeerSession;
import com.acgist.snail.utils.CollectionUtils;
import com.acgist.snail.utils.NetUtils;
import com.acgist.snail.utils.StringUtils;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.stream.Collectors;

public final class GetPeersRequest
extends DhtRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetPeersRequest.class);

    private GetPeersRequest() {
        super(DhtConfig.QType.GET_PEERS);
    }

    public static final GetPeersRequest newRequest(byte[] infoHash) {
        GetPeersRequest request = new GetPeersRequest();
        request.put("info_hash", infoHash);
        return request;
    }

    public static final GetPeersResponse execute(DhtRequest request) {
        boolean needNodes = true;
        GetPeersResponse response = GetPeersResponse.newInstance(request);
        byte[] infoHash = request.getBytes("info_hash");
        String infoHashHex = StringUtils.hex(infoHash);
        TorrentSession torrentSession = TorrentContext.getInstance().torrentSession(infoHashHex);
        if (torrentSession != null) {
            ByteBuffer buffer = ByteBuffer.allocate(6);
            List<PeerSession> list = PeerContext.getInstance().listPeerSession(infoHashHex);
            if (CollectionUtils.isNotEmpty(list)) {
                needNodes = false;
                List values = list.stream().filter(PeerSession::available).filter(PeerSession::connected).limit(32L).map(peer -> {
                    buffer.putInt(NetUtils.ipToInt(peer.host()));
                    buffer.putShort(NetUtils.portToShort(peer.port()));
                    buffer.flip();
                    return buffer.array();
                }).collect(Collectors.toList());
                response.put("values", values);
            }
        } else {
            LOGGER.debug("\u67e5\u627ePeer\u79cd\u5b50\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a{}", infoHashHex);
        }
        if (needNodes) {
            List<NodeSession> nodes = NodeContext.getInstance().findNode(infoHash);
            response.put("nodes", GetPeersRequest.serializeNodes(nodes));
        }
        return response;
    }
}

