/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.dht.response;

import com.acgist.snail.config.PeerConfig;
import com.acgist.snail.net.torrent.TorrentContext;
import com.acgist.snail.net.torrent.TorrentSession;
import com.acgist.snail.net.torrent.dht.DhtContext;
import com.acgist.snail.net.torrent.dht.DhtRequest;
import com.acgist.snail.net.torrent.dht.DhtResponse;
import com.acgist.snail.net.torrent.dht.NodeSession;
import com.acgist.snail.net.torrent.peer.PeerContext;
import com.acgist.snail.net.torrent.peer.PeerSession;
import com.acgist.snail.utils.NetUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public final class GetPeersResponse
extends DhtResponse {
    private GetPeersResponse(byte[] t) {
        super(t);
        this.put("token", DhtContext.getInstance().token());
    }

    private GetPeersResponse(DhtResponse response) {
        super(response.getT(), response.getY(), response.getR(), response.getE());
    }

    public static final GetPeersResponse newInstance(DhtRequest request) {
        return new GetPeersResponse(request.getT());
    }

    public static final GetPeersResponse newInstance(DhtResponse response) {
        return new GetPeersResponse(response);
    }

    public byte[] getToken() {
        return this.getBytes("token");
    }

    public List<NodeSession> getNodes() {
        return this.deserializeNodes("nodes");
    }

    public List<PeerSession> getPeers(String infoHashHex) {
        return this.getValues(infoHashHex);
    }

    public List<PeerSession> getValues(String infoHashHex) {
        TorrentSession torrentSession = TorrentContext.getInstance().torrentSession(infoHashHex);
        if (torrentSession == null) {
            return List.of();
        }
        List<Object> values = this.getList("values");
        if (values == null) {
            return List.of();
        }
        ByteBuffer buffer = ByteBuffer.allocate(6);
        ArrayList<PeerSession> list = new ArrayList<PeerSession>();
        for (Object object : values) {
            buffer.put((byte[])object);
            buffer.flip();
            PeerSession session = PeerContext.getInstance().newPeerSession(infoHashHex, torrentSession.statistics(), NetUtils.intToIP(buffer.getInt()), NetUtils.portToInt(buffer.getShort()), PeerConfig.Source.DHT);
            buffer.flip();
            list.add(session);
        }
        return list;
    }

    public boolean hasNodes() {
        return this.get("nodes") != null;
    }

    public boolean hasPeers() {
        return this.hasValues();
    }

    public boolean hasValues() {
        return this.get("values") != null;
    }
}

