/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.lsd;

import com.acgist.snail.config.PeerConfig;
import com.acgist.snail.config.SymbolConfig;
import com.acgist.snail.config.SystemConfig;
import com.acgist.snail.context.wrapper.HeaderWrapper;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.NetException;
import com.acgist.snail.net.UdpClient;
import com.acgist.snail.net.torrent.lsd.LocalServiceDiscoveryMessageHandler;
import com.acgist.snail.net.torrent.lsd.LocalServiceDiscoveryServer;
import com.acgist.snail.utils.ArrayUtils;
import com.acgist.snail.utils.NetUtils;
import com.acgist.snail.utils.StringUtils;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;

public final class LocalServiceDiscoveryClient
extends UdpClient<LocalServiceDiscoveryMessageHandler> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalServiceDiscoveryClient.class);
    private static final String PROTOCOL = "BT-SEARCH * HTTP/1.1";

    private LocalServiceDiscoveryClient(InetSocketAddress socketAddress) {
        super("LSD Client", new LocalServiceDiscoveryMessageHandler(socketAddress));
    }

    public static final LocalServiceDiscoveryClient newInstance() {
        return new LocalServiceDiscoveryClient(NetUtils.buildSocketAddress(LocalServiceDiscoveryServer.lsdHost(), 6771));
    }

    @Override
    public boolean open() {
        return this.open((DatagramChannel)LocalServiceDiscoveryServer.getInstance().getChannel());
    }

    public void localSearch(String ... infoHashs) {
        if (ArrayUtils.isEmpty(infoHashs)) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u53d1\u9001\u672c\u5730\u53d1\u73b0\u6d88\u606f\uff08InfoHash\uff09\uff1a{}", SymbolConfig.Symbol.COMMA.join(infoHashs));
        }
        try {
            this.send(this.buildMessage(infoHashs));
        }
        catch (NetException e) {
            LOGGER.error("\u53d1\u9001\u672c\u5730\u53d1\u73b0\u6d88\u606f\u5f02\u5e38", e);
        }
    }

    private String buildMessage(String ... infoHashs) {
        String peerId = StringUtils.hex(PeerConfig.getInstance().getPeerId());
        HeaderWrapper builder = HeaderWrapper.newBuilder(PROTOCOL);
        builder.setHeader("Host", SymbolConfig.Symbol.COLON.join(LocalServiceDiscoveryServer.lsdHost(), 6771)).setHeader("Port", String.valueOf(SystemConfig.getTorrentPort())).setHeader("Cookie", peerId);
        for (String infoHash : infoHashs) {
            builder.setHeader("Infohash", infoHash);
        }
        return builder.build();
    }
}

