/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.lsd;

import com.acgist.snail.config.PeerConfig;
import com.acgist.snail.context.wrapper.HeaderWrapper;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.UdpMessageHandler;
import com.acgist.snail.net.codec.IMessageDecoder;
import com.acgist.snail.net.codec.StringMessageCodec;
import com.acgist.snail.net.torrent.TorrentContext;
import com.acgist.snail.net.torrent.TorrentSession;
import com.acgist.snail.net.torrent.peer.PeerContext;
import com.acgist.snail.utils.CollectionUtils;
import com.acgist.snail.utils.StringUtils;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.List;

public final class LocalServiceDiscoveryMessageHandler
extends UdpMessageHandler
implements IMessageDecoder<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalServiceDiscoveryMessageHandler.class);
    public static final String HEADER_HOST = "Host";
    public static final String HEADER_PORT = "Port";
    public static final String HEADER_COOKIE = "Cookie";
    public static final String HEADER_INFOHASH = "Infohash";

    public LocalServiceDiscoveryMessageHandler() {
        this(null);
    }

    public LocalServiceDiscoveryMessageHandler(InetSocketAddress socketAddress) {
        super(socketAddress);
        this.messageDecoder = new StringMessageCodec(this);
    }

    @Override
    public void onMessage(String message, InetSocketAddress address) {
        HeaderWrapper headers = HeaderWrapper.newInstance(message);
        String host = address.getHostString();
        String port = headers.getHeader(HEADER_PORT);
        String cookie = headers.getHeader(HEADER_COOKIE);
        List<String> list = headers.getHeaderList(HEADER_INFOHASH);
        if (StringUtils.isNumeric(port) && CollectionUtils.isNotEmpty(list)) {
            byte[] peerId = StringUtils.unhex(cookie);
            if (Arrays.equals(peerId, PeerConfig.getInstance().getPeerId())) {
                LOGGER.debug("\u672c\u5730\u53d1\u73b0\u6d88\u606f\u5904\u7406\u5931\u8d25\uff1a\u5ffd\u7565\u672c\u673a", new Object[0]);
            } else {
                list.forEach(infoHashHex -> this.doInfoHash(host, port, (String)infoHashHex));
            }
        } else {
            LOGGER.debug("\u672c\u5730\u53d1\u73b0\u6d88\u606f\u5904\u7406\u5931\u8d25\uff1a{}", message);
        }
    }

    private void doInfoHash(String host, String port, String infoHashHex) {
        TorrentSession torrentSession = TorrentContext.getInstance().torrentSession(infoHashHex);
        if (torrentSession == null) {
            LOGGER.debug("\u672c\u5730\u53d1\u73b0\u6d88\u606f\u5904\u7406\u5931\u8d25\uff08\u79cd\u5b50\u4fe1\u606f\u4e0d\u5b58\u5728\uff09\uff1a{}", infoHashHex);
        } else {
            LOGGER.debug("\u672c\u5730\u53d1\u73b0\u6d88\u606f\uff1a{} - {} - {}", infoHashHex, host, port);
            PeerContext.getInstance().newPeerSession(infoHashHex, torrentSession.statistics(), host, Integer.valueOf(port), PeerConfig.Source.LSD);
        }
    }
}

