/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.lsd;

import com.acgist.snail.config.SystemConfig;
import com.acgist.snail.context.SystemThreadContext;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.UdpServer;
import com.acgist.snail.net.torrent.TorrentContext;
import com.acgist.snail.net.torrent.lsd.LocalServiceDiscoveryAcceptHandler;
import com.acgist.snail.net.torrent.lsd.LocalServiceDiscoveryClient;
import com.acgist.snail.utils.NetUtils;
import java.util.concurrent.TimeUnit;

public final class LocalServiceDiscoveryServer
extends UdpServer<LocalServiceDiscoveryAcceptHandler> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalServiceDiscoveryServer.class);
    private static final LocalServiceDiscoveryServer INSTANCE = new LocalServiceDiscoveryServer();
    public static final int LSD_PORT = 6771;
    private static final String LSD_HOST_IPV4 = "239.192.152.143";
    private static final String LSD_HOST_IPV6 = "[ff15::efc0:988f]";

    public static final LocalServiceDiscoveryServer getInstance() {
        return INSTANCE;
    }

    private LocalServiceDiscoveryServer() {
        super(6771, true, "LSD Server", LocalServiceDiscoveryAcceptHandler.getInstance());
        this.join(2, LocalServiceDiscoveryServer.lsdHost());
        this.handle();
        int interval = SystemConfig.getLsdInterval();
        SystemThreadContext.scheduledAtFixedDelay(interval, interval, TimeUnit.SECONDS, this::multicast);
    }

    private void multicast() {
        LocalServiceDiscoveryClient client = LocalServiceDiscoveryClient.newInstance();
        TorrentContext.getInstance().allTorrentSession().forEach(session -> {
            if (session.privateTorrent()) {
                LOGGER.debug("\u79c1\u6709\u79cd\u5b50\uff08\u7981\u6b62\u53d1\u9001\u672c\u5730\u53d1\u73b0\u6d88\u606f\uff09\uff1a{}", session.infoHashHex());
            } else {
                LOGGER.debug("\u53d1\u9001\u672c\u5730\u53d1\u73b0\u6d88\u606f\uff1a{}", session.infoHashHex());
                client.localSearch(session.infoHashHex());
            }
        });
    }

    public static final String lsdHost() {
        if (NetUtils.localIPv4()) {
            return LSD_HOST_IPV4;
        }
        return LSD_HOST_IPV6;
    }
}

