/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.peer;

import com.acgist.snail.config.PeerConfig;
import com.acgist.snail.config.SystemConfig;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.torrent.TorrentSession;
import com.acgist.snail.net.torrent.peer.IExtensionMessageHandler;
import com.acgist.snail.net.torrent.peer.PeerSession;
import com.acgist.snail.net.torrent.peer.PeerSubMessageHandler;
import com.acgist.snail.utils.NetUtils;
import com.acgist.snail.utils.NumberUtils;
import java.nio.ByteBuffer;

public final class DhtExtensionMessageHandler
implements IExtensionMessageHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DhtExtensionMessageHandler.class);
    private final PeerSession peerSession;
    private final TorrentSession torrentSession;
    private final PeerSubMessageHandler peerSubMessageHandler;

    private DhtExtensionMessageHandler(PeerSession peerSession, TorrentSession torrentSession, PeerSubMessageHandler peerSubMessageHandler) {
        this.peerSession = peerSession;
        this.torrentSession = torrentSession;
        this.peerSubMessageHandler = peerSubMessageHandler;
    }

    public static final DhtExtensionMessageHandler newInstance(PeerSession peerSession, TorrentSession torrentSession, PeerSubMessageHandler peerSubMessageHandler) {
        return new DhtExtensionMessageHandler(peerSession, torrentSession, peerSubMessageHandler);
    }

    @Override
    public void onMessage(ByteBuffer buffer) {
        this.port(buffer);
    }

    public void port() {
        LOGGER.debug("\u53d1\u9001DHT\u6d88\u606f", new Object[0]);
        byte[] bytes = NumberUtils.shortToBytes(SystemConfig.getTorrentPortExtShort());
        this.peerSubMessageHandler.pushMessage(PeerConfig.Type.DHT, bytes);
    }

    private void port(ByteBuffer buffer) {
        int port = NetUtils.portToInt(buffer.getShort());
        String host = this.peerSession.host();
        LOGGER.debug("\u5904\u7406DHT\u6d88\u606f\uff1a{} - {}", host, port);
        this.peerSession.dhtPort(port);
        this.torrentSession.newNode(host, port);
    }
}

