/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.peer;

import com.acgist.snail.config.CryptConfig;
import com.acgist.snail.config.PeerConfig;
import com.acgist.snail.config.SystemConfig;
import com.acgist.snail.format.BEncodeDecoder;
import com.acgist.snail.format.BEncodeEncoder;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.NetException;
import com.acgist.snail.net.PacketSizeException;
import com.acgist.snail.net.torrent.InfoHash;
import com.acgist.snail.net.torrent.TorrentSession;
import com.acgist.snail.net.torrent.peer.IExtensionMessageHandler;
import com.acgist.snail.net.torrent.peer.PeerSession;
import com.acgist.snail.net.torrent.peer.PeerSubMessageHandler;
import com.acgist.snail.net.torrent.peer.extension.DontHaveExtensionMessageHandler;
import com.acgist.snail.net.torrent.peer.extension.HolepunchMessageHnadler;
import com.acgist.snail.net.torrent.peer.extension.MetadataMessageHandler;
import com.acgist.snail.net.torrent.peer.extension.PeerExchangeMessageHandler;
import com.acgist.snail.net.torrent.peer.extension.UploadOnlyExtensionMessageHandler;
import com.acgist.snail.utils.MapUtils;
import com.acgist.snail.utils.NetUtils;
import com.acgist.snail.utils.StringUtils;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ExtensionMessageHandler
implements IExtensionMessageHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtensionMessageHandler.class);
    private static final int PREFER_PLAINTEXT = 0;
    private static final int PREFER_ENCRYPT = 1;
    private static final int UPLOAD_ONLY = 1;
    private static final int DEFAULT_REQQ = 128;
    private static final String EX_M = "m";
    private static final String EX_V = "v";
    private static final String EX_P = "p";
    private static final String EX_E = "e";
    private static final String EX_REQQ = "reqq";
    private static final String EX_IPV4 = "ipv4";
    private static final String EX_IPV6 = "ipv6";
    private static final String EX_YOURIP = "yourip";
    private static final String EX_UPLOAD_ONLY = "upload_only";
    private static final String EX_METADATA_SIZE = "metadata_size";
    private volatile boolean handshakeSend = false;
    private volatile boolean handshakeRecv = false;
    private final InfoHash infoHash;
    private final PeerSession peerSession;
    private final TorrentSession torrentSession;
    private final PeerSubMessageHandler peerSubMessageHandler;
    private final MetadataMessageHandler metadataMessageHandler;
    private final HolepunchMessageHnadler holepunchMessageHnadler;
    private final PeerExchangeMessageHandler peerExchangeMessageHandler;
    private final DontHaveExtensionMessageHandler dontHaveExtensionMessageHandler;
    private final UploadOnlyExtensionMessageHandler uploadOnlyExtensionMessageHandler;

    private ExtensionMessageHandler(PeerSession peerSession, TorrentSession torrentSession, PeerSubMessageHandler peerSubMessageHandler) {
        this.infoHash = torrentSession.infoHash();
        this.peerSession = peerSession;
        this.torrentSession = torrentSession;
        this.peerSubMessageHandler = peerSubMessageHandler;
        this.metadataMessageHandler = MetadataMessageHandler.newInstance(peerSession, torrentSession, this);
        this.holepunchMessageHnadler = HolepunchMessageHnadler.newInstance(peerSession, torrentSession, this);
        this.peerExchangeMessageHandler = PeerExchangeMessageHandler.newInstance(peerSession, torrentSession, this);
        this.dontHaveExtensionMessageHandler = DontHaveExtensionMessageHandler.newInstance(peerSession, this);
        this.uploadOnlyExtensionMessageHandler = UploadOnlyExtensionMessageHandler.newInstance(peerSession, this);
    }

    public static final ExtensionMessageHandler newInstance(PeerSession peerSession, TorrentSession torrentSession, PeerSubMessageHandler peerSubMessageHandler) {
        return new ExtensionMessageHandler(peerSession, torrentSession, peerSubMessageHandler);
    }

    @Override
    public void onMessage(ByteBuffer buffer) throws NetException {
        byte typeId = buffer.get();
        PeerConfig.ExtensionType extensionType = PeerConfig.ExtensionType.of(typeId);
        if (extensionType == null) {
            LOGGER.warn("\u5904\u7406\u6269\u5c55\u6d88\u606f\u9519\u8bef\uff08\u672a\u77e5\u7c7b\u578b\uff09\uff1a{}", typeId);
            return;
        }
        LOGGER.debug("\u5904\u7406\u6269\u5c55\u6d88\u606f\u7c7b\u578b\uff1a{}", new Object[]{extensionType});
        switch (extensionType) {
            case HANDSHAKE: {
                this.handshake(buffer);
                break;
            }
            case UT_PEX: {
                this.pex(buffer);
                break;
            }
            case UT_METADATA: {
                this.metadata(buffer);
                break;
            }
            case UT_HOLEPUNCH: {
                this.holepunch(buffer);
                break;
            }
            case UPLOAD_ONLY: {
                this.uploadOnly(buffer);
                break;
            }
            case LT_DONTHAVE: {
                this.dontHave(buffer);
                break;
            }
            default: {
                LOGGER.warn("\u5904\u7406\u6269\u5c55\u6d88\u606f\u9519\u8bef\uff08\u7c7b\u578b\u672a\u9002\u914d\uff09\uff1a{}", new Object[]{extensionType});
            }
        }
    }

    public void handshake() {
        int metadataSize;
        LOGGER.debug("\u53d1\u9001\u6269\u5c55\u6d88\u606f-\u63e1\u624b", new Object[0]);
        this.handshakeSend = true;
        LinkedHashMap<String, Object> message = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Byte> supportTypes = new LinkedHashMap<String, Byte>();
        for (PeerConfig.ExtensionType type : PeerConfig.ExtensionType.values()) {
            if (!type.getSupport() || !type.getNotice()) continue;
            supportTypes.put(type.getValue(), type.getId());
        }
        message.put(EX_M, supportTypes);
        if (!this.handshakeRecv) {
            message.put(EX_P, SystemConfig.getTorrentPortExt());
        }
        message.put(EX_V, SystemConfig.getNameEnAndVersion());
        message.put(EX_E, CryptConfig.STRATEGY.getCrypt() ? 1 : 0);
        String yourip = SystemConfig.getExternalIPAddress();
        if (StringUtils.isNotEmpty(yourip)) {
            message.put(EX_YOURIP, NetUtils.ipToBytes(yourip));
        }
        message.put(EX_REQQ, 128);
        if (PeerConfig.ExtensionType.UT_METADATA.getNotice() && (metadataSize = this.infoHash.getSize()) > 0) {
            message.put(EX_METADATA_SIZE, metadataSize);
        }
        if (this.torrentSession.completed()) {
            message.put(EX_UPLOAD_ONLY, 1);
        }
        this.pushMessage(PeerConfig.ExtensionType.HANDSHAKE.getId(), BEncodeEncoder.encodeMap(message));
    }

    private void handshake(ByteBuffer buffer) throws PacketSizeException {
        Map<String, Object> supportTypes;
        String clientName;
        Long metadataSize;
        Long uploadOnly;
        Long encrypt;
        LOGGER.debug("\u5904\u7406\u6269\u5c55\u6d88\u606f-\u63e1\u624b", new Object[0]);
        this.handshakeRecv = true;
        BEncodeDecoder decoder = BEncodeDecoder.newInstance(buffer).next();
        if (decoder.isEmpty()) {
            LOGGER.warn("\u5904\u7406\u6269\u5c55\u6d88\u606f-\u63e1\u624b\u5931\u8d25\uff08\u683c\u5f0f\uff09\uff1a{}", decoder);
            return;
        }
        Long port = decoder.getLong(EX_P);
        if (port != null) {
            int newPort = port.intValue();
            Integer oldPort = this.peerSession.port();
            if (oldPort == null) {
                this.peerSession.port(newPort);
            } else if (oldPort != newPort) {
                LOGGER.debug("\u5904\u7406\u6269\u5c55\u6d88\u606f-\u63e1\u624b\uff08\u7aef\u53e3\u4e0d\u4e00\u81f4\uff09\uff1a{}-{}", oldPort, newPort);
            }
        }
        byte[] ipv4 = decoder.getBytes(EX_IPV4);
        byte[] ipv6 = decoder.getBytes(EX_IPV6);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u5904\u7406\u6269\u5c55\u6d88\u606f-Peer\u504f\u7231\u5730\u5740\uff1a{}-{}-{}", this.peerSession.host(), NetUtils.bytesToIP(ipv4), NetUtils.bytesToIP(ipv6));
        }
        if ((encrypt = decoder.getLong(EX_E)) != null && encrypt.intValue() == 1) {
            this.peerSession.flags((byte)1);
        }
        if ((uploadOnly = decoder.getLong(EX_UPLOAD_ONLY)) != null && uploadOnly.intValue() == 1) {
            this.peerSession.flags((byte)2);
        }
        if ((metadataSize = decoder.getLong(EX_METADATA_SIZE)) != null && this.infoHash.getSize() <= 0) {
            this.infoHash.setSize(metadataSize.intValue());
        }
        if (this.peerSession.unknownClientName() && StringUtils.isNotEmpty(clientName = decoder.getString(EX_V))) {
            LOGGER.debug("\u8bbe\u7f6e\u5ba2\u6237\u7aef\u540d\u79f0\uff1a{}", clientName);
            this.peerSession.clientName(clientName);
        }
        if (MapUtils.isNotEmpty(supportTypes = decoder.getMap(EX_M))) {
            supportTypes.entrySet().forEach(entry -> {
                Long typeId = (Long)entry.getValue();
                String typeValue = (String)entry.getKey();
                PeerConfig.ExtensionType extensionType = PeerConfig.ExtensionType.of(typeValue);
                if (extensionType == PeerConfig.ExtensionType.UT_HOLEPUNCH) {
                    this.peerSession.flags((byte)8);
                }
                if (extensionType != null && extensionType.getSupport()) {
                    LOGGER.debug("\u5904\u7406\u6269\u5c55\u534f\u8bae-\u63e1\u624b\uff08\u6dfb\u52a0\uff09\uff1a{}-{}", new Object[]{extensionType, typeId});
                    this.peerSession.supportExtensionType(extensionType, typeId.byteValue());
                } else {
                    LOGGER.debug("\u5904\u7406\u6269\u5c55\u534f\u8bae-\u63e1\u624b\uff08\u672a\u77e5\u534f\u8bae\uff09\uff1a{}-{}", typeValue, typeId);
                }
            });
        }
        if (!this.handshakeSend) {
            this.handshake();
        }
        if (this.torrentSession.action() == PeerConfig.Action.MAGNET) {
            this.metadata();
        }
    }

    public void pex(byte[] bytes) {
        if (this.peerExchangeMessageHandler.supportExtensionType()) {
            this.peerExchangeMessageHandler.pex(bytes);
        }
    }

    private void pex(ByteBuffer buffer) throws NetException {
        this.peerExchangeMessageHandler.onMessage(buffer);
    }

    public void metadata() {
        if (this.metadataMessageHandler.supportExtensionType()) {
            this.metadataMessageHandler.request();
        }
    }

    private void metadata(ByteBuffer buffer) throws NetException {
        this.metadataMessageHandler.onMessage(buffer);
    }

    public void holepunchRendezvous(PeerSession peerSession) {
        if (this.holepunchMessageHnadler.supportExtensionType()) {
            this.holepunchMessageHnadler.rendezvous(peerSession);
        }
    }

    public void holepunchConnect(String host, Integer port) {
        if (this.holepunchMessageHnadler.supportExtensionType()) {
            this.holepunchMessageHnadler.connect(host, port);
        }
    }

    private void holepunch(ByteBuffer buffer) throws NetException {
        this.holepunchMessageHnadler.onMessage(buffer);
    }

    public void uploadOnly() {
        if (this.uploadOnlyExtensionMessageHandler.supportExtensionType()) {
            this.uploadOnlyExtensionMessageHandler.uploadOnly();
        }
    }

    private void uploadOnly(ByteBuffer buffer) throws NetException {
        this.uploadOnlyExtensionMessageHandler.onMessage(buffer);
    }

    public void dontHave(int index) {
        if (this.dontHaveExtensionMessageHandler.supportExtensionType()) {
            this.dontHaveExtensionMessageHandler.dontHave(index);
        }
    }

    private void dontHave(ByteBuffer buffer) throws NetException {
        this.dontHaveExtensionMessageHandler.onMessage(buffer);
    }

    public void pushMessage(byte type, byte[] bytes) {
        this.peerSubMessageHandler.pushMessage(PeerConfig.Type.EXTENSION, this.buildMessage(type, bytes));
    }

    private byte[] buildMessage(byte type, byte[] bytes) {
        byte[] message = new byte[bytes.length + 1];
        message[0] = type;
        System.arraycopy(bytes, 0, message, 1, bytes.length);
        return message;
    }
}

