/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.peer;

import com.acgist.snail.config.PeerConfig;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.NetException;
import com.acgist.snail.net.torrent.peer.ExtensionMessageHandler;
import com.acgist.snail.net.torrent.peer.IExtensionMessageHandler;
import com.acgist.snail.net.torrent.peer.PeerSession;
import java.nio.ByteBuffer;

public abstract class ExtensionTypeMessageHandler
implements IExtensionMessageHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtensionTypeMessageHandler.class);
    protected final PeerConfig.ExtensionType extensionType;
    protected final PeerSession peerSession;
    protected final ExtensionMessageHandler extensionMessageHandler;

    protected ExtensionTypeMessageHandler(PeerConfig.ExtensionType extensionType, PeerSession peerSession, ExtensionMessageHandler extensionMessageHandler) {
        this.extensionType = extensionType;
        this.peerSession = peerSession;
        this.extensionMessageHandler = extensionMessageHandler;
    }

    @Override
    public void onMessage(ByteBuffer buffer) throws NetException {
        if (!this.supportExtensionType()) {
            LOGGER.debug("\u5904\u7406\u6269\u5c55\u534f\u8bae\u6d88\u606f\u9519\u8bef\uff08\u6ca1\u6709\u652f\u6301\uff09\uff1a{}", new Object[]{this.extensionType});
            return;
        }
        this.doMessage(buffer);
    }

    protected abstract void doMessage(ByteBuffer var1) throws NetException;

    public boolean supportExtensionType() {
        return this.peerSession.supportExtensionType(this.extensionType);
    }

    protected Byte extensionTypeId() {
        return this.peerSession.extensionTypeId(this.extensionType);
    }

    protected void pushMessage(ByteBuffer buffer) {
        this.pushMessage(buffer.array());
    }

    protected void pushMessage(byte[] bytes) {
        this.extensionMessageHandler.pushMessage(this.extensionTypeId(), bytes);
    }
}

