/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.peer;

import com.acgist.snail.context.IStatisticsSession;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.torrent.IPeerConnect;
import com.acgist.snail.net.torrent.TorrentPiece;
import com.acgist.snail.net.torrent.TorrentSession;
import com.acgist.snail.net.torrent.peer.PeerConnectSession;
import com.acgist.snail.net.torrent.peer.PeerSession;
import com.acgist.snail.net.torrent.peer.PeerSubMessageHandler;
import com.acgist.snail.utils.BeanUtils;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class PeerConnect
implements IPeerConnect {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeerConnect.class);
    private static final int SLICE_REQUEST_SIZE = 2;
    private static final int SLICE_REQUEST_MAX_SIZE = 4;
    private static final long SLICE_TIMEOUT = 10000L;
    private static final long COMPLETED_TIMEOUT = 30000L;
    private static final long RELEASE_TIMEOUT = 4000L;
    protected volatile boolean available = false;
    private volatile boolean downloading = false;
    private TorrentPiece downloadPiece;
    private final AtomicInteger sliceLock = new AtomicInteger(0);
    private final AtomicBoolean completedLock = new AtomicBoolean(false);
    private final AtomicBoolean releaseLock = new AtomicBoolean(false);
    protected final PeerSession peerSession;
    protected final TorrentSession torrentSession;
    protected final IStatisticsSession statisticsSession;
    protected final PeerConnectSession peerConnectSession;
    protected final PeerSubMessageHandler peerSubMessageHandler;

    protected PeerConnect(PeerSession peerSession, TorrentSession torrentSession, PeerSubMessageHandler peerSubMessageHandler) {
        this.peerSession = peerSession;
        this.statisticsSession = peerSession.getStatistics();
        this.torrentSession = torrentSession;
        this.peerConnectSession = new PeerConnectSession();
        this.peerSubMessageHandler = peerSubMessageHandler;
    }

    public final PeerSession peerSession() {
        return this.peerSession;
    }

    public final TorrentSession torrentSession() {
        return this.torrentSession;
    }

    public final PeerConnectSession peerConnectSession() {
        return this.peerConnectSession;
    }

    @Override
    public final IPeerConnect.ConnectType connectType() {
        return this.peerSubMessageHandler.connectType();
    }

    public final void have(Integer ... indexArray) {
        this.peerSubMessageHandler.have(indexArray);
    }

    public final void pex(byte[] bytes) {
        this.peerSubMessageHandler.pex(bytes);
    }

    public final void holepunchRendezvous(PeerSession peerSession) {
        this.peerSubMessageHandler.holepunchRendezvous(peerSession);
    }

    public final void holepunchConnect(String host, int port) {
        this.peerSubMessageHandler.holepunchConnect(host, port);
    }

    public final void uploadOnly() {
        this.peerSubMessageHandler.uploadOnly();
    }

    public final boolean available() {
        return this.available && this.peerSubMessageHandler.available();
    }

    public final void uploadMark(int buffer) {
        this.peerConnectSession.upload(buffer);
        this.statisticsSession.upload(buffer);
        this.statisticsSession.uploadLimit(buffer);
    }

    public final long uploadMark() {
        return this.peerConnectSession.uploadMark();
    }

    public final void downloadMark(int buffer) {
        this.peerConnectSession.download(buffer);
        this.statisticsSession.downloadLimit(buffer);
    }

    public final long downloadMark() {
        return this.peerConnectSession.downloadMark();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download() {
        if (!this.downloading) {
            PeerConnect peerConnect = this;
            synchronized (peerConnect) {
                if (!this.downloading) {
                    this.downloading = true;
                    this.torrentSession.submit(this::requests);
                }
            }
        }
    }

    public final void piece(int index, int begin, byte[] bytes) {
        if (bytes == null || this.downloadPiece == null) {
            return;
        }
        int downloadIndex = this.downloadPiece.getIndex();
        if (index != downloadIndex) {
            LOGGER.debug("\u4e0b\u8f7dPiece\u7d22\u5f15\u548c\u5f53\u524dPiece\u7d22\u5f15\u4e0d\u7b26\uff1a{}-{}", index, downloadIndex);
            return;
        }
        this.unlockSlice();
        boolean completed = this.downloadPiece.write(begin, bytes);
        if (completed) {
            this.unlockCompleted();
        }
    }

    public void release() {
        this.available = false;
        this.releaseDownload();
        if (this.peerSubMessageHandler.available()) {
            this.peerSubMessageHandler.choke();
        }
        this.peerSubMessageHandler.close();
    }

    private void requests() {
        LOGGER.debug("\u5f00\u59cb\u8bf7\u6c42\u4e0b\u8f7d\uff1a{}", this.peerSession);
        boolean success = true;
        while (success) {
            try {
                success = this.request();
            }
            catch (Exception e) {
                LOGGER.error("Peer\u8bf7\u6c42\u5f02\u5e38", e);
            }
        }
        this.completedLock.set(true);
        this.releaseDownload();
        this.torrentSession.checkCompletedAndUnlock();
        if (this.downloadPiece != null && !this.downloadPiece.completedAndVerify()) {
            LOGGER.debug("Piece\u6700\u540e\u5931\u8d25\uff1a{}", this.downloadPiece);
            this.torrentSession.undone(this.downloadPiece);
            this.peerSubMessageHandler.cancel(this.downloadPiece.getIndex(), this.downloadPiece.getBegin(), this.downloadPiece.getLength());
        }
        LOGGER.debug("\u7ed3\u675f\u8bf7\u6c42\u4e0b\u8f7d\uff1a{}", this.peerSession);
    }

    private boolean request() {
        if (!this.available()) {
            return false;
        }
        if (!this.torrentSession.downloadable()) {
            LOGGER.debug("\u91ca\u653ePeer\uff1a\u4efb\u52a1\u4e0d\u53ef\u4e0b\u8f7d", new Object[0]);
            return false;
        }
        this.pick();
        if (this.downloadPiece == null) {
            LOGGER.debug("\u91ca\u653ePeer\uff1a\u6ca1\u6709\u5339\u914dPiece\u4e0b\u8f7d", new Object[0]);
            this.peerSubMessageHandler.notInterested();
            return false;
        }
        int index = this.downloadPiece.getIndex();
        while (this.available()) {
            if (this.sliceLock.get() >= 2) {
                this.lockSlice();
            }
            if (this.sliceLock.get() >= 4) {
                LOGGER.debug("\u8d85\u8fc7slice\u6700\u5927\u8bf7\u6c42\u6570\u91cf\u8df3\u51fa\u5faa\u73af", new Object[0]);
                break;
            }
            this.sliceLock.incrementAndGet();
            int begin = this.downloadPiece.position();
            int length = this.downloadPiece.length();
            this.peerSubMessageHandler.request(index, begin, length);
            if (this.downloadPiece.hasMoreSlice()) continue;
            break;
        }
        this.lockCompleted();
        this.unlockRelease();
        return true;
    }

    private void pick() {
        if (this.downloadPiece != null) {
            if (this.downloadPiece.completed()) {
                if (this.downloadPiece.verify()) {
                    boolean success = this.torrentSession.write(this.downloadPiece);
                    if (success) {
                        this.statisticsSession.download(this.downloadPiece.getLength());
                    } else {
                        LOGGER.debug("Piece\u4fdd\u5b58\u5931\u8d25\uff1a{}", this.downloadPiece);
                        this.torrentSession.undone(this.downloadPiece);
                    }
                } else {
                    this.peerSession.badPieces(this.downloadPiece.getIndex());
                    LOGGER.warn("Piece\u6821\u9a8c\u5931\u8d25\uff1a{}", this.downloadPiece);
                    this.torrentSession.undone(this.downloadPiece);
                }
            } else {
                LOGGER.debug("Piece\u4e0b\u8f7d\u5931\u8d25\uff1a{}", this.downloadPiece);
                this.torrentSession.undone(this.downloadPiece);
            }
        }
        if (this.peerConnectSession.isPeerUnchoked()) {
            LOGGER.debug("\u9009\u62e9\u4e0b\u8f7dPiece\uff1a\u89e3\u9664\u963b\u585e", new Object[0]);
            this.downloadPiece = this.torrentSession.pick(this.peerSession.availablePieces(), this.peerSession.suggestPieces());
        } else {
            LOGGER.debug("\u9009\u62e9\u4e0b\u8f7dPiece\uff1a\u5feb\u901f\u5141\u8bb8", new Object[0]);
            this.downloadPiece = this.torrentSession.pick(this.peerSession.allowedPieces(), this.peerSession.allowedPieces());
        }
        LOGGER.debug("\u9009\u62e9\u4e0b\u8f7dPiece\uff1a{}", this.downloadPiece);
        this.sliceLock.set(0);
        this.completedLock.set(false);
    }

    protected final void releaseDownload() {
        if (this.downloading) {
            LOGGER.debug("PeerConnect\u91ca\u653e\u4e0b\u8f7d\uff1a{}", this.peerSession);
            this.downloading = false;
            if (!this.completedLock.get()) {
                this.lockRelease();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockSlice() {
        AtomicInteger atomicInteger = this.sliceLock;
        synchronized (atomicInteger) {
            try {
                this.sliceLock.wait(10000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.debug("\u7ebf\u7a0b\u7b49\u5f85\u5f02\u5e38", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockSlice() {
        if (this.sliceLock.decrementAndGet() <= 0) {
            AtomicInteger atomicInteger = this.sliceLock;
            synchronized (atomicInteger) {
                this.sliceLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockCompleted() {
        if (!this.completedLock.get()) {
            AtomicBoolean atomicBoolean = this.completedLock;
            synchronized (atomicBoolean) {
                if (!this.completedLock.get()) {
                    try {
                        this.completedLock.wait(30000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        LOGGER.debug("\u7ebf\u7a0b\u7b49\u5f85\u5f02\u5e38", e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockCompleted() {
        AtomicBoolean atomicBoolean = this.completedLock;
        synchronized (atomicBoolean) {
            this.completedLock.set(true);
            this.completedLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockRelease() {
        if (!this.releaseLock.get()) {
            AtomicBoolean atomicBoolean = this.releaseLock;
            synchronized (atomicBoolean) {
                if (!this.releaseLock.get()) {
                    this.releaseLock.set(true);
                    try {
                        this.releaseLock.wait(4000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        LOGGER.debug("\u7ebf\u7a0b\u7b49\u5f85\u5f02\u5e38", e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockRelease() {
        if (this.releaseLock.get()) {
            AtomicBoolean atomicBoolean = this.releaseLock;
            synchronized (atomicBoolean) {
                if (this.releaseLock.get()) {
                    this.releaseLock.notifyAll();
                }
            }
        }
    }

    public String toString() {
        return BeanUtils.toString(this, this.peerSession);
    }
}

