/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.peer;

import com.acgist.snail.config.DownloadConfig;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import java.util.concurrent.atomic.AtomicLong;

public final class PeerConnectSession {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeerConnectSession.class);
    private static final long MIN_MARK_INTERVAL = 60000L;
    private volatile boolean amChoked = true;
    private volatile boolean amInterested = false;
    private volatile boolean peerChoked = true;
    private volatile boolean peerInterested = false;
    private volatile long uploadMark;
    private volatile long downloadMark;
    private final AtomicLong uploadSize = new AtomicLong(0L);
    private final AtomicLong downloadSize = new AtomicLong(0L);
    private volatile long lastRefreshMarkTime = System.currentTimeMillis();

    public PeerConnectSession() {
        this.uploadMark = DownloadConfig.getUploadBufferByte();
        this.downloadMark = DownloadConfig.getDownloadBufferByte();
    }

    public void amChoked() {
        this.amChoked = true;
    }

    public void amUnchoked() {
        this.amChoked = false;
    }

    public boolean isAmChoked() {
        return this.amChoked;
    }

    public boolean isAmUnchoked() {
        return !this.amChoked;
    }

    public void amInterested() {
        this.amInterested = true;
    }

    public void amNotInterested() {
        this.amInterested = false;
    }

    public boolean isAmInterested() {
        return this.amInterested;
    }

    public boolean isAmNotInterested() {
        return !this.amInterested;
    }

    public void peerChoked() {
        this.peerChoked = true;
    }

    public void peerUnchoked() {
        this.peerChoked = false;
    }

    public boolean isPeerChoked() {
        return this.peerChoked;
    }

    public boolean isPeerUnchoked() {
        return !this.peerChoked;
    }

    public void peerInterested() {
        this.peerInterested = true;
    }

    public void peerNotInterested() {
        this.peerInterested = false;
    }

    public boolean isPeerInterested() {
        return this.peerInterested;
    }

    public boolean isPeerNotInterested() {
        return !this.peerInterested;
    }

    public boolean uploadable() {
        return this.peerInterested && !this.amChoked;
    }

    public boolean downloadable() {
        return this.amInterested && !this.peerChoked;
    }

    public final void upload(int buffer) {
        this.uploadSize.addAndGet(buffer);
    }

    public final long uploadMark() {
        this.refreshMark();
        return this.uploadMark;
    }

    public final void download(int buffer) {
        this.downloadSize.addAndGet(buffer);
    }

    public final long downloadMark() {
        this.refreshMark();
        return this.downloadMark;
    }

    private final void refreshMark() {
        long nowTime = System.currentTimeMillis();
        long interval = nowTime - this.lastRefreshMarkTime;
        if (interval > 60000L) {
            this.lastRefreshMarkTime = nowTime;
            this.uploadMark = this.uploadSize.getAndSet(0L);
            this.downloadMark = this.downloadSize.getAndSet(0L);
            LOGGER.debug("\u5237\u65b0\u8bc4\u5206\uff1a{} - {}", this.uploadMark, this.downloadMark);
        }
    }
}

