/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.peer;

import com.acgist.snail.config.PeerConfig;
import com.acgist.snail.context.IContext;
import com.acgist.snail.context.IStatisticsSession;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.torrent.peer.PeerConnect;
import com.acgist.snail.net.torrent.peer.PeerSession;
import com.acgist.snail.net.torrent.peer.extension.PeerExchangeMessageHandler;
import com.acgist.snail.utils.ArrayUtils;
import com.acgist.snail.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.stream.Collectors;

public final class PeerContext
implements IContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeerContext.class);
    private static final PeerContext INSTANCE = new PeerContext();
    private final Map<String, List<Integer>> haves = new ConcurrentHashMap<String, List<Integer>>();
    private final Map<String, Deque<PeerSession>> activePeers = new ConcurrentHashMap<String, Deque<PeerSession>>();
    private final Map<String, List<PeerSession>> archivePeers = new ConcurrentHashMap<String, List<PeerSession>>();

    public static final PeerContext getInstance() {
        return INSTANCE;
    }

    private PeerContext() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerSession findPeerSession(String infoHashHex, String host, Integer port) {
        List<PeerSession> list;
        List<PeerSession> list2 = list = this.list(infoHashHex);
        synchronized (list2) {
            return this.findPeerSession(list, host, port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PeerSession> listPeerSession(String infoHashHex) {
        List<PeerSession> list;
        List<PeerSession> list2 = list = this.list(infoHashHex);
        synchronized (list2) {
            return new ArrayList<PeerSession>(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNotEmpty(String infoHashHex) {
        List<PeerSession> list;
        List<PeerSession> list2 = list = this.list(infoHashHex);
        synchronized (list2) {
            return !list.isEmpty();
        }
    }

    public void remove(String infoHashHex) {
        LOGGER.debug("\u5220\u9664Peer\u961f\u5217\uff1a{}", infoHashHex);
        this.haves.remove(infoHashHex);
        this.activePeers.remove(infoHashHex);
        this.archivePeers.remove(infoHashHex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerSession newPeerSession(String infoHashHex, IStatisticsSession parent, String host, Integer port, PeerConfig.Source source) {
        PeerContext peerContext = this;
        synchronized (peerContext) {
            List<PeerSession> list;
            List<PeerSession> list2 = list = this.list(infoHashHex);
            synchronized (list2) {
                PeerSession peerSession = this.findPeerSession(list, host, port);
                if (peerSession == null) {
                    Deque<PeerSession> deque;
                    LOGGER.debug("\u6dfb\u52a0PeerSession\uff1a{}-{}-{}", new Object[]{host, port, source});
                    peerSession = PeerSession.newInstance(parent, host, port);
                    Deque<PeerSession> deque2 = deque = this.deque(infoHashHex);
                    synchronized (deque2) {
                        if (source.preference()) {
                            deque.offerLast(peerSession);
                        } else {
                            deque.offerFirst(peerSession);
                        }
                    }
                    list.add(peerSession);
                }
                peerSession.source(source);
                return peerSession;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inferior(String infoHashHex, PeerSession peerSession) {
        Deque<PeerSession> deque;
        Deque<PeerSession> deque2 = deque = this.deque(infoHashHex);
        synchronized (deque2) {
            deque.offerFirst(peerSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preference(String infoHashHex, PeerSession peerSession) {
        Deque<PeerSession> deque;
        Deque<PeerSession> deque2 = deque = this.deque(infoHashHex);
        synchronized (deque2) {
            deque.offerLast(peerSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerSession pick(String infoHashHex) {
        Deque<PeerSession> deque;
        Deque<PeerSession> deque2 = deque = this.deque(infoHashHex);
        synchronized (deque2) {
            int index = 0;
            int size = deque.size();
            PeerSession peerSession = null;
            while (++index <= size) {
                peerSession = deque.pollLast();
                if (peerSession.available()) {
                    return peerSession;
                }
                deque.offerFirst(peerSession);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void have(String infoHashHex, int index) {
        List<Integer> list;
        List<Integer> list2 = list = this.haves(infoHashHex);
        synchronized (list2) {
            list.add(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void have(String infoHashHex) {
        Object[] indexArray;
        List<Integer> list;
        List<Integer> list2 = list = this.haves(infoHashHex);
        synchronized (list2) {
            indexArray = (Integer[])list.toArray(Integer[]::new);
            list.clear();
        }
        if (ArrayUtils.isEmpty(indexArray)) {
            LOGGER.debug("\u53d1\u9001have\u6d88\u606f\uff1a\u6ca1\u6709\u6570\u636e", new Object[0]);
            return;
        }
        List<PeerSession> sessions = this.listConnectPeerSession(infoHashHex);
        sessions.forEach(arg_0 -> PeerContext.lambda$have$1((Integer[])indexArray, arg_0));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u53d1\u9001have\u6d88\u606f\uff1a{}-{}-{}", infoHashHex, sessions.size(), indexArray.length);
        }
    }

    public void pex(String infoHashHex) {
        List<PeerSession> sessions = this.listConnectPeerSession(infoHashHex);
        List<PeerSession> optimize = sessions.stream().filter(session -> session.getStatistics().getDownloadSize() > 0L).collect(Collectors.toList());
        byte[] message = PeerExchangeMessageHandler.buildMessage(optimize);
        if (ArrayUtils.isEmpty(message)) {
            LOGGER.debug("\u53d1\u9001PEX\u6d88\u606f\u5931\u8d25\uff1a\u6ca1\u6709\u6570\u636e", new Object[0]);
            return;
        }
        sessions.forEach(session -> {
            PeerConnect peerConnect = session.peerConnect();
            if (peerConnect != null && peerConnect.available()) {
                peerConnect.pex(message);
            }
        });
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u53d1\u9001PEX\u6d88\u606f\uff1a{}-{}-{}", infoHashHex, sessions.size(), optimize.size());
        }
    }

    public void uploadOnly(String infoHashHex) {
        List<PeerSession> sessions = this.listConnectPeerSession(infoHashHex);
        sessions.forEach(session -> {
            PeerConnect peerConnect = session.peerConnect();
            if (peerConnect != null && peerConnect.available()) {
                peerConnect.uploadOnly();
            }
        });
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u53d1\u9001uploadOnly\u6d88\u606f\uff1a{}-{}", infoHashHex, sessions.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Integer> haves(String infoHashHex) {
        Map<String, List<Integer>> map = this.haves;
        synchronized (map) {
            return this.haves.computeIfAbsent(infoHashHex, key -> new ArrayList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Deque<PeerSession> deque(String infoHashHex) {
        Map<String, Deque<PeerSession>> map = this.activePeers;
        synchronized (map) {
            return this.activePeers.computeIfAbsent(infoHashHex, key -> new LinkedBlockingDeque());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PeerSession> list(String infoHashHex) {
        Map<String, List<PeerSession>> map = this.archivePeers;
        synchronized (map) {
            return this.archivePeers.computeIfAbsent(infoHashHex, key -> new ArrayList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PeerSession> listConnectPeerSession(String infoHashHex) {
        List<PeerSession> list = this.list(infoHashHex);
        if (CollectionUtils.isEmpty(list)) {
            return List.of();
        }
        List<PeerSession> list2 = list;
        synchronized (list2) {
            return list.stream().filter(PeerSession::available).filter(PeerSession::connected).collect(Collectors.toList());
        }
    }

    private PeerSession findPeerSession(List<PeerSession> list, String host, Integer port) {
        return list.stream().filter(peer -> peer.equals(host, port)).findFirst().orElse(null);
    }

    private static /* synthetic */ void lambda$have$1(Integer[] indexArray, PeerSession session) {
        PeerConnect peerConnect = session.peerConnect();
        if (peerConnect != null && peerConnect.available()) {
            peerConnect.have(indexArray);
        }
    }
}

