/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.peer;

import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.torrent.TorrentSession;
import com.acgist.snail.net.torrent.peer.PeerClient;
import com.acgist.snail.net.torrent.peer.PeerConnect;
import com.acgist.snail.net.torrent.peer.PeerSession;
import com.acgist.snail.net.torrent.peer.PeerSubMessageHandler;
import com.acgist.snail.net.torrent.utp.UtpClient;

public final class PeerDownloader
extends PeerConnect {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeerDownloader.class);

    private PeerDownloader(PeerSession peerSession, TorrentSession torrentSession) {
        super(peerSession, torrentSession, PeerSubMessageHandler.newInstance(peerSession, torrentSession));
    }

    public static final PeerDownloader newInstance(PeerSession peerSession, TorrentSession torrentSession) {
        return new PeerDownloader(peerSession, torrentSession);
    }

    public boolean handshake() {
        boolean success = this.connect();
        if (success) {
            this.peerSubMessageHandler.initClient(this).handshake();
        } else {
            this.peerSession.incrementFailTimes();
        }
        this.available = success;
        return success;
    }

    private boolean connect() {
        if (this.peerSession.utp()) {
            LOGGER.debug("Peer\u8fde\u63a5\uff08UTP\uff09\uff1a{}", this.peerSession);
            UtpClient utpClient = UtpClient.newInstance(this.peerSession, this.peerSubMessageHandler);
            boolean utpOk = utpClient.connect();
            if (utpOk) {
                return utpOk;
            }
            return this.holepunchConnect(false);
        }
        LOGGER.debug("Peer\u8fde\u63a5\uff08TCP\uff09\uff1a{}", this.peerSession);
        PeerClient peerClient = PeerClient.newInstance(this.peerSession, this.peerSubMessageHandler);
        boolean tcpOk = peerClient.connect();
        if (tcpOk) {
            return tcpOk;
        }
        return this.holepunchConnect(true);
    }

    private boolean holepunchConnect(boolean utpRetry) {
        PeerConnect peerConnect;
        PeerSession pexSource;
        if (!this.peerSession.outgo() && (pexSource = this.peerSession.pexSource()) != null && pexSource.connected() && pexSource.holepunch() && this.peerSession.holepunch() && (peerConnect = pexSource.peerConnect()) != null) {
            if (!this.peerSession.holeunchConnect()) {
                peerConnect.holepunchRendezvous(this.peerSession);
            }
            if (this.peerSession.holeunchConnect()) {
                LOGGER.debug("Peer\u8fde\u63a5\uff08holepunch\uff09\uff1a{}", this.peerSession);
                UtpClient utpClient = UtpClient.newInstance(this.peerSession, this.peerSubMessageHandler);
                return utpClient.connect();
            }
            LOGGER.debug("Peer\u8fde\u63a5\u5931\u8d25\uff08holepunch\uff09\uff1a{}", this.peerSession);
        }
        if (utpRetry) {
            LOGGER.debug("Peer\u8fde\u63a5\u91cd\u8bd5\uff08UTP\uff09\uff1a{}", this.peerSession);
            UtpClient utpClient = UtpClient.newInstance(this.peerSession, this.peerSubMessageHandler);
            boolean utpOk = utpClient.connect();
            if (utpOk) {
                this.peerSession.flags((byte)4);
                this.peerSession.flags((byte)16);
                return utpOk;
            }
        }
        return false;
    }

    @Override
    public void release() {
        try {
            if (this.available) {
                LOGGER.debug("\u5173\u95edPeerDownloader\uff1a{}", this.peerSession);
                super.release();
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5173\u95edPeerDownloader\u5f02\u5e38", e);
        }
        finally {
            this.peerSession.statusOff((byte)1);
            this.peerSession.peerDownloader(null);
        }
    }
}

