/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.peer;

import com.acgist.snail.config.SystemConfig;
import com.acgist.snail.context.ITaskSession;
import com.acgist.snail.context.SystemThreadContext;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.torrent.TorrentSession;
import com.acgist.snail.net.torrent.peer.PeerContext;
import com.acgist.snail.net.torrent.peer.PeerDownloader;
import com.acgist.snail.net.torrent.peer.PeerSession;
import com.acgist.snail.utils.ThreadUtils;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;

public final class PeerDownloaderGroup {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeerDownloaderGroup.class);
    private static final int BUILD_SIZE = 3;
    private static final int MAX_BUILD_SIZE = 64;
    private final AtomicBoolean build = new AtomicBoolean(false);
    private final Semaphore buildSemaphore = new Semaphore(3);
    private final ITaskSession taskSession;
    private final TorrentSession torrentSession;
    private final BlockingQueue<PeerDownloader> peerDownloaders;

    private PeerDownloaderGroup(TorrentSession torrentSession) {
        this.taskSession = torrentSession.taskSession();
        this.torrentSession = torrentSession;
        this.peerDownloaders = new LinkedBlockingQueue<PeerDownloader>();
    }

    public static final PeerDownloaderGroup newInstance(TorrentSession torrentSession) {
        return new PeerDownloaderGroup(torrentSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optimize() {
        LOGGER.debug("\u4f18\u5316PeerDownloader\uff1a{}", this.torrentSession);
        this.spinLock();
        BlockingQueue<PeerDownloader> blockingQueue = this.peerDownloaders;
        synchronized (blockingQueue) {
            try {
                this.inferiorPeerDownloaders();
                this.buildPeerDownloaders();
            }
            catch (Exception e) {
                LOGGER.error("\u4f18\u5316PeerDownloader\u5f02\u5e38", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        LOGGER.debug("\u91ca\u653ePeerDownloaderGroup\uff1a{}", this.torrentSession);
        this.release(false);
        BlockingQueue<PeerDownloader> blockingQueue = this.peerDownloaders;
        synchronized (blockingQueue) {
            this.peerDownloaders.forEach(downloader -> {
                SystemThreadContext.submit(downloader::release);
                PeerContext.getInstance().preference(this.torrentSession.infoHashHex(), downloader.peerSession());
            });
            this.peerDownloaders.clear();
        }
    }

    private void spinLock() {
        PeerContext peerContext = PeerContext.getInstance();
        String infoHashHex = this.torrentSession.infoHashHex();
        while (this.taskSession.statusDownload() && !peerContext.isNotEmpty(infoHashHex)) {
            ThreadUtils.sleep(1000L);
        }
    }

    private void buildPeerDownloaders() {
        LOGGER.debug("\u65b0\u5efaPeerDownloader\uff1a{}", this.torrentSession);
        int size = 0;
        this.build.set(true);
        this.buildSemaphore.drainPermits();
        this.buildSemaphore.release(3);
        while (this.build.get()) {
            this.acquire();
            if (!this.build.get()) {
                LOGGER.debug("\u4e0d\u80fd\u7ee7\u7eed\u65b0\u5efaPeerDownloader\uff1a\u9000\u51fa\u5faa\u73af", new Object[0]);
                break;
            }
            this.torrentSession.submit(() -> {
                boolean success = true;
                try {
                    success = this.buildPeerDownloader();
                }
                catch (Exception e) {
                    LOGGER.error("\u65b0\u5efaPeerDownloader\u5f02\u5e38", e);
                }
                finally {
                    this.release(success);
                }
            });
            if (++size < 64) continue;
            LOGGER.debug("\u4e0d\u80fd\u7ee7\u7eed\u65b0\u5efaPeerDownloader\uff1a\u8d85\u8fc7\u5355\u6b21\u65b0\u5efa\u6700\u5927\u6570\u91cf", new Object[0]);
            break;
        }
    }

    private boolean buildPeerDownloader() {
        if (!this.taskSession.statusDownload()) {
            return false;
        }
        if (this.peerDownloaders.size() >= SystemConfig.getPeerSize()) {
            return false;
        }
        PeerSession peerSession = PeerContext.getInstance().pick(this.torrentSession.infoHashHex());
        if (peerSession != null) {
            PeerDownloader peerDownloader = PeerDownloader.newInstance(peerSession, this.torrentSession);
            boolean success = peerDownloader.handshake();
            if (success) {
                peerSession.status((byte)1);
                this.offer(peerDownloader);
            } else {
                PeerContext.getInstance().inferior(this.torrentSession.infoHashHex(), peerSession);
            }
            return true;
        }
        return false;
    }

    private void inferiorPeerDownloaders() {
        LOGGER.debug("\u5254\u9664\u52a3\u8d28PeerDownloader\uff1a{}", this.torrentSession);
        int index = 0;
        long downloadMark = 0L;
        long minDownloadMark = 0L;
        PeerDownloader downloader = null;
        PeerDownloader minDownloader = null;
        int size = this.peerDownloaders.size();
        while (index++ < size && (downloader = (PeerDownloader)this.peerDownloaders.poll()) != null) {
            if (!downloader.available()) {
                LOGGER.debug("\u5254\u9664\u52a3\u8d28PeerDownloader\uff08\u72b6\u6001\u65e0\u6548\uff09", new Object[0]);
                this.inferior(downloader);
                continue;
            }
            downloadMark = downloader.downloadMark();
            if (downloadMark <= 0L) {
                LOGGER.debug("\u5254\u9664\u52a3\u8d28PeerDownloader\uff08\u6ca1\u6709\u8bc4\u5206\uff09", new Object[0]);
                this.inferior(downloader);
                continue;
            }
            if (minDownloader == null) {
                minDownloader = downloader;
                minDownloadMark = downloadMark;
                continue;
            }
            if (downloadMark < minDownloadMark) {
                this.offer(minDownloader);
                minDownloader = downloader;
                minDownloadMark = downloadMark;
                continue;
            }
            this.offer(downloader);
        }
        if (minDownloader != null) {
            if (this.peerDownloaders.size() < SystemConfig.getPeerSize()) {
                this.offer(minDownloader);
            } else {
                LOGGER.debug("\u5254\u9664\u52a3\u8d28PeerDownloader\uff08\u6700\u4f4e\u8bc4\u5206\uff09", new Object[0]);
                this.inferior(minDownloader);
            }
        }
    }

    private void offer(PeerDownloader peerDownloader) {
        if (!this.peerDownloaders.offer(peerDownloader)) {
            LOGGER.warn("PeerDownloader\u4e22\u5931\uff1a{}", peerDownloader);
        }
    }

    private void inferior(PeerDownloader peerDownloader) {
        if (peerDownloader != null) {
            LOGGER.debug("\u5254\u9664\u52a3\u8d28PeerDownloader\uff1a{}", peerDownloader);
            SystemThreadContext.submit(peerDownloader::release);
            PeerContext.getInstance().inferior(this.torrentSession.infoHashHex(), peerDownloader.peerSession());
        }
    }

    private void acquire() {
        try {
            this.buildSemaphore.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.debug("\u4fe1\u53f7\u91cf\u83b7\u53d6\u5f02\u5e38", e);
        }
    }

    private void release(boolean build) {
        this.build.set(build);
        this.buildSemaphore.release();
    }
}

