/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.peer;

import com.acgist.snail.net.NetException;
import com.acgist.snail.net.TcpMessageHandler;
import com.acgist.snail.net.codec.IMessageEncoder;
import com.acgist.snail.net.torrent.IEncryptMessageSender;
import com.acgist.snail.net.torrent.IPeerConnect;
import com.acgist.snail.net.torrent.codec.PeerCryptMessageCodec;
import com.acgist.snail.net.torrent.codec.PeerUnpackMessageCodec;
import com.acgist.snail.net.torrent.peer.PeerSubMessageHandler;
import java.nio.ByteBuffer;

public final class PeerMessageHandler
extends TcpMessageHandler
implements IEncryptMessageSender {
    private final IMessageEncoder<ByteBuffer> messageEncoder;
    private final PeerSubMessageHandler peerSubMessageHandler;

    public PeerMessageHandler() {
        this(PeerSubMessageHandler.newInstance());
    }

    public PeerMessageHandler(PeerSubMessageHandler peerSubMessageHandler) {
        peerSubMessageHandler.messageEncryptSender(this);
        PeerUnpackMessageCodec peerUnpackMessageCodec = new PeerUnpackMessageCodec(peerSubMessageHandler);
        PeerCryptMessageCodec peerCryptMessageCodec = new PeerCryptMessageCodec(peerUnpackMessageCodec, peerSubMessageHandler);
        this.messageDecoder = peerCryptMessageCodec;
        this.messageEncoder = peerCryptMessageCodec;
        this.peerSubMessageHandler = peerSubMessageHandler;
    }

    @Override
    public boolean useless() {
        return this.peerSubMessageHandler.useless();
    }

    @Override
    public void sendEncrypt(ByteBuffer buffer, int timeout) throws NetException {
        this.messageEncoder.encode(buffer);
        this.send(buffer, timeout);
    }

    @Override
    public IPeerConnect.ConnectType connectType() {
        return IPeerConnect.ConnectType.TCP;
    }
}

