/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.peer;

import com.acgist.snail.config.PeerConfig;
import com.acgist.snail.context.IStatisticsSession;
import com.acgist.snail.context.StatisticsGetter;
import com.acgist.snail.context.session.StatisticsSession;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.torrent.IPeerConnect;
import com.acgist.snail.net.torrent.peer.PeerConnect;
import com.acgist.snail.net.torrent.peer.PeerDownloader;
import com.acgist.snail.net.torrent.peer.PeerUploader;
import com.acgist.snail.utils.BeanUtils;
import com.acgist.snail.utils.NetUtils;
import com.acgist.snail.utils.NumberUtils;
import com.acgist.snail.utils.StringUtils;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public final class PeerSession
extends StatisticsGetter
implements IPeerConnect {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeerSession.class);
    private byte[] id;
    private String clientName;
    private volatile byte flags = 0;
    private volatile byte status = 0;
    private volatile byte source = 0;
    private volatile byte failTimes = 0;
    private String host;
    private Integer port;
    private Integer dhtPort;
    private byte[] reserved;
    private final BitSet pieces;
    private final BitSet badPieces;
    private final BitSet suggestPieces;
    private final BitSet allowedPieces;
    private volatile boolean holepunchWait = false;
    private AtomicBoolean holepunchConnect = new AtomicBoolean(false);
    private PeerSession pexSource;
    private PeerUploader peerUploader;
    private PeerDownloader peerDownloader;
    private final Map<PeerConfig.ExtensionType, Byte> extension;

    private PeerSession(IStatisticsSession parent, String host, Integer port) {
        super(new StatisticsSession(false, false, parent));
        this.host = host;
        this.port = port;
        this.pieces = new BitSet();
        this.badPieces = new BitSet();
        this.suggestPieces = new BitSet();
        this.allowedPieces = new BitSet();
        this.extension = new EnumMap<PeerConfig.ExtensionType, Byte>(PeerConfig.ExtensionType.class);
    }

    public static final PeerSession newInstance(IStatisticsSession parent, String host, Integer port) {
        return new PeerSession(parent, host, port);
    }

    @Override
    public IPeerConnect.ConnectType connectType() {
        PeerConnect connect = this.peerConnect();
        if (connect == null) {
            return null;
        }
        return connect.connectType();
    }

    public void id(byte[] id) {
        this.id = id;
        this.clientName = PeerConfig.clientName(this.id);
    }

    public byte[] id() {
        return this.id;
    }

    public String clientName() {
        if (this.clientName == null) {
            return "unknown";
        }
        return this.clientName;
    }

    public void clientName(String clientName) {
        this.clientName = clientName;
    }

    public boolean unknownClientName() {
        return this.clientName == null || "unknown".equals(this.clientName);
    }

    public String host() {
        return this.host;
    }

    public Integer port() {
        return this.port;
    }

    public void port(Integer port) {
        this.port = port;
    }

    public Integer dhtPort() {
        return this.dhtPort;
    }

    public void dhtPort(Integer dhtPort) {
        this.dhtPort = dhtPort;
    }

    public void cleanPieces() {
        this.pieces.clear();
        this.badPieces.clear();
        this.suggestPieces.clear();
        this.allowedPieces.clear();
    }

    public void pieces(BitSet pieces) {
        this.pieces.or(pieces);
    }

    public void piece(int index) {
        if (PeerConfig.checkPiece(index)) {
            this.pieces.set(index);
        }
    }

    public void pieceOff(int index) {
        this.pieces.clear(index);
    }

    public boolean hasPiece(int index) {
        if (PeerConfig.checkPiece(index)) {
            return this.pieces.get(index);
        }
        return false;
    }

    public void badPieces(int index) {
        if (PeerConfig.checkPiece(index)) {
            this.badPieces.set(index);
        }
    }

    public BitSet availablePieces() {
        BitSet bitSet = new BitSet();
        bitSet.or(this.pieces);
        bitSet.andNot(this.badPieces);
        return bitSet;
    }

    public void suggestPieces(int index) {
        if (PeerConfig.checkPiece(index)) {
            this.pieces.set(index);
            this.suggestPieces.set(index);
        }
    }

    public BitSet suggestPieces() {
        return this.suggestPieces;
    }

    public void allowedPieces(int index) {
        if (PeerConfig.checkPiece(index)) {
            this.pieces.set(index);
            this.allowedPieces.set(index);
        }
    }

    public BitSet allowedPieces() {
        return this.allowedPieces;
    }

    public boolean supportAllowedFast() {
        return !this.allowedPieces.isEmpty();
    }

    public void incrementFailTimes() {
        this.failTimes = (byte)(this.failTimes + 1);
    }

    public boolean available() {
        return this.port != null && this.failTimes < 3;
    }

    public void reserved(byte[] reserved) {
        this.reserved = reserved;
    }

    private boolean supportExtension(int index, byte location) {
        return this.reserved != null && (this.reserved[index] & location) == location;
    }

    public boolean supportDhtProtocol() {
        return this.supportExtension(7, (byte)1);
    }

    public boolean supportExtensionProtocol() {
        return this.supportExtension(5, (byte)16);
    }

    public boolean supportFastExtensionProtocol() {
        return this.supportExtension(7, (byte)4);
    }

    public void supportExtensionType(PeerConfig.ExtensionType type, byte typeId) {
        this.extension.put(type, typeId);
    }

    public boolean supportExtensionType(PeerConfig.ExtensionType type) {
        return this.extension.containsKey((Object)type);
    }

    public Byte extensionTypeId(PeerConfig.ExtensionType type) {
        return this.extension.get((Object)type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void source(PeerConfig.Source source) {
        PeerSession peerSession = this;
        synchronized (peerSession) {
            this.source = (byte)(this.source | source.getValue());
        }
    }

    public List<PeerConfig.Source> sources() {
        PeerConfig.Source[] sources = PeerConfig.Source.values();
        ArrayList<PeerConfig.Source> list = new ArrayList<PeerConfig.Source>();
        for (PeerConfig.Source value : sources) {
            if ((this.source & value.getValue()) != value.getValue()) continue;
            list.add(value);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void status(byte status) {
        PeerSession peerSession = this;
        synchronized (peerSession) {
            this.status = (byte)(this.status | status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void statusOff(byte status) {
        PeerSession peerSession = this;
        synchronized (peerSession) {
            this.status = (byte)(this.status & ~status);
        }
    }

    private boolean verifyStatus(byte status) {
        return (this.status & status) == status;
    }

    public boolean uploading() {
        return this.verifyStatus((byte)2);
    }

    public boolean downloading() {
        return this.verifyStatus((byte)1);
    }

    public boolean connected() {
        return this.uploading() || this.downloading();
    }

    public byte flags() {
        return this.flags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flags(byte flags) {
        PeerSession peerSession = this;
        synchronized (peerSession) {
            this.flags = (byte)(this.flags | flags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flagsOff(byte flags) {
        PeerSession peerSession = this;
        synchronized (peerSession) {
            this.flags = (byte)(this.flags & ~flags);
        }
    }

    private boolean verifyFlags(byte flags) {
        return (this.flags & flags) == flags;
    }

    public boolean utp() {
        return this.verifyFlags((byte)4);
    }

    public boolean outgo() {
        return this.verifyFlags((byte)16);
    }

    public boolean encrypt() {
        return this.verifyFlags((byte)1);
    }

    public boolean uploadOnly() {
        return this.verifyFlags((byte)2);
    }

    public boolean holepunch() {
        return this.verifyFlags((byte)8);
    }

    public PeerSession pexSource() {
        return this.pexSource;
    }

    public void pexSource(PeerSession pexSource) {
        this.pexSource = pexSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockHolepunch() {
        if (!this.holepunchConnect.get()) {
            AtomicBoolean atomicBoolean = this.holepunchConnect;
            synchronized (atomicBoolean) {
                if (!this.holepunchConnect.get()) {
                    this.holepunchWait = true;
                    try {
                        this.holepunchConnect.wait(2000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        LOGGER.debug("\u7ebf\u7a0b\u7b49\u5f85\u5f02\u5e38", e);
                    }
                    this.holepunchWait = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockHolepunch() {
        AtomicBoolean atomicBoolean = this.holepunchConnect;
        synchronized (atomicBoolean) {
            this.holepunchConnect.set(true);
            this.holepunchConnect.notifyAll();
        }
    }

    public boolean holepunchWait() {
        return this.holepunchWait;
    }

    public boolean holeunchConnect() {
        return this.holepunchConnect.get();
    }

    public PeerConnect peerConnect() {
        return this.peerDownloader != null ? this.peerDownloader : this.peerUploader;
    }

    public PeerUploader peerUploader() {
        return this.peerUploader;
    }

    public void peerUploader(PeerUploader peerUploader) {
        this.peerUploader = peerUploader;
    }

    public PeerDownloader peerDownloader() {
        return this.peerDownloader;
    }

    public void peerDownloader(PeerDownloader peerDownloader) {
        this.peerDownloader = peerDownloader;
    }

    public InetSocketAddress peerSocketAddress() {
        return NetUtils.buildSocketAddress(this.host, this.port);
    }

    public InetSocketAddress dhtSocketAddress() {
        return NetUtils.buildSocketAddress(this.host, this.dhtPort);
    }

    public boolean equals(String host, Integer port) {
        return StringUtils.equals(this.host, host) && NumberUtils.equals(this.port, port);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof PeerSession) {
            PeerSession session = (PeerSession)object;
            return this.equals(session.host, session.port);
        }
        return false;
    }

    public String toString() {
        return BeanUtils.toString(this, this.host, this.port, this.dhtPort);
    }
}

