/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.peer;

import com.acgist.snail.config.PeerConfig;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.NetException;
import com.acgist.snail.net.codec.IMessageDecoder;
import com.acgist.snail.net.torrent.IEncryptMessageSender;
import com.acgist.snail.net.torrent.IPeerConnect;
import com.acgist.snail.net.torrent.TorrentContext;
import com.acgist.snail.net.torrent.TorrentSession;
import com.acgist.snail.net.torrent.peer.DhtExtensionMessageHandler;
import com.acgist.snail.net.torrent.peer.ExtensionMessageHandler;
import com.acgist.snail.net.torrent.peer.PeerConnect;
import com.acgist.snail.net.torrent.peer.PeerConnectSession;
import com.acgist.snail.net.torrent.peer.PeerContext;
import com.acgist.snail.net.torrent.peer.PeerDownloader;
import com.acgist.snail.net.torrent.peer.PeerSession;
import com.acgist.snail.net.torrent.peer.PeerUploader;
import com.acgist.snail.utils.ArrayUtils;
import com.acgist.snail.utils.BitfieldUtils;
import com.acgist.snail.utils.ByteUtils;
import com.acgist.snail.utils.NumberUtils;
import com.acgist.snail.utils.StringUtils;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.BitSet;

public final class PeerSubMessageHandler
implements IMessageDecoder<ByteBuffer>,
IPeerConnect {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeerSubMessageHandler.class);
    private static final int MAX_USELESS_CHECK = 3;
    private int uselessCheck = 0;
    private volatile boolean available = false;
    private volatile boolean handshakeSend = false;
    private volatile boolean handshakeRecv = false;
    private final boolean server;
    private PeerConnect peerConnect;
    private PeerSession peerSession;
    private TorrentSession torrentSession;
    private PeerConnectSession peerConnectSession;
    private IEncryptMessageSender messageEncryptSender;
    private ExtensionMessageHandler extensionMessageHandler;
    private DhtExtensionMessageHandler dhtExtensionMessageHandler;

    private PeerSubMessageHandler() {
        this.server = true;
    }

    private PeerSubMessageHandler(PeerSession peerSession, TorrentSession torrentSession) {
        this.server = false;
        this.init(peerSession, torrentSession);
    }

    public static final PeerSubMessageHandler newInstance() {
        return new PeerSubMessageHandler();
    }

    public static final PeerSubMessageHandler newInstance(PeerSession peerSession, TorrentSession torrentSession) {
        return new PeerSubMessageHandler(peerSession, torrentSession);
    }

    private void init(PeerSession peerSession, TorrentSession torrentSession) {
        this.peerSession = peerSession;
        this.torrentSession = torrentSession;
        this.extensionMessageHandler = ExtensionMessageHandler.newInstance(this.peerSession, this.torrentSession, this);
        this.dhtExtensionMessageHandler = DhtExtensionMessageHandler.newInstance(this.peerSession, this.torrentSession, this);
    }

    private boolean initServer(String infoHashHex, byte[] peerId) {
        if (Arrays.equals(PeerConfig.getInstance().getPeerId(), peerId)) {
            LOGGER.debug("Peer\u63a5\u5165\u5931\u8d25\uff08PeerId\u4e00\u81f4\uff09", new Object[0]);
            return false;
        }
        TorrentSession torrentSession = TorrentContext.getInstance().torrentSession(infoHashHex);
        if (torrentSession == null) {
            LOGGER.debug("Peer\u63a5\u5165\u5931\u8d25\uff08\u79cd\u5b50\u4fe1\u606f\u4e0d\u5b58\u5728\uff09\uff1a{}", infoHashHex);
            return false;
        }
        if (!torrentSession.useable()) {
            LOGGER.debug("Peer\u63a5\u5165\u5931\u8d25\uff08\u4efb\u52a1\u6ca1\u6709\u51c6\u5907\u5b8c\u6210\uff09\uff1a{}", infoHashHex);
            return false;
        }
        InetSocketAddress socketAddress = this.remoteSocketAddress();
        if (socketAddress == null) {
            LOGGER.debug("Peer\u63a5\u5165\u5931\u8d25\uff08\u8fdc\u7a0b\u5ba2\u6237\u7aef\u83b7\u53d6\u5931\u8d25\uff09\uff1a{}", infoHashHex);
            return false;
        }
        PeerSession peerSession = PeerContext.getInstance().newPeerSession(infoHashHex, torrentSession.statistics(), socketAddress.getHostString(), null, PeerConfig.Source.CONNECT);
        PeerUploader peerUploader = torrentSession.newPeerUploader(peerSession, this);
        if (peerUploader == null) {
            return false;
        }
        this.init(peerSession, torrentSession);
        this.peerConnect = peerUploader;
        this.peerConnectSession = peerUploader.peerConnectSession();
        this.peerSession.peerUploader(peerUploader);
        return true;
    }

    public PeerSubMessageHandler initClient(PeerDownloader peerDownloader) {
        this.peerConnect = peerDownloader;
        this.peerConnectSession = peerDownloader.peerConnectSession();
        this.peerSession.peerDownloader(peerDownloader);
        return this;
    }

    public boolean useless() {
        if (this.handshakeRecv) {
            return false;
        }
        return ++this.uselessCheck > 3;
    }

    public boolean handshakeRecv() {
        return this.handshakeRecv;
    }

    public TorrentSession torrentSession() {
        return this.torrentSession;
    }

    public boolean needEncrypt() {
        if (this.peerSession == null) {
            return false;
        }
        return this.peerSession.encrypt();
    }

    public PeerSubMessageHandler messageEncryptSender(IEncryptMessageSender messageEncryptSender) {
        this.messageEncryptSender = messageEncryptSender;
        return this;
    }

    @Override
    public final IPeerConnect.ConnectType connectType() {
        return this.messageEncryptSender.connectType();
    }

    @Override
    public void onMessage(ByteBuffer buffer) throws NetException {
        if (this.handshakeRecv) {
            byte typeId = buffer.get();
            PeerConfig.Type type = PeerConfig.Type.of(typeId);
            if (type == null) {
                LOGGER.warn("\u5904\u7406Peer\u6d88\u606f\u9519\u8bef\uff08\u672a\u77e5\u7c7b\u578b\uff09\uff1a{}", typeId);
                return;
            }
            if (!this.available) {
                LOGGER.debug("\u5904\u7406Peer\u6d88\u606f\u9519\u8bef\uff08\u72b6\u6001\u9519\u8bef\uff09\uff1a{}-{}-{}-{}", this.server, this.available, this.handshakeSend, this.handshakeRecv);
                return;
            }
            LOGGER.debug("\u5904\u7406Peer\u6d88\u606f\u7c7b\u578b\uff1a{}", new Object[]{type});
            switch (type) {
                case CHOKE: {
                    this.choke(buffer);
                    break;
                }
                case UNCHOKE: {
                    this.unchoke(buffer);
                    break;
                }
                case INTERESTED: {
                    this.interested(buffer);
                    break;
                }
                case NOT_INTERESTED: {
                    this.notInterested(buffer);
                    break;
                }
                case HAVE: {
                    this.have(buffer);
                    break;
                }
                case BITFIELD: {
                    this.bitfield(buffer);
                    break;
                }
                case REQUEST: {
                    this.request(buffer);
                    break;
                }
                case PIECE: {
                    this.piece(buffer);
                    break;
                }
                case CANCEL: {
                    this.cancel(buffer);
                    break;
                }
                case DHT: {
                    this.dht(buffer);
                    break;
                }
                case EXTENSION: {
                    this.extension(buffer);
                    break;
                }
                case HAVE_ALL: {
                    this.haveAll(buffer);
                    break;
                }
                case HAVE_NONE: {
                    this.haveNone(buffer);
                    break;
                }
                case SUGGEST_PIECE: {
                    this.suggestPiece(buffer);
                    break;
                }
                case REJECT_REQUEST: {
                    this.rejectRequest(buffer);
                    break;
                }
                case ALLOWED_FAST: {
                    this.allowedFast(buffer);
                    break;
                }
                default: {
                    LOGGER.warn("\u5904\u7406Peer\u6d88\u606f\u9519\u8bef\uff08\u7c7b\u578b\u672a\u9002\u914d\uff09\uff1a{}", new Object[]{type});
                    break;
                }
            }
        } else {
            this.handshakeRecv = true;
            boolean success = this.handshake(buffer);
            if (success) {
                LOGGER.debug("Peer\u63e1\u624b\u6210\u529f\uff1a{}", this.peerSession);
            } else {
                LOGGER.debug("Peer\u63e1\u624b\u5931\u8d25\uff1a{}", this.peerSession);
                this.close();
            }
        }
    }

    public void handshake() {
        if (this.handshakeSend) {
            LOGGER.debug("\u63e1\u624b\u6d88\u606f\u5df2\u7ecf\u53d1\u9001", new Object[0]);
            return;
        }
        LOGGER.debug("\u53d1\u9001\u63e1\u624b\u6d88\u606f", new Object[0]);
        this.handshakeSend = true;
        ByteBuffer buffer = ByteBuffer.allocate(68);
        buffer.put((byte)PeerConfig.PROTOCOL_NAME_LENGTH);
        buffer.put(PeerConfig.PROTOCOL_NAME_BYTES);
        buffer.put(PeerConfig.RESERVED);
        buffer.put(this.torrentSession.infoHash().getInfoHash());
        buffer.put(PeerConfig.getInstance().getPeerId());
        this.sendEncrypt(buffer, 5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean handshake(ByteBuffer buffer) {
        LOGGER.debug("\u5904\u7406\u63e1\u624b\u6d88\u606f", new Object[0]);
        int remaining = buffer.remaining();
        if (remaining != 68) {
            LOGGER.warn("\u5904\u7406\u63e1\u624b\u6d88\u606f\u683c\u5f0f\u9519\u8bef\uff08\u6d88\u606f\u957f\u5ea6\uff09\uff1a{}", remaining);
            return false;
        }
        byte length = buffer.get();
        if (length != PeerConfig.PROTOCOL_NAME_LENGTH) {
            LOGGER.warn("\u5904\u7406\u63e1\u624b\u6d88\u606f\u683c\u5f0f\u9519\u8bef\uff08\u534f\u8bae\u957f\u5ea6\uff09\uff1a{}", length);
            return false;
        }
        byte[] name = new byte[length];
        buffer.get(name);
        if (!Arrays.equals(name, PeerConfig.PROTOCOL_NAME_BYTES)) {
            String nameValue = new String(name);
            LOGGER.warn("\u5904\u7406\u63e1\u624b\u6d88\u606f\u683c\u5f0f\u9519\u8bef\uff08\u4e0b\u8f7d\u534f\u8bae\u9519\u8bef\uff09\uff1a{}", nameValue);
            return false;
        }
        byte[] reserved = new byte[PeerConfig.RESERVED_LENGTH];
        buffer.get(reserved);
        byte[] infoHash = new byte[20];
        buffer.get(infoHash);
        String infoHashHex = StringUtils.hex(infoHash);
        byte[] peerId = new byte[20];
        buffer.get(peerId);
        if (this.server) {
            if (!this.initServer(infoHashHex, peerId)) return false;
            this.available = true;
        } else {
            this.available = true;
        }
        this.handshake();
        this.peerSession.id(peerId);
        this.peerSession.reserved(reserved);
        this.fastBitfield();
        this.extension();
        this.dht();
        this.unchoke();
        return true;
    }

    public void keepAlive() {
        LOGGER.debug("\u53d1\u9001\u5fc3\u8df3\u6d88\u606f", new Object[0]);
        this.pushMessage(null, null);
    }

    public void choke() {
        LOGGER.debug("\u53d1\u9001\u963b\u585e\u6d88\u606f", new Object[0]);
        this.peerConnectSession.amChoked();
        this.pushMessage(PeerConfig.Type.CHOKE);
    }

    private void choke(ByteBuffer buffer) {
        LOGGER.debug("\u5904\u7406\u963b\u585e\u6d88\u606f", new Object[0]);
        this.peerConnectSession.peerChoked();
    }

    private void unchoke() {
        if (!this.torrentSession.uploadable()) {
            LOGGER.debug("\u53d1\u9001\u89e3\u9664\u963b\u585e\u6d88\u606f\uff1a\u4efb\u52a1\u4e0d\u53ef\u4e0a\u4f20", new Object[0]);
            return;
        }
        if (this.peerSession.uploadOnly()) {
            LOGGER.debug("\u53d1\u9001\u89e3\u9664\u963b\u585e\u6d88\u606f\uff1aPeer\u53ea\u4e0a\u4f20\u4e0d\u4e0b\u8f7d", new Object[0]);
            return;
        }
        if (this.peerConnectSession.isAmUnchoked()) {
            LOGGER.debug("\u53d1\u9001\u89e3\u9664\u963b\u585e\u6d88\u606f\uff1a\u5df2\u7ecf\u89e3\u9664", new Object[0]);
            return;
        }
        LOGGER.debug("\u53d1\u9001\u89e3\u9664\u963b\u585e\u6d88\u606f", new Object[0]);
        this.peerConnectSession.amUnchoked();
        this.pushMessage(PeerConfig.Type.UNCHOKE);
    }

    private void unchoke(ByteBuffer buffer) {
        if (!this.torrentSession.downloadable()) {
            LOGGER.debug("\u5904\u7406\u89e3\u9664\u963b\u585e\u6d88\u606f\uff1a\u4efb\u52a1\u4e0d\u53ef\u4e0b\u8f7d", new Object[0]);
            return;
        }
        LOGGER.debug("\u5904\u7406\u89e3\u9664\u963b\u585e\u6d88\u606f", new Object[0]);
        this.peerConnectSession.peerUnchoked();
        this.unchokeDownload();
    }

    private void interested() {
        if (this.peerConnectSession.isAmInterested()) {
            LOGGER.debug("\u53d1\u9001\u611f\u5174\u8da3\u6d88\u606f\uff1a\u5df2\u7ecf\u611f\u5174\u8da3", new Object[0]);
            return;
        }
        LOGGER.debug("\u53d1\u9001\u611f\u5174\u8da3\u6d88\u606f", new Object[0]);
        this.peerConnectSession.amInterested();
        this.pushMessage(PeerConfig.Type.INTERESTED);
    }

    private void interested(ByteBuffer buffer) {
        LOGGER.debug("\u5904\u7406\u611f\u5174\u8da3\u6d88\u606f", new Object[0]);
        this.peerConnectSession.peerInterested();
    }

    public void notInterested() {
        if (this.peerConnectSession.isAmNotInterested()) {
            LOGGER.debug("\u53d1\u9001\u4e0d\u611f\u5174\u8da3\u6d88\u606f\uff1a\u5df2\u7ecf\u4e0d\u611f\u5174\u8da3", new Object[0]);
            return;
        }
        LOGGER.debug("\u53d1\u9001\u4e0d\u611f\u5174\u8da3\u6d88\u606f", new Object[0]);
        this.peerConnectSession.amNotInterested();
        this.pushMessage(PeerConfig.Type.NOT_INTERESTED);
    }

    private void notInterested(ByteBuffer buffer) {
        LOGGER.debug("\u5904\u7406\u4e0d\u611f\u5174\u8da3\u6d88\u606f", new Object[0]);
        this.peerConnectSession.peerNotInterested();
    }

    public void have(Integer ... indexArray) {
        if (ArrayUtils.isEmpty(indexArray)) {
            LOGGER.debug("\u53d1\u9001have\u6d88\u606f\uff1a\u6ca1\u6709\u53ef\u7528\u7d22\u5f15", new Object[0]);
            return;
        }
        if (!this.torrentSession.uploadable()) {
            LOGGER.debug("\u53d1\u9001have\u6d88\u606f\uff1a\u4efb\u52a1\u4e0d\u53ef\u4e0a\u4f20", new Object[0]);
            return;
        }
        if (this.peerSession.uploadOnly()) {
            LOGGER.debug("\u53d1\u9001have\u6d88\u606f\uff1aPeer\u53ea\u4e0a\u4f20\u4e0d\u4e0b\u8f7d", new Object[0]);
            return;
        }
        int pos = 0;
        int length = 0;
        byte[] bytes = new byte[9 * indexArray.length];
        for (Integer index : indexArray) {
            if (this.peerSession.hasPiece(index)) {
                LOGGER.debug("\u53d1\u9001have\u6d88\u606f\uff1aPeer\u5df2\u7ecf\u542b\u6709", new Object[0]);
                continue;
            }
            LOGGER.debug("\u53d1\u9001have\u6d88\u606f\uff1a{}", index);
            byte[] message = this.buildMessage(PeerConfig.Type.HAVE, NumberUtils.intToBytes(index)).array();
            length = message.length;
            System.arraycopy(message, 0, bytes, pos, length);
            pos += length;
        }
        if (pos > 0) {
            ByteBuffer buffer = ByteBuffer.allocate(pos);
            buffer.put(bytes, 0, pos);
            this.sendEncrypt(buffer);
        }
    }

    private void have(ByteBuffer buffer) {
        if (!this.torrentSession.downloadable()) {
            LOGGER.debug("\u5904\u7406have\u6d88\u606f\uff1a\u4efb\u52a1\u4e0d\u53ef\u4e0b\u8f7d", new Object[0]);
            return;
        }
        int index = buffer.getInt();
        LOGGER.debug("\u5904\u7406have\u6d88\u606f\uff1a{}", index);
        this.peerSession.piece(index);
        if (!this.torrentSession.hasPiece(index)) {
            this.interested();
        }
    }

    private void haveAll() {
        if (!this.torrentSession.uploadable()) {
            LOGGER.debug("\u53d1\u9001haveAll\u6d88\u606f\uff1a\u4efb\u52a1\u4e0d\u53ef\u4e0a\u4f20", new Object[0]);
            return;
        }
        if (this.peerSession.uploadOnly()) {
            LOGGER.debug("\u53d1\u9001haveAll\u6d88\u606f\uff1aPeer\u53ea\u4e0a\u4f20\u4e0d\u4e0b\u8f7d", new Object[0]);
            return;
        }
        LOGGER.debug("\u53d1\u9001haveAll\u6d88\u606f", new Object[0]);
        this.pushMessage(PeerConfig.Type.HAVE_ALL);
    }

    private void haveAll(ByteBuffer buffer) {
        if (!this.torrentSession.downloadable()) {
            LOGGER.debug("\u5904\u7406haveAll\u6d88\u606f\uff1a\u4efb\u52a1\u4e0d\u53ef\u4e0b\u8f7d", new Object[0]);
            return;
        }
        LOGGER.debug("\u5904\u7406haveAll\u6d88\u606f", new Object[0]);
        BitSet allPieces = this.torrentSession.allPieces();
        this.peerSession.pieces(allPieces);
        this.torrentSession.fullPieces();
        if (!this.torrentSession.completed()) {
            this.interested();
        }
    }

    private void haveNone() {
        LOGGER.debug("\u53d1\u9001haveNone\u6d88\u606f", new Object[0]);
        this.pushMessage(PeerConfig.Type.HAVE_NONE);
    }

    private void haveNone(ByteBuffer buffer) {
        LOGGER.debug("\u5904\u7406haveAll\u6d88\u606f", new Object[0]);
        this.peerSession.cleanPieces();
        this.notInterested();
    }

    public void suggestPiece(int index) {
        if (!this.peerSession.supportFastExtensionProtocol()) {
            LOGGER.debug("\u53d1\u9001suggestPiece\u6d88\u606f\uff1aPeer\u4e0d\u652f\u6301Fast\u6269\u5c55", new Object[0]);
            return;
        }
        if (!this.torrentSession.uploadable()) {
            LOGGER.debug("\u53d1\u9001suggestPiece\u6d88\u606f\uff1a\u4efb\u52a1\u4e0d\u53ef\u4e0a\u4f20", new Object[0]);
            return;
        }
        if (this.peerSession.uploadOnly()) {
            LOGGER.debug("\u53d1\u9001suggestPiece\u6d88\u606f\uff1aPeer\u53ea\u4e0a\u4f20\u4e0d\u4e0b\u8f7d", new Object[0]);
            return;
        }
        if (this.peerSession.hasPiece(index)) {
            LOGGER.debug("\u53d1\u9001suggestPiece\u6d88\u606f\uff1aPeer\u5df2\u7ecf\u542b\u6709", new Object[0]);
            return;
        }
        LOGGER.debug("\u53d1\u9001suggestPiece\u6d88\u606f\uff1a{}", index);
        this.pushMessage(PeerConfig.Type.SUGGEST_PIECE, NumberUtils.intToBytes(index));
    }

    private void suggestPiece(ByteBuffer buffer) {
        if (!this.torrentSession.downloadable()) {
            LOGGER.debug("\u5904\u7406suggestPiece\u6d88\u606f\uff1a\u4efb\u52a1\u4e0d\u53ef\u4e0b\u8f7d", new Object[0]);
            return;
        }
        int index = buffer.getInt();
        LOGGER.debug("\u5904\u7406suggestPiece\u6d88\u606f\uff1a{}", index);
        this.peerSession.suggestPieces(index);
        if (!this.torrentSession.hasPiece(index)) {
            this.interested();
        }
    }

    private void rejectRequest(int index, int begin, int length) {
        if (!this.peerSession.supportFastExtensionProtocol()) {
            LOGGER.debug("\u53d1\u9001rejectRequest\u6d88\u606f\uff1aPeer\u4e0d\u652f\u6301Fast\u6269\u5c55", new Object[0]);
            return;
        }
        LOGGER.debug("\u53d1\u9001rejectRequest\u6d88\u606f\uff1a{}-{}-{}", index, begin, length);
        ByteBuffer buffer = ByteBuffer.allocate(12);
        buffer.putInt(index);
        buffer.putInt(begin);
        buffer.putInt(length);
        this.pushMessage(PeerConfig.Type.REJECT_REQUEST, buffer.array());
    }

    private void rejectRequest(ByteBuffer buffer) {
        int index = buffer.getInt();
        int begin = buffer.getInt();
        int length = buffer.getInt();
        LOGGER.debug("\u5904\u7406rejectRequest\u6d88\u606f\uff1a{}-{}-{}", index, begin, length);
    }

    public void allowedFast(int index) {
        if (!this.peerSession.supportFastExtensionProtocol()) {
            LOGGER.debug("\u53d1\u9001allowedFast\u6d88\u606f\uff1aPeer\u4e0d\u652f\u6301Fast\u6269\u5c55", new Object[0]);
            return;
        }
        if (!this.torrentSession.uploadable()) {
            LOGGER.debug("\u53d1\u9001allowedFast\u6d88\u606f\uff1a\u4efb\u52a1\u4e0d\u53ef\u4e0a\u4f20", new Object[0]);
            return;
        }
        if (this.peerSession.uploadOnly()) {
            LOGGER.debug("\u53d1\u9001allowedFast\u6d88\u606f\uff1aPeer\u53ea\u4e0a\u4f20\u4e0d\u4e0b\u8f7d", new Object[0]);
            return;
        }
        if (this.peerSession.hasPiece(index)) {
            LOGGER.debug("\u53d1\u9001allowedFast\u6d88\u606f\uff1aPeer\u5df2\u7ecf\u542b\u6709", new Object[0]);
            return;
        }
        LOGGER.debug("\u53d1\u9001allowedFast\u6d88\u606f\uff1a{}", index);
        this.pushMessage(PeerConfig.Type.ALLOWED_FAST, NumberUtils.intToBytes(index));
    }

    private void allowedFast(ByteBuffer buffer) {
        if (!this.torrentSession.downloadable()) {
            LOGGER.debug("\u5904\u7406allowedFast\u6d88\u606f\uff1a\u4efb\u52a1\u4e0d\u53ef\u4e0b\u8f7d", new Object[0]);
            return;
        }
        int index = buffer.getInt();
        LOGGER.debug("\u5904\u7406allowedFast\u6d88\u606f\uff1a{}", index);
        this.peerSession.allowedPieces(index);
        if (!this.torrentSession.hasPiece(index)) {
            this.interested();
        }
        this.allowedFastDownload();
    }

    private void fastBitfield() {
        if (!this.torrentSession.uploadable()) {
            LOGGER.debug("\u5feb\u901f\u4ea4\u6362Piece\u4f4d\u56fe\uff1a\u4efb\u52a1\u4e0d\u53ef\u4e0a\u4f20", new Object[0]);
            return;
        }
        if (this.peerSession.uploadOnly()) {
            LOGGER.debug("\u5feb\u901f\u4ea4\u6362Piece\u4f4d\u56fe\uff1aPeer\u53ea\u4e0a\u4f20\u4e0d\u4e0b\u8f7d", new Object[0]);
            return;
        }
        if (this.peerSession.supportFastExtensionProtocol()) {
            BitSet pieces = this.torrentSession.pieces();
            if (pieces.isEmpty()) {
                this.haveNone();
                return;
            }
            if (this.torrentSession.completed()) {
                BitSet allPieces = this.torrentSession.allPieces();
                allPieces.andNot(pieces);
                if (allPieces.isEmpty()) {
                    this.haveAll();
                    return;
                }
            }
        }
        this.bitfield();
    }

    private void bitfield() {
        if (!this.torrentSession.uploadable()) {
            LOGGER.debug("\u53d1\u9001Piece\u4f4d\u56fe\u6d88\u606f\uff1a\u4efb\u52a1\u4e0d\u53ef\u4e0a\u4f20", new Object[0]);
            return;
        }
        if (this.peerSession.uploadOnly()) {
            LOGGER.debug("\u53d1\u9001Piece\u4f4d\u56fe\u6d88\u606f\uff1aPeer\u53ea\u4e0a\u4f20\u4e0d\u4e0b\u8f7d", new Object[0]);
            return;
        }
        BitSet pieces = this.torrentSession.pieces();
        LOGGER.debug("\u53d1\u9001Piece\u4f4d\u56fe\u6d88\u606f\uff1a{}", pieces);
        int pieceSize = this.torrentSession.torrent().getInfo().pieceSize();
        this.pushMessage(PeerConfig.Type.BITFIELD, BitfieldUtils.toBytes(pieceSize, pieces));
    }

    private void bitfield(ByteBuffer buffer) {
        if (!this.torrentSession.downloadable()) {
            LOGGER.debug("\u5904\u7406Piece\u4f4d\u56fe\u6d88\u606f\uff1a\u4efb\u52a1\u4e0d\u53ef\u4e0b\u8f7d", new Object[0]);
            return;
        }
        byte[] bytes = ByteUtils.remainingToBytes(buffer);
        BitSet pieces = BitfieldUtils.toBitSet(bytes);
        this.peerSession.pieces(pieces);
        this.torrentSession.fullPieces(pieces);
        BitSet notHave = new BitSet();
        notHave.or(pieces);
        notHave.andNot(this.torrentSession.pieces());
        LOGGER.debug("\u5904\u7406Piece\u4f4d\u56fe\u6d88\u606f\nPeer\u5df2\u7ecf\u4e0b\u8f7dPiece\u4f4d\u56fe\uff1a{}\n\u5ba2\u6237\u7aef\u6ca1\u6709\u4e0b\u8f7dPiece\u4f4d\u56fe\uff1a{}", pieces, notHave);
        if (notHave.isEmpty()) {
            this.notInterested();
        } else {
            this.interested();
        }
    }

    public void request(int index, int begin, int length) {
        if (!this.torrentSession.downloadable()) {
            LOGGER.debug("\u53d1\u9001request\u6d88\u606f\uff1a\u4efb\u52a1\u4e0d\u53ef\u4e0b\u8f7d", new Object[0]);
            return;
        }
        if (this.peerConnectSession.isPeerChoked()) {
            LOGGER.debug("\u53d1\u9001request\u6d88\u606f\uff1a\u963b\u585e", new Object[0]);
            return;
        }
        LOGGER.debug("\u53d1\u9001request\u6d88\u606f\uff1a{}-{}-{}", index, begin, length);
        ByteBuffer buffer = ByteBuffer.allocate(12);
        buffer.putInt(index);
        buffer.putInt(begin);
        buffer.putInt(length);
        this.pushMessage(PeerConfig.Type.REQUEST, buffer.array());
    }

    private void request(ByteBuffer buffer) {
        if (!this.torrentSession.uploadable()) {
            LOGGER.debug("\u5904\u7406request\u6d88\u606f\uff1a\u4efb\u52a1\u4e0d\u53ef\u4e0a\u4f20", new Object[0]);
            return;
        }
        int index = buffer.getInt();
        int begin = buffer.getInt();
        int length = buffer.getInt();
        if (this.peerConnectSession.isAmChoked()) {
            LOGGER.debug("\u5904\u7406request\u6d88\u606f\uff1a\u963b\u585e", new Object[0]);
            this.rejectRequest(index, begin, length);
            return;
        }
        if (this.peerSession.getUploadSize() > this.torrentSession.size()) {
            LOGGER.debug("\u5904\u7406request\u6d88\u606f\uff1a\u7d2f\u8ba1\u4e0a\u4f20\u5927\u5c0f\u8d85\u8fc7\u4efb\u52a1\u5927\u5c0f", new Object[0]);
            this.choke();
            this.rejectRequest(index, begin, length);
            return;
        }
        if (this.torrentSession.hasPiece(index)) {
            LOGGER.debug("\u5904\u7406request\u6d88\u606f\uff1a{}-{}-{}", index, begin, length);
            try {
                this.piece(index, begin, this.torrentSession.read(index, begin, length));
            }
            catch (NetException e) {
                LOGGER.error("\u5904\u7406request\u6d88\u606f\u5f02\u5e38", e);
            }
        } else {
            LOGGER.debug("\u5904\u7406request\u6d88\u606f\uff1aPiece\u6ca1\u6709\u4e0b\u8f7d", new Object[0]);
        }
    }

    private void piece(int index, int begin, byte[] bytes) {
        if (!this.torrentSession.uploadable()) {
            LOGGER.debug("\u53d1\u9001piece\u6d88\u606f\uff1a\u4efb\u52a1\u4e0d\u53ef\u4e0a\u4f20", new Object[0]);
            return;
        }
        LOGGER.debug("\u53d1\u9001piece\u6d88\u606f\uff1a{}-{}", index, begin);
        this.peerConnect.uploadMark(bytes.length);
        ByteBuffer buffer = ByteBuffer.allocate(8 + bytes.length);
        buffer.putInt(index);
        buffer.putInt(begin);
        buffer.put(bytes);
        this.pushMessage(PeerConfig.Type.PIECE, buffer.array());
    }

    private void piece(ByteBuffer buffer) {
        if (!this.torrentSession.downloadable()) {
            LOGGER.debug("\u5904\u7406piece\u6d88\u606f\uff1a\u4efb\u52a1\u4e0d\u53ef\u4e0b\u8f7d", new Object[0]);
            return;
        }
        int index = buffer.getInt();
        int begin = buffer.getInt();
        LOGGER.debug("\u5904\u7406piece\u6d88\u606f\uff1a{}-{}", index, begin);
        byte[] bytes = ByteUtils.remainingToBytes(buffer);
        if (this.peerConnect != null) {
            this.peerConnect.downloadMark(bytes.length);
            this.peerConnect.piece(index, begin, bytes);
        }
    }

    public void cancel(int index, int begin, int length) {
        LOGGER.debug("\u53d1\u9001cancel\u6d88\u606f\uff1a{}", index);
        ByteBuffer buffer = ByteBuffer.allocate(12);
        buffer.putInt(index);
        buffer.putInt(begin);
        buffer.putInt(length);
        this.pushMessage(PeerConfig.Type.CANCEL, buffer.array());
    }

    private void cancel(ByteBuffer buffer) {
        int index = buffer.getInt();
        int begin = buffer.getInt();
        int length = buffer.getInt();
        LOGGER.debug("\u5904\u7406cancel\u6d88\u606f\uff1a{}-{}-{}", index, begin, length);
    }

    private void dht() {
        if (this.peerSession.supportDhtProtocol()) {
            this.dhtExtensionMessageHandler.port();
        }
    }

    private void dht(ByteBuffer buffer) {
        this.dhtExtensionMessageHandler.onMessage(buffer);
    }

    private void extension() {
        if (this.peerSession.supportExtensionProtocol()) {
            this.extensionMessageHandler.handshake();
        }
    }

    private void extension(ByteBuffer buffer) throws NetException {
        this.extensionMessageHandler.onMessage(buffer);
    }

    public void pex(byte[] bytes) {
        this.extensionMessageHandler.pex(bytes);
    }

    public void uploadOnly() {
        this.extensionMessageHandler.uploadOnly();
    }

    public void holepunchRendezvous(PeerSession peerSession) {
        this.extensionMessageHandler.holepunchRendezvous(peerSession);
    }

    public void holepunchConnect(String host, int port) {
        this.extensionMessageHandler.holepunchConnect(host, port);
    }

    public void pushMessage(PeerConfig.Type type) {
        this.pushMessage(type, null);
    }

    public void pushMessage(PeerConfig.Type type, byte[] payload) {
        this.sendEncrypt(this.buildMessage(type, payload));
    }

    private ByteBuffer buildMessage(PeerConfig.Type type, byte[] payload) {
        Byte id = type == null ? null : Byte.valueOf(type.getId());
        int capacity = 0;
        if (id != null) {
            ++capacity;
        }
        if (payload != null) {
            capacity += payload.length;
        }
        ByteBuffer buffer = ByteBuffer.allocate(capacity + 4);
        buffer.putInt(capacity);
        if (id != null) {
            buffer.put(id);
        }
        if (payload != null) {
            buffer.put(payload);
        }
        return buffer;
    }

    public void close() {
        this.messageEncryptSender.close();
    }

    public boolean available() {
        return this.messageEncryptSender.available();
    }

    public void send(ByteBuffer buffer) {
        try {
            this.messageEncryptSender.send(buffer);
        }
        catch (NetException e) {
            LOGGER.error("\u53d1\u9001Peer\u6d88\u606f\u5f02\u5e38\uff1a{}", this.peerSession, e);
        }
    }

    public void send(ByteBuffer buffer, int timeout) {
        try {
            this.messageEncryptSender.send(buffer, timeout);
        }
        catch (NetException e) {
            LOGGER.error("\u53d1\u9001Peer\u6d88\u606f\u5f02\u5e38\uff1a{}", this.peerSession, e);
        }
    }

    public void sendEncrypt(ByteBuffer buffer) {
        try {
            this.messageEncryptSender.sendEncrypt(buffer);
        }
        catch (NetException e) {
            LOGGER.error("\u53d1\u9001\u52a0\u5bc6Peer\u6d88\u606f\u5f02\u5e38\uff1a{}", this.peerSession, e);
        }
    }

    public void sendEncrypt(ByteBuffer buffer, int timeout) {
        try {
            this.messageEncryptSender.sendEncrypt(buffer, timeout);
        }
        catch (NetException e) {
            LOGGER.error("\u53d1\u9001\u52a0\u5bc6Peer\u6d88\u606f\u5f02\u5e38\uff1a{}", this.peerSession, e);
        }
    }

    private InetSocketAddress remoteSocketAddress() {
        return this.messageEncryptSender.remoteSocketAddress();
    }

    private void unchokeDownload() {
        if (this.peerConnectSession != null && this.peerConnectSession.isPeerUnchoked() && this.peerConnect != null) {
            this.peerConnect.download();
        }
    }

    private void allowedFastDownload() {
        if (this.peerSession != null && this.peerSession.supportAllowedFast() && this.peerConnectSession != null && this.peerConnectSession.isPeerChoked() && this.peerConnect != null) {
            this.peerConnect.download();
        }
    }
}

