/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.peer;

import com.acgist.snail.config.SystemConfig;
import com.acgist.snail.context.SystemThreadContext;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.torrent.TorrentSession;
import com.acgist.snail.net.torrent.peer.PeerSession;
import com.acgist.snail.net.torrent.peer.PeerSubMessageHandler;
import com.acgist.snail.net.torrent.peer.PeerUploader;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public final class PeerUploaderGroup {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeerUploaderGroup.class);
    private final TorrentSession torrentSession;
    private final BlockingQueue<PeerUploader> peerUploaders;

    private PeerUploaderGroup(TorrentSession torrentSession) {
        this.torrentSession = torrentSession;
        this.peerUploaders = new LinkedBlockingQueue<PeerUploader>();
    }

    public static final PeerUploaderGroup newInstance(TorrentSession torrentSession) {
        return new PeerUploaderGroup(torrentSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download() {
        BlockingQueue<PeerUploader> blockingQueue = this.peerUploaders;
        synchronized (blockingQueue) {
            this.peerUploaders.forEach(PeerUploader::download);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerUploader newPeerUploader(PeerSession peerSession, PeerSubMessageHandler peerSubMessageHandler) {
        BlockingQueue<PeerUploader> blockingQueue = this.peerUploaders;
        synchronized (blockingQueue) {
            if (!this.connectable(peerSession)) {
                LOGGER.debug("Peer\u63a5\u5165\u5931\u8d25\uff1a{}", peerSession);
                return null;
            }
            LOGGER.debug("Peer\u63a5\u5165\u6210\u529f\uff1a{}", peerSession);
            PeerUploader peerUploader = PeerUploader.newInstance(peerSession, this.torrentSession, peerSubMessageHandler);
            peerSession.status((byte)2);
            this.offer(peerUploader);
            return peerUploader;
        }
    }

    private boolean connectable(PeerSession peerSession) {
        if (peerSession.downloading()) {
            return true;
        }
        return this.peerUploaders.size() < SystemConfig.getPeerSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optimize() {
        LOGGER.debug("\u4f18\u5316PeerUploader\uff1a{}", this.torrentSession);
        BlockingQueue<PeerUploader> blockingQueue = this.peerUploaders;
        synchronized (blockingQueue) {
            try {
                this.inferiorPeerUploaders();
            }
            catch (Exception e) {
                LOGGER.error("\u4f18\u5316PeerUploader\u5f02\u5e38", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        LOGGER.debug("\u91ca\u653ePeerUploaderGroup\uff1a{}", this.torrentSession);
        BlockingQueue<PeerUploader> blockingQueue = this.peerUploaders;
        synchronized (blockingQueue) {
            this.peerUploaders.forEach(uploader -> SystemThreadContext.submit(uploader::release));
            this.peerUploaders.clear();
        }
    }

    private void inferiorPeerUploaders() {
        PeerUploader uploader;
        LOGGER.debug("\u5254\u9664\u65e0\u6548PeerUploader\uff1a{}", this.torrentSession);
        int index = 0;
        int offerSize = 0;
        int size = this.peerUploaders.size();
        int maxSize = SystemConfig.getPeerSize();
        while (index++ < size && (uploader = (PeerUploader)this.peerUploaders.poll()) != null) {
            if (!uploader.available()) {
                LOGGER.debug("\u5254\u9664\u65e0\u6548PeerUploader\uff08\u72b6\u6001\u65e0\u6548\uff09", new Object[0]);
                this.inferior(uploader);
                continue;
            }
            long uploadMark = uploader.uploadMark();
            long downloadMark = uploader.downloadMark();
            if (downloadMark > 0L || uploader.peerSession().downloading()) {
                ++offerSize;
                this.offer(uploader);
                continue;
            }
            if (uploadMark <= 0L) {
                LOGGER.debug("\u5254\u9664\u65e0\u6548PeerUploader\uff08\u6ca1\u6709\u8bc4\u5206\uff09", new Object[0]);
                this.inferior(uploader);
                continue;
            }
            if (offerSize > maxSize) {
                LOGGER.debug("\u5254\u9664\u65e0\u6548PeerUploader\uff08\u8d85\u8fc7\u6700\u5927\u6570\u91cf\uff09", new Object[0]);
                this.inferior(uploader);
                continue;
            }
            ++offerSize;
            this.offer(uploader);
        }
    }

    private void offer(PeerUploader peerUploader) {
        if (!this.peerUploaders.offer(peerUploader)) {
            LOGGER.warn("PeerUploader\u4e22\u5931\uff1a{}", peerUploader);
        }
    }

    private void inferior(PeerUploader peerUploader) {
        if (peerUploader != null) {
            LOGGER.debug("\u5254\u9664\u65e0\u6548PeerUploader\uff1a{}", peerUploader);
            SystemThreadContext.submit(peerUploader::release);
        }
    }
}

