/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.peer.extension;

import com.acgist.snail.config.PeerConfig;
import com.acgist.snail.config.SystemConfig;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.torrent.TorrentSession;
import com.acgist.snail.net.torrent.peer.ExtensionMessageHandler;
import com.acgist.snail.net.torrent.peer.ExtensionTypeMessageHandler;
import com.acgist.snail.net.torrent.peer.PeerConnect;
import com.acgist.snail.net.torrent.peer.PeerContext;
import com.acgist.snail.net.torrent.peer.PeerSession;
import com.acgist.snail.net.torrent.peer.PeerSubMessageHandler;
import com.acgist.snail.net.torrent.utp.UtpClient;
import com.acgist.snail.utils.NetUtils;
import com.acgist.snail.utils.StringUtils;
import java.nio.ByteBuffer;

public final class HolepunchMessageHnadler
extends ExtensionTypeMessageHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(HolepunchMessageHnadler.class);
    private static final byte IPV4 = 0;
    private static final byte IPV6 = 1;
    private final TorrentSession torrentSession;

    private HolepunchMessageHnadler(PeerSession peerSession, TorrentSession torrentSession, ExtensionMessageHandler extensionMessageHandler) {
        super(PeerConfig.ExtensionType.UT_HOLEPUNCH, peerSession, extensionMessageHandler);
        this.torrentSession = torrentSession;
    }

    public static final HolepunchMessageHnadler newInstance(PeerSession peerSession, TorrentSession torrentSession, ExtensionMessageHandler extensionMessageHandler) {
        return new HolepunchMessageHnadler(peerSession, torrentSession, extensionMessageHandler);
    }

    @Override
    public void doMessage(ByteBuffer buffer) {
        int port;
        String host;
        byte typeId = buffer.get();
        PeerConfig.HolepunchType holepunchType = PeerConfig.HolepunchType.of(typeId);
        if (holepunchType == null) {
            LOGGER.warn("\u5904\u7406holepunch\u6d88\u606f\u9519\u8bef\uff08\u672a\u77e5\u7c7b\u578b\uff09\uff1a{}", typeId);
            return;
        }
        byte addrType = buffer.get();
        if (addrType == 0) {
            host = NetUtils.intToIP(buffer.getInt());
            port = NetUtils.portToInt(buffer.getShort());
        } else if (addrType == 1) {
            byte[] bytes = NetUtils.bufferToIPv6(buffer);
            host = NetUtils.bytesToIP(bytes);
            port = NetUtils.portToInt(buffer.getShort());
        } else {
            LOGGER.error("\u5904\u7406holepunch\u6d88\u606f\u9519\u8bef\uff08\u4e0d\u652f\u6301\u7684IP\u534f\u8bae\u7c7b\u578b\uff09\uff1a{}", addrType);
            return;
        }
        LOGGER.debug("\u5904\u7406holepunch\u6d88\u606f\uff1a{}", new Object[]{holepunchType});
        switch (holepunchType) {
            case RENDEZVOUS: {
                this.onRendezvous(host, port);
                break;
            }
            case CONNECT: {
                this.onConnect(host, port);
                break;
            }
            case ERROR: {
                this.onError(host, port, buffer.getInt());
                break;
            }
            default: {
                LOGGER.warn("\u5904\u7406holepunch\u6d88\u606f\u9519\u8bef\uff08\u7c7b\u578b\u672a\u9002\u914d\uff09\uff1a{}", new Object[]{holepunchType});
            }
        }
    }

    public void rendezvous(PeerSession peerSession) {
        String host = peerSession.host();
        int port = peerSession.port();
        LOGGER.debug("\u53d1\u9001holepunch\u6d88\u606f-rendezvous\uff1a{} - {}", host, port);
        this.pushMessage(this.buildMessage(PeerConfig.HolepunchType.RENDEZVOUS, host, port));
        peerSession.lockHolepunch();
    }

    private void onRendezvous(String host, int port) {
        LOGGER.debug("\u5904\u7406holepunch\u6d88\u606f-rendezvous\uff1a{} - {}", host, port);
        if (StringUtils.equals(host, SystemConfig.getExternalIPAddress())) {
            LOGGER.debug("\u5904\u7406holepunch\u6d88\u606f-rendezvous\u5931\u8d25\uff1a\u76ee\u6807\u5c5e\u4e8e\u4e2d\u7ee7", new Object[0]);
            this.error(host, port, PeerConfig.HolepunchErrorCode.CODE_04);
            return;
        }
        PeerSession peerSession = PeerContext.getInstance().findPeerSession(this.torrentSession.infoHashHex(), host, (Integer)port);
        if (peerSession == null) {
            LOGGER.debug("\u5904\u7406holepunch\u6d88\u606f-rendezvous\u5931\u8d25\uff1a\u76ee\u6807\u4e0d\u5b58\u5728", new Object[0]);
            this.error(host, port, PeerConfig.HolepunchErrorCode.CODE_01);
            return;
        }
        if (!peerSession.connected()) {
            LOGGER.debug("\u5904\u7406holepunch\u6d88\u606f-rendezvous\u5931\u8d25\uff1a\u76ee\u6807\u672a\u8fde\u63a5", new Object[0]);
            this.error(host, port, PeerConfig.HolepunchErrorCode.CODE_02);
            return;
        }
        if (!peerSession.supportExtensionType(PeerConfig.ExtensionType.UT_HOLEPUNCH)) {
            LOGGER.debug("\u5904\u7406holepunch\u6d88\u606f-rendezvous\u5931\u8d25\uff1a\u76ee\u6807\u4e0d\u652f\u6301\u534f\u8bae", new Object[0]);
            this.error(host, port, PeerConfig.HolepunchErrorCode.CODE_03);
            return;
        }
        this.connect(host, port);
        PeerConnect peerConnect = peerSession.peerConnect();
        if (peerConnect != null) {
            peerConnect.holepunchConnect(this.peerSession.host(), this.peerSession.port());
        } else {
            LOGGER.warn("\u5904\u7406holepunch\u6d88\u606f-rendezvous\u5931\u8d25\uff1a\u76ee\u6807\u5931\u6548", new Object[0]);
        }
    }

    public void connect(String host, int port) {
        LOGGER.debug("\u53d1\u9001holepunch\u6d88\u606f-connect\uff1a{} - {}", host, port);
        this.pushMessage(this.buildMessage(PeerConfig.HolepunchType.CONNECT, host, port));
    }

    private void onConnect(String host, int port) {
        LOGGER.debug("\u5904\u7406holepunch\u6d88\u606f-connect\uff1a{} - {}", host, port);
        PeerSession peerSession = PeerContext.getInstance().findPeerSession(this.torrentSession.infoHashHex(), host, (Integer)port);
        if (peerSession == null) {
            peerSession = PeerContext.getInstance().newPeerSession(this.torrentSession.infoHashHex(), this.torrentSession.statistics(), host, port, PeerConfig.Source.HOLEPUNCH);
        }
        if (peerSession.holepunchWait()) {
            LOGGER.debug("\u5904\u7406holepunch\u6d88\u606f-connect\uff1a\u91ca\u653eholepunch\u7b49\u5f85\u9501", new Object[0]);
            peerSession.unlockHolepunch();
        } else {
            if (peerSession.connected()) {
                LOGGER.debug("\u5904\u7406holepunch\u6d88\u606f-connect\uff1a\u76ee\u6807\u5df2\u8fde\u63a5", new Object[0]);
                return;
            }
            PeerSubMessageHandler peerSubMessageHandler = PeerSubMessageHandler.newInstance(peerSession, this.torrentSession);
            UtpClient client = UtpClient.newInstance(peerSession, peerSubMessageHandler);
            if (client.connect()) {
                LOGGER.debug("\u5904\u7406holepunch\u6d88\u606f-connect\uff1a\u8fde\u63a5\u6210\u529f", new Object[0]);
                peerSession.flags((byte)4);
                client.close();
            } else {
                LOGGER.debug("\u5904\u7406holepunch\u6d88\u606f-connect\uff1a\u8fde\u63a5\u5931\u8d25", new Object[0]);
            }
        }
    }

    private void error(String host, int port, PeerConfig.HolepunchErrorCode errorCode) {
        LOGGER.debug("\u53d1\u9001holepunch\u6d88\u606f-error\uff1a{} - {} - {}", new Object[]{host, port, errorCode});
        this.pushMessage(this.buildMessage(PeerConfig.HolepunchType.ERROR, host, port, errorCode));
    }

    private void onError(String host, int port, int errorCode) {
        LOGGER.warn("\u5904\u7406holepunch\u6d88\u606f-error\uff1a{} - {} - {}", host, port, errorCode);
    }

    private ByteBuffer buildMessage(PeerConfig.HolepunchType type, String host, int port) {
        return this.buildMessage(type, host, port, null);
    }

    private ByteBuffer buildMessage(PeerConfig.HolepunchType type, String host, int port, PeerConfig.HolepunchErrorCode errorCode) {
        ByteBuffer buffer;
        boolean ipv4 = NetUtils.ipv4(host);
        if (ipv4) {
            buffer = ByteBuffer.allocate(12);
            buffer.put(type.getId());
            buffer.put((byte)0);
            buffer.putInt(NetUtils.ipToInt(host));
        } else {
            buffer = ByteBuffer.allocate(24);
            buffer.put(type.getId());
            buffer.put((byte)1);
            buffer.put(NetUtils.ipToBytes(host));
        }
        buffer.putShort(NetUtils.portToShort(port));
        if (type == PeerConfig.HolepunchType.ERROR && errorCode != null) {
            buffer.putInt(errorCode.getCode());
        } else {
            buffer.putInt(0);
        }
        return buffer;
    }
}

