/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.peer.extension;

import com.acgist.snail.config.PeerConfig;
import com.acgist.snail.format.BEncodeDecoder;
import com.acgist.snail.format.BEncodeEncoder;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.NetException;
import com.acgist.snail.net.torrent.InfoHash;
import com.acgist.snail.net.torrent.TorrentSession;
import com.acgist.snail.net.torrent.peer.ExtensionMessageHandler;
import com.acgist.snail.net.torrent.peer.ExtensionTypeMessageHandler;
import com.acgist.snail.net.torrent.peer.PeerSession;
import com.acgist.snail.utils.DigestUtils;
import com.acgist.snail.utils.NumberUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MetadataMessageHandler
extends ExtensionTypeMessageHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataMessageHandler.class);
    public static final int SLICE_LENGTH = 16384;
    private static final String ARG_PIECE = "piece";
    private static final String ARG_MSG_TYPE = "msg_type";
    private static final String ARG_TOTAL_SIZE = "total_size";
    private final InfoHash infoHash;
    private final TorrentSession torrentSession;

    private MetadataMessageHandler(PeerSession peerSession, TorrentSession torrentSession, ExtensionMessageHandler extensionMessageHandler) {
        super(PeerConfig.ExtensionType.UT_METADATA, peerSession, extensionMessageHandler);
        this.infoHash = torrentSession.infoHash();
        this.torrentSession = torrentSession;
    }

    public static final MetadataMessageHandler newInstance(PeerSession peerSession, TorrentSession torrentSession, ExtensionMessageHandler extensionMessageHandler) {
        return new MetadataMessageHandler(peerSession, torrentSession, extensionMessageHandler);
    }

    @Override
    public void doMessage(ByteBuffer buffer) throws NetException {
        BEncodeDecoder decoder = BEncodeDecoder.newInstance(buffer).next();
        if (decoder.isEmpty()) {
            LOGGER.warn("\u5904\u7406metadata\u6d88\u606f\u9519\u8bef\uff08\u683c\u5f0f\uff09\uff1a{}", decoder);
            return;
        }
        Byte typeId = decoder.getByte(ARG_MSG_TYPE);
        PeerConfig.MetadataType metadataType = PeerConfig.MetadataType.of(typeId);
        if (metadataType == null) {
            LOGGER.warn("\u5904\u7406metadata\u6d88\u606f\u9519\u8bef\uff08\u672a\u77e5\u7c7b\u578b\uff09\uff1a{}", typeId);
            return;
        }
        LOGGER.debug("\u5904\u7406metadata\u6d88\u606f\uff1a{}", new Object[]{metadataType});
        switch (metadataType) {
            case REQUEST: {
                this.request(decoder);
                break;
            }
            case DATA: {
                this.data(decoder);
                break;
            }
            case REJECT: {
                this.reject(decoder);
                break;
            }
            default: {
                LOGGER.warn("\u5904\u7406metadata\u6d88\u606f\u9519\u8bef\uff08\u7c7b\u578b\u672a\u9002\u914d\uff09\uff1a{}", new Object[]{metadataType});
            }
        }
    }

    public void request() {
        LOGGER.debug("\u53d1\u9001metadata\u6d88\u606f-request", new Object[0]);
        int size = this.infoHash.getSize();
        int messageSize = NumberUtils.ceilDiv(size, 16384);
        for (int index = 0; index < messageSize; ++index) {
            Map<String, Object> request = this.buildMessage(PeerConfig.MetadataType.REQUEST, index);
            this.pushMessage(request);
        }
    }

    private void request(BEncodeDecoder decoder) {
        LOGGER.debug("\u5904\u7406metadata\u6d88\u606f-request", new Object[0]);
        int piece = decoder.getInteger(ARG_PIECE);
        this.data(piece);
    }

    public void data(int piece) {
        LOGGER.debug("\u53d1\u9001metadata\u6d88\u606f-data\uff1a{}", piece);
        byte[] bytes = this.infoHash.getInfo();
        if (bytes == null) {
            this.reject();
            return;
        }
        int pos = piece * 16384;
        if (pos > bytes.length) {
            this.reject();
            return;
        }
        int length = 16384;
        if (pos + 16384 > bytes.length) {
            length = bytes.length - pos;
        }
        byte[] x = new byte[length];
        System.arraycopy(bytes, pos, x, 0, length);
        Map<String, Object> data = this.buildMessage(PeerConfig.MetadataType.DATA, piece);
        data.put(ARG_TOTAL_SIZE, this.infoHash.getSize());
        this.pushMessage(data, x);
    }

    private void data(BEncodeDecoder decoder) {
        int piece;
        int pos;
        LOGGER.debug("\u5904\u7406metadata\u6d88\u606f-data", new Object[0]);
        byte[] bytes = this.infoHash.getInfo();
        if (bytes == null) {
            int totalSize = decoder.getInteger(ARG_TOTAL_SIZE);
            bytes = new byte[totalSize];
            this.infoHash.setInfo(bytes);
        }
        if ((pos = (piece = decoder.getInteger(ARG_PIECE).intValue()) * 16384) > bytes.length) {
            LOGGER.warn("\u5904\u7406metadata\u6d88\u606f-data\u5931\u8d25\uff08\u6570\u636e\u957f\u5ea6\u9519\u8bef\uff09\uff1a{}-{}", pos, bytes.length);
            return;
        }
        int length = 16384;
        if (pos + 16384 > bytes.length) {
            length = bytes.length - pos;
        }
        byte[] x = decoder.oddBytes();
        System.arraycopy(x, 0, bytes, pos, length);
        byte[] sourceHash = this.infoHash.getInfoHash();
        byte[] targetHash = DigestUtils.sha1(bytes);
        if (Arrays.equals(sourceHash, targetHash)) {
            this.torrentSession.saveTorrent();
        }
    }

    public void reject() {
        LOGGER.debug("\u53d1\u9001metadata\u6d88\u606f-reject", new Object[0]);
        Map<String, Object> reject = this.buildMessage(PeerConfig.MetadataType.REJECT, 0);
        this.pushMessage(reject);
    }

    private void reject(BEncodeDecoder decoder) {
        LOGGER.debug("\u5904\u7406metadata\u6d88\u606f-reject\uff1a{}", decoder);
    }

    private Map<String, Object> buildMessage(PeerConfig.MetadataType type, int piece) {
        LinkedHashMap<String, Object> message = new LinkedHashMap<String, Object>();
        message.put(ARG_MSG_TYPE, type.getId());
        message.put(ARG_PIECE, piece);
        return message;
    }

    private void pushMessage(Map<String, Object> data) {
        this.pushMessage(data, null);
    }

    private void pushMessage(Map<String, Object> data, byte[] x) {
        BEncodeEncoder encoder = BEncodeEncoder.newInstance();
        encoder.newMap().put(data).flush();
        if (x != null) {
            encoder.write(x);
        }
        byte[] bytes = encoder.bytes();
        this.pushMessage(bytes);
    }
}

