/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.peer.extension;

import com.acgist.snail.config.PeerConfig;
import com.acgist.snail.format.BEncodeDecoder;
import com.acgist.snail.format.BEncodeEncoder;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.NetException;
import com.acgist.snail.net.PacketSizeException;
import com.acgist.snail.net.torrent.TorrentSession;
import com.acgist.snail.net.torrent.peer.ExtensionMessageHandler;
import com.acgist.snail.net.torrent.peer.ExtensionTypeMessageHandler;
import com.acgist.snail.net.torrent.peer.PeerContext;
import com.acgist.snail.net.torrent.peer.PeerSession;
import com.acgist.snail.utils.CollectionUtils;
import com.acgist.snail.utils.MapUtils;
import com.acgist.snail.utils.NetUtils;
import com.acgist.snail.utils.PeerUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public final class PeerExchangeMessageHandler
extends ExtensionTypeMessageHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeerExchangeMessageHandler.class);
    private static final String ADDED = "added";
    private static final String ADDEDF = "added.f";
    private static final String DROPPED = "dropped";
    private static final String ADDED6 = "added6";
    private static final String ADDED6F = "added6.f";
    private static final String DROPPED6 = "dropped6";
    private final TorrentSession torrentSession;

    private PeerExchangeMessageHandler(PeerSession peerSession, TorrentSession torrentSession, ExtensionMessageHandler extensionMessageHandler) {
        super(PeerConfig.ExtensionType.UT_PEX, peerSession, extensionMessageHandler);
        this.torrentSession = torrentSession;
    }

    public static final PeerExchangeMessageHandler newInstance(PeerSession peerSession, TorrentSession torrentSession, ExtensionMessageHandler extensionMessageHandler) {
        return new PeerExchangeMessageHandler(peerSession, torrentSession, extensionMessageHandler);
    }

    @Override
    public void doMessage(ByteBuffer buffer) throws NetException {
        this.pex(buffer);
    }

    public void pex(byte[] bytes) {
        LOGGER.debug("\u53d1\u9001PEX\u6d88\u606f", new Object[0]);
        this.pushMessage(bytes);
    }

    private void pex(ByteBuffer buffer) throws PacketSizeException {
        LOGGER.debug("\u5904\u7406PEX\u6d88\u606f", new Object[0]);
        BEncodeDecoder decoder = BEncodeDecoder.newInstance(buffer).next();
        if (decoder.isEmpty()) {
            LOGGER.warn("\u5904\u7406PEX\u6d88\u606f\u9519\u8bef\uff08\u683c\u5f0f\uff09\uff1a{}", decoder);
            return;
        }
        byte[] added = decoder.getBytes(ADDED);
        byte[] addedf = decoder.getBytes(ADDEDF);
        Map<String, Integer> peersIPv4 = PeerUtils.readIPv4(added);
        this.readPeer(peersIPv4, addedf);
        byte[] added6 = decoder.getBytes(ADDED6);
        byte[] added6f = decoder.getBytes(ADDED6F);
        Map<String, Integer> peersIPv6 = PeerUtils.readIPv6(added6);
        this.readPeer(peersIPv6, added6f);
    }

    private void readPeer(Map<String, Integer> peers, byte[] flags) {
        if (MapUtils.isNotEmpty(peers)) {
            AtomicInteger index = new AtomicInteger(0);
            peers.forEach((host, port) -> {
                PeerSession peerSession = PeerContext.getInstance().newPeerSession(this.torrentSession.infoHashHex(), this.torrentSession.statistics(), (String)host, (Integer)port, PeerConfig.Source.PEX);
                if (flags != null && flags.length > index.get()) {
                    peerSession.flags(flags[index.getAndIncrement()]);
                }
                peerSession.pexSource(this.peerSession);
            });
        }
    }

    public static final byte[] buildMessage(List<PeerSession> optimize) {
        if (CollectionUtils.isEmpty(optimize)) {
            return new byte[0];
        }
        ArrayList optimizeIPv4 = new ArrayList();
        ArrayList optimizeIPv6 = new ArrayList();
        optimize.stream().distinct().forEach(session -> {
            if (NetUtils.ipv4(session.host())) {
                optimizeIPv4.add(session);
            } else {
                optimizeIPv6.add(session);
            }
        });
        ByteBuffer addedBuffer = ByteBuffer.allocate(6 * optimizeIPv4.size());
        ByteBuffer addedfBuffer = ByteBuffer.allocate(optimizeIPv4.size());
        optimizeIPv4.stream().forEach(session -> {
            addedBuffer.putInt(NetUtils.ipToInt(session.host()));
            addedBuffer.putShort(NetUtils.portToShort(session.port()));
            addedfBuffer.put(session.flags());
        });
        ByteBuffer added6Buffer = ByteBuffer.allocate(18 * optimizeIPv6.size());
        ByteBuffer added6fBuffer = ByteBuffer.allocate(optimizeIPv6.size());
        optimizeIPv6.stream().forEach(session -> {
            added6Buffer.put(NetUtils.ipToBytes(session.host()));
            added6Buffer.putShort(NetUtils.portToShort(session.port()));
            added6fBuffer.put(session.flags());
        });
        HashMap<String, byte[]> data = new HashMap<String, byte[]>(9);
        byte[] emptyBytes = new byte[]{};
        data.put(ADDED, addedBuffer.array());
        data.put(ADDEDF, addedfBuffer.array());
        data.put(DROPPED, emptyBytes);
        data.put(ADDED6, added6Buffer.array());
        data.put(ADDED6F, added6fBuffer.array());
        data.put(DROPPED6, emptyBytes);
        return BEncodeEncoder.encodeMap(data);
    }
}

