/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.tracker;

import com.acgist.snail.config.PeerConfig;
import com.acgist.snail.config.SystemConfig;
import com.acgist.snail.config.TrackerConfig;
import com.acgist.snail.format.BEncodeDecoder;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.NetException;
import com.acgist.snail.net.http.HttpClient;
import com.acgist.snail.net.torrent.TorrentSession;
import com.acgist.snail.net.torrent.tracker.AnnounceMessage;
import com.acgist.snail.net.torrent.tracker.ScrapeMessage;
import com.acgist.snail.net.torrent.tracker.TrackerContext;
import com.acgist.snail.net.torrent.tracker.TrackerSession;
import com.acgist.snail.protocol.Protocol;
import com.acgist.snail.utils.MapUtils;
import com.acgist.snail.utils.PeerUtils;
import com.acgist.snail.utils.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class HttpTrackerSession
extends TrackerSession {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpTrackerSession.class);
    private static final String SCRAPE_URL_SUFFIX = "/scrape";
    private static final String ANNOUNCE_URL_SUFFIX = "/announce";
    public static final String IP_ADDRESS = "0";
    public static final String IP_COMPACT = "1";
    private String trackerId;

    private HttpTrackerSession(String scrapeUrl, String announceUrl) throws NetException {
        super(scrapeUrl, announceUrl, Protocol.Type.HTTP);
    }

    public static final HttpTrackerSession newInstance(String announceUrl) throws NetException {
        String scrapeUrl = HttpTrackerSession.buildScrapeUrl(announceUrl);
        return new HttpTrackerSession(scrapeUrl, announceUrl);
    }

    @Override
    public void started(Integer sid, TorrentSession torrentSession) throws NetException {
        String announceMessage = (String)this.buildAnnounceMessage(sid, torrentSession, TrackerConfig.Event.STARTED);
        HttpClient client = HttpClient.newInstance(announceMessage).get();
        if (!client.ok()) {
            throw new NetException("HTTP Tracker\u58f0\u660e\u5931\u8d25");
        }
        byte[] body = client.responseToBytes();
        BEncodeDecoder decoder = BEncodeDecoder.newInstance(body).next();
        if (decoder.isEmpty()) {
            throw new NetException("HTTP Tracker\u58f0\u660e\u6d88\u606f\u9519\u8bef\uff08\u683c\u5f0f\uff09\uff1a" + new String(body));
        }
        AnnounceMessage message = HttpTrackerSession.convertAnnounceMessage(sid, decoder);
        this.trackerId = message.trackerId();
        TrackerContext.getInstance().announce(message);
    }

    @Override
    public void completed(Integer sid, TorrentSession torrentSession) throws NetException {
        HttpClient.newInstance((String)this.buildAnnounceMessage(sid, torrentSession, TrackerConfig.Event.COMPLETED)).get();
    }

    @Override
    public void stopped(Integer sid, TorrentSession torrentSession) throws NetException {
        HttpClient.newInstance((String)this.buildAnnounceMessage(sid, torrentSession, TrackerConfig.Event.STOPPED)).get();
    }

    @Override
    public void scrape(Integer sid, TorrentSession torrentSession) throws NetException {
        String scrapeMessage = this.buildScrapeMessage(sid, torrentSession);
        if (scrapeMessage == null) {
            throw new NetException("HTTP Tracker\u522e\u64e6\u5931\u8d25\uff1a" + this.scrapeUrl);
        }
        HttpClient client = HttpClient.newInstance(scrapeMessage).get();
        if (!client.ok()) {
            throw new NetException("HTTP Tracker\u522e\u64e6\u5931\u8d25");
        }
        byte[] body = client.responseToBytes();
        BEncodeDecoder decoder = BEncodeDecoder.newInstance(body).next();
        if (decoder.isEmpty()) {
            throw new NetException("HTTP Tracker\u522e\u64e6\u6d88\u606f\u9519\u8bef\uff08\u683c\u5f0f\uff09\uff1a" + new String(body));
        }
        List<ScrapeMessage> messages = HttpTrackerSession.convertScrapeMessage(sid, decoder);
        messages.forEach(TrackerContext.getInstance()::scrape);
    }

    @Override
    protected String buildAnnounceMessageEx(Integer sid, TorrentSession torrentSession, TrackerConfig.Event event, long upload, long download, long left) {
        StringBuilder builder = new StringBuilder(this.announceUrl);
        builder.append("?").append("info_hash").append("=").append(torrentSession.infoHash().getInfoHashUrl()).append("&").append("peer_id").append("=").append(PeerConfig.getInstance().getPeerIdUrl()).append("&").append("port").append("=").append(SystemConfig.getTorrentPortExtShort()).append("&").append("uploaded").append("=").append(upload).append("&").append("downloaded").append("=").append(download).append("&").append("left").append("=").append(left).append("&").append("compact").append("=").append(IP_COMPACT).append("&").append("event").append("=").append(event.getValue()).append("&").append("numwant").append("=").append(50);
        if (StringUtils.isNotEmpty(this.trackerId)) {
            builder.append("&").append("trackerid").append("=").append(this.trackerId);
        }
        return builder.toString();
    }

    private String buildScrapeMessage(Integer sid, TorrentSession torrentSession) {
        if (StringUtils.isEmpty(this.scrapeUrl)) {
            return null;
        }
        StringBuilder builder = new StringBuilder(this.scrapeUrl);
        builder.append("?").append("info_hash").append("=").append(torrentSession.infoHash().getInfoHashUrl());
        return builder.toString();
    }

    private static final AnnounceMessage convertAnnounceMessage(Integer sid, BEncodeDecoder decoder) {
        String warngingMessage;
        String failureReason = decoder.getString("failure reason");
        if (StringUtils.isNotEmpty(failureReason)) {
            LOGGER.warn("HTTP Tracker\u58f0\u660e\u5931\u8d25\uff1a{}", failureReason);
        }
        if (StringUtils.isNotEmpty(warngingMessage = decoder.getString("warnging message"))) {
            LOGGER.warn("HTTP Tracker\u58f0\u660e\u8b66\u544a\uff1a{}", warngingMessage);
        }
        HashMap<String, Integer> peers = new HashMap<String, Integer>();
        Map<String, Integer> peersIPv4 = PeerUtils.readIPv4(decoder.get("peers"));
        Map<String, Integer> peersIPv6 = PeerUtils.readIPv6(decoder.get("peers6"));
        peers.putAll(peersIPv4);
        peers.putAll(peersIPv6);
        return AnnounceMessage.newHttp(sid, decoder.getString("tracker id"), decoder.getInteger("interval"), decoder.getInteger("min interval"), decoder.getInteger("incomplete"), decoder.getInteger("complete"), peers);
    }

    private static final List<ScrapeMessage> convertScrapeMessage(Integer sid, BEncodeDecoder decoder) {
        Map<String, Object> files = decoder.getMap("files");
        if (files == null) {
            return List.of();
        }
        return files.entrySet().stream().map(entry -> {
            Map map = (Map)entry.getValue();
            return ScrapeMessage.newInstance(sid, MapUtils.getInteger(map, "complete"), MapUtils.getInteger(map, "downloaded"), MapUtils.getInteger(map, "incomplete"));
        }).collect(Collectors.toList());
    }

    private static final String buildScrapeUrl(String url) {
        if (url != null && url.contains(ANNOUNCE_URL_SUFFIX)) {
            return url.replace(ANNOUNCE_URL_SUFFIX, SCRAPE_URL_SUFFIX);
        }
        return null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.announceUrl);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof HttpTrackerSession) {
            HttpTrackerSession session = (HttpTrackerSession)object;
            return StringUtils.equals(this.announceUrl, session.announceUrl);
        }
        return false;
    }
}

