/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.tracker;

import com.acgist.snail.config.SystemConfig;
import com.acgist.snail.config.TrackerConfig;
import com.acgist.snail.context.IContext;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.NetException;
import com.acgist.snail.net.torrent.TorrentSession;
import com.acgist.snail.net.torrent.tracker.AnnounceMessage;
import com.acgist.snail.net.torrent.tracker.HttpTrackerSession;
import com.acgist.snail.net.torrent.tracker.ScrapeMessage;
import com.acgist.snail.net.torrent.tracker.TrackerLauncher;
import com.acgist.snail.net.torrent.tracker.TrackerSession;
import com.acgist.snail.net.torrent.tracker.UdpTrackerSession;
import com.acgist.snail.protocol.Protocol;
import com.acgist.snail.utils.CollectionUtils;
import com.acgist.snail.utils.StringUtils;
import com.acgist.snail.utils.UrlUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public final class TrackerContext
implements IContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrackerContext.class);
    private static final TrackerContext INSTANCE = new TrackerContext();
    private final Map<Integer, TrackerSession> trackerSessions = new ConcurrentHashMap<Integer, TrackerSession>();
    private final Map<Integer, TrackerLauncher> trackerLaunchers = new ConcurrentHashMap<Integer, TrackerLauncher>();

    public static final TrackerContext getInstance() {
        return INSTANCE;
    }

    private TrackerContext() {
        this.register();
    }

    public TrackerLauncher buildTrackerLauncher(TrackerSession trackerSession, TorrentSession torrentSession) {
        TrackerLauncher launcher = TrackerLauncher.newInstance(trackerSession, torrentSession);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u52a0\u8f7dTrackerLauncher\uff1a{}-{}-{}", launcher.id(), trackerSession.id(), trackerSession.announceUrl());
        }
        this.trackerLaunchers.put(launcher.id(), launcher);
        return launcher;
    }

    public void removeTrackerLauncher(Integer id) {
        LOGGER.debug("\u5220\u9664TrackerLauncher\uff1a{}", id);
        this.trackerLaunchers.remove(id);
    }

    public void announce(AnnounceMessage message) {
        if (message == null) {
            return;
        }
        Integer id = message.id();
        TrackerLauncher trackerLauncher = this.trackerLaunchers.get(id);
        if (trackerLauncher != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u6536\u5230\u58f0\u660e\u54cd\u5e94\u6d88\u606f\uff1a{}\n\u505a\u79cdPeer\u6570\u91cf\uff1a{}\n\u4e0b\u8f7dPeer\u6570\u91cf\uff1a{}\n\u4e0b\u6b21\u8bf7\u6c42\u7b49\u5f85\u65f6\u95f4\uff1a{}", trackerLauncher.announceUrl(), message.seeder(), message.leecher(), message.interval());
            }
            trackerLauncher.announce(message);
        } else {
            LOGGER.debug("TrackerLauncher\u6ca1\u6709\u6ce8\u518c\uff08\u58f0\u660e\u6d88\u606f\uff09\uff1a{}", message);
        }
    }

    public void scrape(ScrapeMessage message) {
        if (message == null) {
            return;
        }
        Integer id = message.id();
        TrackerLauncher trackerLauncher = this.trackerLaunchers.get(id);
        if (trackerLauncher != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u6536\u5230\u522e\u64e6\u54cd\u5e94\u6d88\u606f\uff1a{}\n\u505a\u79cdPeer\u6570\u91cf\uff1a{}\n\u4e0b\u8f7dPeer\u6570\u91cf\uff1a{}\n\u5b8c\u6210Peer\u6570\u91cf\uff1a{}", trackerLauncher.announceUrl(), message.seeder(), message.leecher(), message.completed());
            }
        } else {
            LOGGER.debug("TrackerLauncher\u6ca1\u6709\u6ce8\u518c\uff08\u522e\u64e6\u6d88\u606f\uff09\uff1a{}", message);
        }
    }

    public void connectionId(int trackerId, long connectionId) {
        TrackerSession trackerSession = this.trackerSessions.get(trackerId);
        if (trackerSession instanceof UdpTrackerSession) {
            UdpTrackerSession udpTrackerSession = (UdpTrackerSession)trackerSession;
            udpTrackerSession.connectionId(connectionId);
        }
    }

    public List<TrackerSession> sessions() {
        return new ArrayList<TrackerSession>(this.trackerSessions.values());
    }

    public List<TrackerSession> sessions(String announceUrl) {
        return this.sessions(announceUrl, null);
    }

    public List<TrackerSession> sessions(List<String> announceUrls) {
        return this.sessions(null, announceUrls);
    }

    public List<TrackerSession> sessions(String announceUrl, List<String> announceUrls) {
        return this.sessions(announceUrl, announceUrls, false);
    }

    public List<TrackerSession> sessions(String announceUrl, List<String> announceUrls, boolean privateTorrent) {
        List<TrackerSession> subjoin;
        int maxSize;
        List<TrackerSession> sessions = this.buildTrackerSession(announceUrl, announceUrls);
        if (privateTorrent) {
            LOGGER.debug("\u79c1\u6709\u79cd\u5b50\uff1a\u7981\u6b62\u8865\u5145Tracker", new Object[0]);
            return sessions;
        }
        int size = sessions.size();
        if (size < (maxSize = SystemConfig.getTrackerSize()) && CollectionUtils.isNotEmpty(subjoin = this.sessions(maxSize - size, sessions))) {
            sessions.addAll(subjoin);
        }
        return sessions;
    }

    private List<TrackerSession> sessions(int size, List<TrackerSession> sessions) {
        return this.trackerSessions.values().stream().filter(client -> client.available() && !sessions.contains(client)).sorted().limit(size).collect(Collectors.toList());
    }

    private void register() {
        this.buildTrackerSession(TrackerConfig.getInstance().getAnnounces());
    }

    private List<TrackerSession> buildTrackerSession(String announceUrl, List<String> announceUrls) {
        ArrayList<String> announces = new ArrayList<String>();
        if (StringUtils.isNotEmpty(announceUrl)) {
            announces.add(announceUrl);
        }
        if (CollectionUtils.isNotEmpty(announceUrls)) {
            announces.addAll(announceUrls);
        }
        return this.buildTrackerSession(announces);
    }

    private List<TrackerSession> buildTrackerSession(List<String> announceUrls) {
        if (announceUrls == null) {
            announceUrls = new ArrayList<String>();
        }
        return announceUrls.stream().map(announceUrl -> this.buildTrackerSession(announceUrl.strip())).filter(Objects::nonNull).filter(TrackerSession::available).collect(Collectors.toList());
    }

    private TrackerSession buildTrackerSession(String announceUrl) {
        if (StringUtils.isEmpty(announceUrl)) {
            return null;
        }
        Optional<TrackerSession> optional = this.trackerSessions.values().stream().filter(client -> client.equalsAnnounceUrl(announceUrl)).findFirst();
        if (optional.isPresent()) {
            return optional.get();
        }
        try {
            TrackerSession session = this.buildTrackerSessionProxy(announceUrl);
            this.trackerSessions.put(session.id(), session);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u6ce8\u518cTrackerSession\uff1a{}-{}", session.id(), session.announceUrl());
            }
            return session;
        }
        catch (NetException e) {
            LOGGER.error("\u6ce8\u518cTrackerSession\u5f02\u5e38\uff1a{}", announceUrl, e);
        }
        catch (Exception e) {
            LOGGER.error("\u6ce8\u518cTrackerSession\u5f02\u5e38\uff1a{}", announceUrl, e);
        }
        return null;
    }

    private TrackerSession buildTrackerSessionProxy(String announceUrl) throws NetException {
        TrackerSession session = this.buildTrackerSessionProtocol(announceUrl);
        if (session == null) {
            session = this.buildTrackerSessionProtocol(UrlUtils.decode(announceUrl));
        }
        if (session == null) {
            throw new NetException("\u672a\u77e5Tracker\u534f\u8bae\uff1a" + announceUrl);
        }
        return session;
    }

    private TrackerSession buildTrackerSessionProtocol(String announceUrl) throws NetException {
        if (Protocol.Type.HTTP.verify(announceUrl)) {
            return HttpTrackerSession.newInstance(announceUrl);
        }
        if (Protocol.Type.UDP.verify(announceUrl)) {
            return UdpTrackerSession.newInstance(announceUrl);
        }
        return null;
    }
}

