/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.tracker;

import com.acgist.snail.config.PeerConfig;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.torrent.TorrentSession;
import com.acgist.snail.net.torrent.peer.PeerContext;
import com.acgist.snail.net.torrent.tracker.AnnounceMessage;
import com.acgist.snail.net.torrent.tracker.TrackerContext;
import com.acgist.snail.net.torrent.tracker.TrackerSession;
import com.acgist.snail.utils.MapUtils;
import com.acgist.snail.utils.NumberUtils;
import java.util.Map;

public final class TrackerLauncher {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrackerLauncher.class);
    private final Integer id = NumberUtils.build();
    private boolean available = true;
    private boolean needRelease = false;
    private final TrackerSession session;
    private final TorrentSession torrentSession;

    private TrackerLauncher(TrackerSession session, TorrentSession torrentSession) {
        this.session = session;
        this.torrentSession = torrentSession;
    }

    public static final TrackerLauncher newInstance(TrackerSession session, TorrentSession torrentSession) {
        return new TrackerLauncher(session, torrentSession);
    }

    public Integer id() {
        return this.id;
    }

    public String announceUrl() {
        return this.session.announceUrl();
    }

    public void findPeer() {
        if (this.available()) {
            LOGGER.debug("TrackerLauncher\u67e5\u627ePeer\uff1a{}", this.session);
            this.needRelease = true;
            this.session.findPeers(this.id, this.torrentSession);
        }
    }

    public void announce(AnnounceMessage message) {
        if (message == null) {
            return;
        }
        if (this.available()) {
            this.peer(message.peers());
        } else {
            LOGGER.debug("\u6536\u5230\u58f0\u660e\u54cd\u5e94\u6d88\u606f\uff08TrackerLauncher\u65e0\u6548\uff09\uff1a{}", this.session);
        }
    }

    private void peer(Map<String, Integer> peers) {
        if (MapUtils.isEmpty(peers)) {
            return;
        }
        PeerContext peerContext = PeerContext.getInstance();
        peers.forEach((host, port) -> peerContext.newPeerSession(this.torrentSession.infoHashHex(), this.torrentSession.statistics(), (String)host, (Integer)port, PeerConfig.Source.TRACKER));
    }

    public void release() {
        if (this.needRelease && this.available()) {
            this.needRelease = false;
            try {
                if (this.torrentSession.completed()) {
                    LOGGER.debug("TrackerLauncher\u5b8c\u6210\u901a\u77e5\uff1a{}", this.session);
                    this.session.completed(this.id, this.torrentSession);
                } else {
                    LOGGER.debug("TrackerLauncher\u6682\u505c\u901a\u77e5\uff1a{}", this.session);
                    this.session.stopped(this.id, this.torrentSession);
                }
            }
            catch (Exception e) {
                LOGGER.error("TrackerLauncher\u5173\u95ed\u5f02\u5e38", e);
            }
            finally {
                TrackerContext.getInstance().removeTrackerLauncher(this.id);
            }
        }
        this.available = false;
    }

    private boolean available() {
        return this.available && this.session.available();
    }
}

