/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.tracker;

import com.acgist.snail.config.PeerConfig;
import com.acgist.snail.context.SystemThreadContext;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.torrent.Magnet;
import com.acgist.snail.net.torrent.Torrent;
import com.acgist.snail.net.torrent.TorrentSession;
import com.acgist.snail.net.torrent.tracker.TrackerContext;
import com.acgist.snail.net.torrent.tracker.TrackerLauncher;
import com.acgist.snail.net.torrent.tracker.TrackerSession;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public final class TrackerLauncherGroup {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrackerLauncherGroup.class);
    private final TorrentSession torrentSession;
    private final List<TrackerLauncher> trackerLaunchers;

    private TrackerLauncherGroup(TorrentSession torrentSession) {
        this.torrentSession = torrentSession;
        this.trackerLaunchers = new ArrayList<TrackerLauncher>();
    }

    public static final TrackerLauncherGroup newInstance(TorrentSession torrentSession) {
        return new TrackerLauncherGroup(torrentSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> trackers() {
        List<TrackerLauncher> list = this.trackerLaunchers;
        synchronized (list) {
            return this.trackerLaunchers.stream().map(TrackerLauncher::announceUrl).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTracker() {
        List<TrackerSession> sessions = null;
        PeerConfig.Action action = this.torrentSession.action();
        TrackerContext context = TrackerContext.getInstance();
        if (action == PeerConfig.Action.TORRENT) {
            Torrent torrent = this.torrentSession.torrent();
            sessions = context.sessions(torrent.getAnnounce(), torrent.getAnnounceList(), this.torrentSession.privateTorrent());
        } else if (action == PeerConfig.Action.MAGNET) {
            Magnet magnet = this.torrentSession.magnet();
            sessions = context.sessions(magnet.getTr());
        } else {
            sessions = context.sessions();
        }
        List list = sessions.stream().map(client -> context.buildTrackerLauncher((TrackerSession)client, this.torrentSession)).collect(Collectors.toList());
        List<TrackerLauncher> list2 = this.trackerLaunchers;
        synchronized (list2) {
            this.trackerLaunchers.addAll(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findPeer() {
        ArrayList<TrackerLauncher> list;
        LOGGER.debug("Tracker\u67e5\u627ePeer\uff1a{}", this.torrentSession);
        List<TrackerLauncher> list2 = this.trackerLaunchers;
        synchronized (list2) {
            list = new ArrayList<TrackerLauncher>(this.trackerLaunchers);
        }
        list.forEach(TrackerLauncher::findPeer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        LOGGER.debug("\u91ca\u653eTrackerLauncherGroup\uff1a{}", this.torrentSession);
        List<TrackerLauncher> list = this.trackerLaunchers;
        synchronized (list) {
            this.trackerLaunchers.forEach(launcher -> SystemThreadContext.submit(launcher::release));
            this.trackerLaunchers.clear();
        }
    }
}

