/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.tracker;

import com.acgist.snail.config.SystemConfig;
import com.acgist.snail.config.TrackerConfig;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.UdpMessageHandler;
import com.acgist.snail.net.torrent.tracker.AnnounceMessage;
import com.acgist.snail.net.torrent.tracker.ScrapeMessage;
import com.acgist.snail.net.torrent.tracker.TrackerContext;
import com.acgist.snail.utils.ByteUtils;
import com.acgist.snail.utils.PeerUtils;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;

public final class TrackerMessageHandler
extends UdpMessageHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrackerMessageHandler.class);
    private static final int CONNECT_MIN_LENGTH = 12;
    private static final int ANNOUNCE_MIN_LENGTH = 16;
    private static final int SCRAPE_MIN_LENGTH = 16;

    public TrackerMessageHandler() {
        this(null);
    }

    public TrackerMessageHandler(InetSocketAddress socketAddress) {
        super(socketAddress);
    }

    @Override
    public void onReceive(ByteBuffer buffer, InetSocketAddress socketAddress) {
        int remaining = buffer.remaining();
        if (remaining < 4) {
            LOGGER.warn("\u5904\u7406UDP Tracker\u6d88\u606f\u9519\u8bef\uff08\u957f\u5ea6\uff09\uff1a{}", remaining);
            return;
        }
        int id = buffer.getInt();
        TrackerConfig.Action action = TrackerConfig.Action.of(id);
        if (action == null) {
            LOGGER.warn("\u5904\u7406UDP Tracker\u6d88\u606f\u9519\u8bef\uff08\u672a\u77e5\u52a8\u4f5c\uff09\uff1a{}", id);
            return;
        }
        switch (action) {
            case CONNECT: {
                this.doConnect(buffer);
                break;
            }
            case ANNOUNCE: {
                this.doAnnounce(buffer);
                break;
            }
            case SCRAPE: {
                this.doScrape(buffer);
                break;
            }
            case ERROR: {
                this.doError(buffer);
                break;
            }
            default: {
                LOGGER.debug("\u5904\u7406UDP Tracker\u6d88\u606f\u9519\u8bef\uff08\u52a8\u4f5c\u672a\u9002\u914d\uff09\uff1a{}", new Object[]{action});
            }
        }
    }

    private void doConnect(ByteBuffer buffer) {
        int remaining = buffer.remaining();
        if (remaining < 12) {
            LOGGER.debug("\u5904\u7406UDP Tracker\u8fde\u63a5\u6d88\u606f\u9519\u8bef\uff08\u957f\u5ea6\uff09\uff1a{}", remaining);
            return;
        }
        int trackerId = buffer.getInt();
        long connectionId = buffer.getLong();
        TrackerContext.getInstance().connectionId(trackerId, connectionId);
    }

    private void doAnnounce(ByteBuffer buffer) {
        int remaining = buffer.remaining();
        if (remaining < 16) {
            LOGGER.debug("\u5904\u7406UDP Tracker\u58f0\u660e\u6d88\u606f\u9519\u8bef\uff08\u957f\u5ea6\uff09\uff1a{}", remaining);
            return;
        }
        AnnounceMessage message = AnnounceMessage.newUdp(buffer.getInt(), buffer.getInt(), buffer.getInt(), buffer.getInt(), SystemConfig.getExternalIPAddressIPv4() ? PeerUtils.readIPv4(buffer) : PeerUtils.readIPv6(buffer));
        TrackerContext.getInstance().announce(message);
    }

    private void doScrape(ByteBuffer buffer) {
        int remaining = buffer.remaining();
        if (remaining < 16) {
            LOGGER.debug("\u5904\u7406UDP Tracker\u522e\u64e6\u6d88\u606f\u9519\u8bef\uff08\u957f\u5ea6\uff09\uff1a{}", remaining);
            return;
        }
        ScrapeMessage message = ScrapeMessage.newInstance(buffer.getInt(), buffer.getInt(), buffer.getInt(), buffer.getInt());
        TrackerContext.getInstance().scrape(message);
    }

    private void doError(ByteBuffer buffer) {
        int remaining = buffer.remaining();
        if (remaining < 4) {
            LOGGER.debug("\u5904\u7406UDP Tracker\u9519\u8bef\u6d88\u606f\u9519\u8bef\uff08\u957f\u5ea6\uff09\uff1a{}", remaining);
            return;
        }
        int trackerId = buffer.getInt();
        String message = ByteUtils.remainingToString(buffer);
        LOGGER.warn("UDP Tracker\u9519\u8bef\u6d88\u606f\uff1a{}-{}", trackerId, message);
    }
}

