/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.tracker;

import com.acgist.snail.config.TrackerConfig;
import com.acgist.snail.context.IStatisticsSession;
import com.acgist.snail.context.ITaskSession;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.NetException;
import com.acgist.snail.net.torrent.TorrentSession;
import com.acgist.snail.protocol.Protocol;
import com.acgist.snail.utils.BeanUtils;
import com.acgist.snail.utils.NumberUtils;
import com.acgist.snail.utils.StringUtils;
import java.util.Objects;

public abstract class TrackerSession
implements Comparable<TrackerSession> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrackerSession.class);
    protected static final int WANT_PEER_SIZE = 50;
    protected final Integer id;
    protected final Protocol.Type type;
    protected final String scrapeUrl;
    protected final String announceUrl;
    protected int weight;
    protected int failTimes = 0;
    protected boolean available = true;

    protected TrackerSession(String scrapeUrl, String announceUrl, Protocol.Type type) throws NetException {
        if (StringUtils.isEmpty(announceUrl)) {
            throw new NetException("Tracker\u58f0\u660e\u5730\u5740\u9519\u8bef\uff1a" + announceUrl);
        }
        this.id = NumberUtils.build();
        this.type = type;
        this.weight = 0;
        this.scrapeUrl = scrapeUrl;
        this.announceUrl = announceUrl;
    }

    public void findPeers(Integer sid, TorrentSession torrentSession) {
        if (!this.available()) {
            return;
        }
        try {
            this.started(sid, torrentSession);
            ++this.weight;
            this.failTimes = 0;
        }
        catch (Exception e) {
            --this.weight;
            ++this.failTimes;
            if (this.failTimes >= 3) {
                this.available = false;
                LOGGER.error("Tracker\u505c\u7528\uff0c\u5931\u8d25\u6b21\u6570\uff1a{}\uff0c\u58f0\u660e\u5730\u5740\uff1a{}", this.failTimes, this.announceUrl, e);
            }
            LOGGER.debug("\u67e5\u627ePeer\u5f02\u5e38\uff0c\u5931\u8d25\u6b21\u6570\uff1a{}\uff0c\u58f0\u660e\u5730\u5740\uff1a{}", this.failTimes, this.announceUrl, e);
        }
    }

    public abstract void started(Integer var1, TorrentSession var2) throws NetException;

    public abstract void completed(Integer var1, TorrentSession var2) throws NetException;

    public abstract void stopped(Integer var1, TorrentSession var2) throws NetException;

    public abstract void scrape(Integer var1, TorrentSession var2) throws NetException;

    protected Object buildAnnounceMessage(Integer sid, TorrentSession torrentSession, TrackerConfig.Event event) {
        long left = 0L;
        long upload = 0L;
        long download = 0L;
        ITaskSession taskSession = torrentSession.taskSession();
        if (taskSession != null) {
            IStatisticsSession statistics = taskSession.getStatistics();
            upload = statistics.getUploadSize();
            download = statistics.getDownloadSize();
            left = taskSession.getSize() - download;
        }
        return this.buildAnnounceMessageEx(sid, torrentSession, event, upload, download, left);
    }

    protected abstract Object buildAnnounceMessageEx(Integer var1, TorrentSession var2, TrackerConfig.Event var3, long var4, long var6, long var8);

    public Integer id() {
        return this.id;
    }

    public Protocol.Type type() {
        return this.type;
    }

    public String scrapeUrl() {
        return this.scrapeUrl;
    }

    public String announceUrl() {
        return this.announceUrl;
    }

    public boolean available() {
        return this.available;
    }

    public boolean equalsAnnounceUrl(String announceUrl) {
        return this.announceUrl.equals(announceUrl);
    }

    @Override
    public int compareTo(TrackerSession session) {
        return Integer.compare(this.weight, session.weight);
    }

    public int hashCode() {
        return Objects.hash(this.announceUrl);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof TrackerSession) {
            TrackerSession session = (TrackerSession)object;
            return StringUtils.equals(this.announceUrl, session.announceUrl);
        }
        return false;
    }

    public String toString() {
        return BeanUtils.toString(this, new Object[]{this.id, this.type, this.scrapeUrl, this.announceUrl});
    }
}

