/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.tracker;

import com.acgist.snail.config.PeerConfig;
import com.acgist.snail.config.SystemConfig;
import com.acgist.snail.config.TrackerConfig;
import com.acgist.snail.context.wrapper.URIWrapper;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.NetException;
import com.acgist.snail.net.torrent.TorrentSession;
import com.acgist.snail.net.torrent.tracker.TrackerClient;
import com.acgist.snail.net.torrent.tracker.TrackerSession;
import com.acgist.snail.protocol.Protocol;
import com.acgist.snail.utils.NetUtils;
import com.acgist.snail.utils.NumberUtils;
import com.acgist.snail.utils.StringUtils;
import java.nio.ByteBuffer;
import java.util.Objects;

public final class UdpTrackerSession
extends TrackerSession {
    private static final Logger LOGGER = LoggerFactory.getLogger(UdpTrackerSession.class);
    private static final long PROTOCOL_ID = 4497486125440L;
    private static final int DEFAULT_PORT = 80;
    private final String host;
    private final int port;
    private Long connectionId;
    private final TrackerClient trackerClient;

    private UdpTrackerSession(String scrapeUrl, String announceUrl) throws NetException {
        super(scrapeUrl, announceUrl, Protocol.Type.UDP);
        URIWrapper wrapper = URIWrapper.newInstance(announceUrl, 80).decode();
        this.host = wrapper.getHost();
        this.port = wrapper.getPort();
        this.trackerClient = TrackerClient.newInstance(NetUtils.buildSocketAddress(this.host, this.port));
    }

    public static final UdpTrackerSession newInstance(String announceUrl) throws NetException {
        return new UdpTrackerSession(announceUrl, announceUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void started(Integer sid, TorrentSession torrentSession) throws NetException {
        if (this.connectionId == null) {
            UdpTrackerSession udpTrackerSession = this;
            synchronized (udpTrackerSession) {
                if (this.connectionId == null) {
                    this.send(this.buildConnectionMessage());
                    try {
                        this.wait(5000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        LOGGER.debug("\u7ebf\u7a0b\u7b49\u5f85\u5f02\u5e38", e);
                    }
                }
            }
        }
        if (this.connectionId == null) {
            throw new NetException("UDP Tracker\u58f0\u660e\u5931\u8d25\uff08connectionId\uff09");
        }
        this.send((ByteBuffer)this.buildAnnounceMessage(sid, torrentSession, TrackerConfig.Event.STARTED));
    }

    @Override
    public void completed(Integer sid, TorrentSession torrentSession) throws NetException {
        if (this.connectionId != null) {
            this.send((ByteBuffer)this.buildAnnounceMessage(sid, torrentSession, TrackerConfig.Event.COMPLETED));
        }
    }

    @Override
    public void stopped(Integer sid, TorrentSession torrentSession) throws NetException {
        if (this.connectionId != null) {
            this.send((ByteBuffer)this.buildAnnounceMessage(sid, torrentSession, TrackerConfig.Event.STOPPED));
        }
    }

    @Override
    public void scrape(Integer sid, TorrentSession torrentSession) throws NetException {
        if (this.connectionId != null) {
            this.send(this.buildScrapeMessage(sid, torrentSession));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionId(Long connectionId) {
        this.connectionId = connectionId;
        UdpTrackerSession udpTrackerSession = this;
        synchronized (udpTrackerSession) {
            this.notifyAll();
        }
    }

    private void send(ByteBuffer buffer) throws NetException {
        this.trackerClient.send(buffer);
    }

    private ByteBuffer buildConnectionMessage() {
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.putLong(4497486125440L);
        buffer.putInt(TrackerConfig.Action.CONNECT.getId());
        buffer.putInt(this.id);
        return buffer;
    }

    @Override
    protected ByteBuffer buildAnnounceMessageEx(Integer sid, TorrentSession torrentSession, TrackerConfig.Event event, long upload, long download, long left) {
        ByteBuffer buffer = ByteBuffer.allocate(98);
        buffer.putLong(this.connectionId);
        buffer.putInt(TrackerConfig.Action.ANNOUNCE.getId());
        buffer.putInt(sid);
        buffer.put(torrentSession.infoHash().getInfoHash());
        buffer.put(PeerConfig.getInstance().getPeerId());
        buffer.putLong(download);
        buffer.putLong(left);
        buffer.putLong(upload);
        buffer.putInt(event.getId());
        buffer.putInt(0);
        buffer.putInt(NumberUtils.build());
        buffer.putInt(50);
        buffer.putShort(SystemConfig.getTorrentPortExtShort());
        return buffer;
    }

    private ByteBuffer buildScrapeMessage(Integer sid, TorrentSession torrentSession) {
        ByteBuffer buffer = ByteBuffer.allocate(36);
        buffer.putLong(this.connectionId);
        buffer.putInt(TrackerConfig.Action.SCRAPE.getId());
        buffer.putInt(sid);
        buffer.put(torrentSession.infoHash().getInfoHash());
        return buffer;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.announceUrl);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof UdpTrackerSession) {
            UdpTrackerSession session = (UdpTrackerSession)object;
            return StringUtils.equals(this.announceUrl, session.announceUrl);
        }
        return false;
    }
}

