/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.utp;

import com.acgist.snail.context.IContext;
import com.acgist.snail.context.SystemThreadContext;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.IChannelHandler;
import com.acgist.snail.net.MessageHandlerContext;
import com.acgist.snail.net.UdpMessageHandler;
import com.acgist.snail.net.torrent.utp.UtpMessageHandler;
import com.acgist.snail.net.torrent.utp.UtpRequestQueue;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public final class UtpContext
implements IContext,
IChannelHandler<DatagramChannel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UtpContext.class);
    private static final UtpContext INSTANCE = new UtpContext();
    private static final int UTP_TIMEOUT_INTERVAL = 10;
    private short connectionId = (short)System.currentTimeMillis();
    private DatagramChannel channel;
    private final MessageHandlerContext context = MessageHandlerContext.getInstance();
    private final Map<String, UtpMessageHandler> utpMessageHandlers = new ConcurrentHashMap<String, UtpMessageHandler>();

    public static final UtpContext getInstance() {
        return INSTANCE;
    }

    private UtpContext() {
        SystemThreadContext.scheduledAtFixedDelay(10L, 10L, TimeUnit.SECONDS, this::timeout);
    }

    @Override
    public void handle(DatagramChannel channel) {
        this.channel = channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short connectionId() {
        UtpContext utpContext = this;
        synchronized (utpContext) {
            short s = this.connectionId;
            this.connectionId = (short)(s + 1);
            return s;
        }
    }

    public UdpMessageHandler get(short connectionId, InetSocketAddress socketAddress) {
        String key = this.buildKey(connectionId, socketAddress);
        UtpMessageHandler utpMessageHandler = this.utpMessageHandlers.get(key);
        if (utpMessageHandler != null) {
            return utpMessageHandler;
        }
        utpMessageHandler = new UtpMessageHandler(connectionId, socketAddress);
        utpMessageHandler.handle(this.channel);
        this.context.newInstance(utpMessageHandler);
        return utpMessageHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(UtpMessageHandler utpMessageHandler) {
        Map<String, UtpMessageHandler> map = this.utpMessageHandlers;
        synchronized (map) {
            this.utpMessageHandlers.put(utpMessageHandler.key(), utpMessageHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(UtpMessageHandler utpMessageHandler) {
        Map<String, UtpMessageHandler> map = this.utpMessageHandlers;
        synchronized (map) {
            this.utpMessageHandlers.remove(utpMessageHandler.key());
        }
    }

    public String buildKey(short connectionId, InetSocketAddress socketAddress) {
        return socketAddress.getHostString() + socketAddress.getPort() + connectionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeout() {
        Map<String, UtpMessageHandler> map = this.utpMessageHandlers;
        synchronized (map) {
            try {
                this.utpMessageHandlers.values().stream().filter(UtpMessageHandler::timeoutRetry).collect(Collectors.toList()).forEach(this::remove);
            }
            catch (Exception e) {
                LOGGER.error("\u5904\u7406\u8d85\u65f6UTP\u6d88\u606f\u5f02\u5e38", e);
            }
        }
    }

    public void close() {
        UtpRequestQueue.getInstance().shutdown();
    }
}

