/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.utp;

import com.acgist.snail.config.UtpConfig;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.NetException;
import com.acgist.snail.net.UdpMessageHandler;
import com.acgist.snail.net.codec.IMessageEncoder;
import com.acgist.snail.net.torrent.IEncryptMessageSender;
import com.acgist.snail.net.torrent.IPeerConnect;
import com.acgist.snail.net.torrent.codec.PeerCryptMessageCodec;
import com.acgist.snail.net.torrent.codec.PeerUnpackMessageCodec;
import com.acgist.snail.net.torrent.peer.PeerSubMessageHandler;
import com.acgist.snail.net.torrent.utp.UtpContext;
import com.acgist.snail.net.torrent.utp.UtpWindow;
import com.acgist.snail.net.torrent.utp.UtpWindowData;
import com.acgist.snail.utils.CollectionUtils;
import com.acgist.snail.utils.DateUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public final class UtpMessageHandler
extends UdpMessageHandler
implements IEncryptMessageSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(UtpMessageHandler.class);
    private volatile boolean connect;
    private final short recvId;
    private final short sendId;
    private final String key;
    private final UtpContext utpContext;
    private final UtpWindow sendWindow;
    private final UtpWindow recvWindow;
    private final AtomicInteger ackLossTimes;
    private final AtomicBoolean connectLock;
    private final IMessageEncoder<ByteBuffer> messageEncoder;
    private final PeerSubMessageHandler peerSubMessageHandler;

    public UtpMessageHandler(short connectionId, InetSocketAddress socketAddress) {
        this(PeerSubMessageHandler.newInstance(), socketAddress, connectionId, true);
    }

    public UtpMessageHandler(PeerSubMessageHandler peerSubMessageHandler, InetSocketAddress socketAddress) {
        this(peerSubMessageHandler, socketAddress, 0, false);
    }

    private UtpMessageHandler(PeerSubMessageHandler peerSubMessageHandler, InetSocketAddress socketAddress, short connectionId, boolean server) {
        super(socketAddress);
        peerSubMessageHandler.messageEncryptSender(this);
        PeerUnpackMessageCodec peerUnpackMessageCodec = new PeerUnpackMessageCodec(peerSubMessageHandler);
        PeerCryptMessageCodec peerCryptMessageCodec = new PeerCryptMessageCodec(peerUnpackMessageCodec, peerSubMessageHandler);
        this.messageDecoder = peerCryptMessageCodec;
        this.messageEncoder = peerCryptMessageCodec;
        this.peerSubMessageHandler = peerSubMessageHandler;
        this.utpContext = UtpContext.getInstance();
        this.sendWindow = UtpWindow.newSendInstance();
        this.recvWindow = UtpWindow.newRecvInstance(this.messageDecoder);
        this.ackLossTimes = new AtomicInteger(0);
        this.connectLock = new AtomicBoolean(false);
        if (server) {
            this.sendId = connectionId;
            this.recvId = (short)(this.sendId + 1);
        } else {
            this.recvId = this.utpContext.connectionId();
            this.sendId = (short)(this.recvId + 1);
        }
        this.key = this.utpContext.buildKey(this.recvId, this.socketAddress);
        this.utpContext.put(this);
    }

    public String key() {
        return this.key;
    }

    @Override
    public boolean useless() {
        return this.peerSubMessageHandler.useless();
    }

    @Override
    public void onReceive(ByteBuffer buffer, InetSocketAddress socketAddress) throws NetException {
        if (buffer.remaining() < 20) {
            throw new NetException("\u5904\u7406UTP\u6d88\u606f\u9519\u8bef\uff08\u957f\u5ea6\uff09\uff1a" + buffer.remaining());
        }
        byte typeVersion = buffer.get();
        UtpConfig.Type type = UtpConfig.Type.of(typeVersion);
        if (type == null) {
            throw new NetException("\u672a\u77e5UTP\u6d88\u606f\u7c7b\u578b\uff1a" + typeVersion);
        }
        byte extension = buffer.get();
        short connectionId = buffer.getShort();
        int timestamp = buffer.getInt();
        int timestampDifference = buffer.getInt();
        int wndSize = buffer.getInt();
        short seqnr = buffer.getShort();
        short acknr = buffer.getShort();
        if (extension != 0 && buffer.remaining() >= 2) {
            short extLength = buffer.getShort();
            if (extLength <= 0 || buffer.remaining() < extLength) {
                throw new NetException("\u5904\u7406UTP\u6d88\u606f\u9519\u8bef\uff08\u6269\u5c55\u957f\u5ea6\uff09\uff1a" + extLength);
            }
            byte[] extData = new byte[extLength];
            buffer.get(extData);
        }
        switch (type) {
            case DATA: {
                this.data(timestamp, seqnr, acknr, buffer);
                break;
            }
            case STATE: {
                this.state(timestamp, seqnr, acknr, wndSize);
                break;
            }
            case FIN: {
                this.fin(timestamp, seqnr, acknr);
                break;
            }
            case RESET: {
                this.reset(timestamp, seqnr, acknr);
                break;
            }
            case SYN: {
                this.syn(timestamp, seqnr, acknr);
                break;
            }
            default: {
                LOGGER.warn("\u5904\u7406UTP\u6d88\u606f\u9519\u8bef\uff08\u672a\u77e5\u7c7b\u578b\uff09\n\u7c7b\u578b\uff1a{}\n\u6269\u5c55\uff1a{}\n\u8fde\u63a5ID\uff1a{}\n\u65f6\u95f4\u6233\uff1a{}\n\u65f6\u95f4\u5dee\uff1a{}\n\u7a97\u53e3\u5927\u5c0f\uff1a{}\n\u8bf7\u6c42\u7f16\u53f7\uff1a{}\n\u5e94\u7b54\u7f16\u53f7\uff1a{}", new Object[]{type, extension, connectionId, timestamp, timestampDifference, wndSize, seqnr, acknr});
            }
        }
    }

    @Override
    public void send(ByteBuffer buffer, int timeout) throws NetException {
        this.sendPacket(buffer);
    }

    @Override
    public void sendEncrypt(ByteBuffer buffer, int timeout) throws NetException {
        this.messageEncoder.encode(buffer);
        this.sendPacket(buffer);
    }

    @Override
    public IPeerConnect.ConnectType connectType() {
        return IPeerConnect.ConnectType.UTP;
    }

    private void sendPacket(ByteBuffer buffer) throws NetException {
        int remaining;
        this.check(buffer);
        while ((remaining = buffer.remaining()) > 0) {
            byte[] bytes = remaining > 1452 ? new byte[1452] : new byte[remaining];
            buffer.get(bytes);
            UtpWindowData windowData = this.sendWindow.build(bytes);
            this.data(windowData);
        }
    }

    public boolean connect() {
        this.connect = false;
        this.connectLock.set(false);
        this.syn();
        this.lockConnect();
        if (!this.connect) {
            this.close();
        }
        return this.connect;
    }

    public boolean timeoutRetry() {
        if (this.available()) {
            List<UtpWindowData> windowDatas = this.sendWindow.timeoutWindowData();
            if (CollectionUtils.isNotEmpty(windowDatas)) {
                LOGGER.debug("\u8d85\u65f6\u6570\u636e\u5305\u91cd\u65b0\u53d1\u9001\uff1a{}-{}", this.sendId, windowDatas.size());
                windowDatas.forEach(windowData -> {
                    if (windowData.discard()) {
                        LOGGER.debug("\u8d85\u65f6\u6570\u636e\u5305\u91cd\u65b0\u53d1\u9001\u5931\u8d25\uff08\u6b21\u6570\u8d85\u9650\uff09\uff1a{}", windowData);
                        this.sendWindow.discard(windowData.getSeqnr());
                    } else {
                        this.data((UtpWindowData)windowData);
                    }
                });
            }
            return false;
        }
        return true;
    }

    private void data(int timestamp, short seqnr, short acknr, ByteBuffer buffer) throws NetException {
        if (!this.connect) {
            LOGGER.debug("UTP\u901a\u9053\u6ca1\u6709\u8fde\u63a5\uff1a{}-{}", seqnr, acknr);
            this.close();
            return;
        }
        LOGGER.debug("\u5904\u7406\u6570\u636e\u6d88\u606f\uff1a{}-{}", seqnr, acknr);
        try {
            this.recvWindow.receive(timestamp, seqnr, buffer);
        }
        catch (IOException e) {
            throw new NetException(e);
        }
        finally {
            this.state(timestamp, this.recvWindow.seqnr());
        }
    }

    private void data(UtpWindowData windowData) {
        LOGGER.debug("\u53d1\u9001\u6570\u636e\u6d88\u606f\uff1a{}", windowData);
        int now = windowData.updateGetTimestamp();
        ByteBuffer buffer = this.buildMessage(UtpConfig.Type.DATA, windowData.getLength() + 20);
        buffer.putShort(this.sendId);
        buffer.putInt(now);
        buffer.putInt(now - this.recvWindow.timestamp());
        buffer.putInt(this.recvWindow.wndSize());
        buffer.putShort(windowData.getSeqnr());
        buffer.putShort(this.recvWindow.seqnr());
        buffer.put(windowData.getData());
        this.pushMessage(buffer);
    }

    private void state(int timestamp, short seqnr, short acknr, int wndSize) {
        boolean loss;
        LOGGER.debug("\u5904\u7406\u54cd\u5e94\u6d88\u606f\uff1a{}-{}", seqnr, acknr);
        if (!this.connect) {
            this.connect = this.available();
            if (this.connect) {
                this.recvWindow.connect(timestamp, (short)(seqnr - 1));
            }
            this.unlockConnect();
        }
        if (loss = this.sendWindow.ack(acknr, wndSize)) {
            UtpWindowData packet;
            if (this.ackLossTimes.incrementAndGet() > 3 && (packet = this.sendWindow.lastUnack()) != null) {
                LOGGER.debug("\u5feb\u901f\u91cd\u4f20\uff1a{}-{}", acknr, packet);
                this.data(packet);
            }
        } else {
            this.ackLossTimes.set(0);
        }
    }

    private void state(int timestamp, short acknr) {
        LOGGER.debug("\u53d1\u9001\u54cd\u5e94\u6d88\u606f\uff1a{}", acknr);
        int now = DateUtils.timestampUs();
        ByteBuffer buffer = this.buildMessage(UtpConfig.Type.STATE, 20);
        buffer.putShort(this.sendId);
        buffer.putInt(now);
        buffer.putInt(now - timestamp);
        buffer.putInt(this.recvWindow.wndSize());
        buffer.putShort(this.sendWindow.seqnr());
        buffer.putShort(acknr);
        this.pushMessage(buffer);
    }

    private void fin(int timestamp, short seqnr, short acknr) {
        LOGGER.debug("\u5904\u7406\u7ed3\u675f\u6d88\u606f\uff1a{}-{}-{}", seqnr, acknr, this.socketAddress);
        if (this.connect) {
            this.state(timestamp, seqnr);
        }
        this.closeRemote();
    }

    private void fin() {
        LOGGER.debug("\u53d1\u9001\u7ed3\u675f\u6d88\u606f\uff1a{}", this.socketAddress);
        ByteBuffer buffer = this.buildMessage(UtpConfig.Type.FIN, 20);
        buffer.putShort(this.sendId);
        buffer.putInt(DateUtils.timestampUs());
        buffer.putInt(0);
        buffer.putInt(0);
        buffer.putShort((short)(this.sendWindow.seqnr() + 1));
        buffer.putShort((short)0);
        this.pushMessage(buffer);
    }

    private void reset(int timestamp, short seqnr, short acknr) {
        LOGGER.debug("\u5904\u7406\u91cd\u7f6e\u6d88\u606f\uff1a{}-{}-{}", seqnr, acknr, this.socketAddress);
        if (this.connect) {
            this.state(timestamp, seqnr);
        }
        this.closeRemote();
    }

    private void reset() {
        LOGGER.debug("\u53d1\u9001\u91cd\u7f6e\u6d88\u606f\uff1a{}", this.socketAddress);
        ByteBuffer buffer = this.buildMessage(UtpConfig.Type.RESET, 20);
        buffer.putShort(this.sendId);
        buffer.putInt(DateUtils.timestampUs());
        buffer.putInt(0);
        buffer.putInt(0);
        buffer.putShort((short)(this.sendWindow.seqnr() + 1));
        buffer.putShort((short)0);
        this.pushMessage(buffer);
    }

    private void syn(int timestamp, short seqnr, short acknr) {
        LOGGER.debug("\u5904\u7406\u63e1\u624b\u6d88\u606f\uff1a{}-{}-{}", seqnr, acknr, this.socketAddress);
        if (!this.connect) {
            this.connect = true;
            this.recvWindow.connect(timestamp, seqnr);
        }
        this.state(timestamp, seqnr);
    }

    private void syn() {
        LOGGER.debug("\u53d1\u9001\u63e1\u624b\u6d88\u606f\uff1a{}", this.socketAddress);
        UtpWindowData windowData = this.sendWindow.build();
        ByteBuffer buffer = this.buildMessage(UtpConfig.Type.SYN, 20);
        buffer.putShort(this.recvId);
        buffer.putInt(windowData.updateGetTimestamp());
        buffer.putInt(0);
        buffer.putInt(0);
        buffer.putShort(windowData.getSeqnr());
        buffer.putShort((short)0);
        this.pushMessage(buffer);
    }

    private ByteBuffer buildMessage(UtpConfig.Type type, int size) {
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.put(type.getTypeVersion());
        buffer.put((byte)0);
        return buffer;
    }

    private void pushMessage(ByteBuffer buffer) {
        try {
            this.send(buffer, this.remoteSocketAddress());
        }
        catch (NetException e) {
            LOGGER.error("\u53d1\u9001UTP\u6d88\u606f\u5f02\u5e38", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockConnect() {
        if (!this.connectLock.get()) {
            AtomicBoolean atomicBoolean = this.connectLock;
            synchronized (atomicBoolean) {
                if (!this.connectLock.get()) {
                    try {
                        this.connectLock.wait(5000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        LOGGER.debug("\u7ebf\u7a0b\u7b49\u5f85\u5f02\u5e38", e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockConnect() {
        AtomicBoolean atomicBoolean = this.connectLock;
        synchronized (atomicBoolean) {
            this.connectLock.set(true);
            this.connectLock.notifyAll();
        }
    }

    private void closeWindow() {
        this.sendWindow.close();
        this.recvWindow.close();
    }

    private void closeConnect() {
        super.close();
        this.connect = false;
        this.utpContext.remove(this);
    }

    private void closeRemote() {
        this.closeWindow();
        this.closeConnect();
    }

    @Override
    public void close() {
        if (this.close) {
            return;
        }
        this.closeWindow();
        if (this.connect) {
            this.fin();
        } else {
            this.reset();
        }
        this.closeConnect();
    }
}

