/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.utp;

import com.acgist.snail.context.SystemThreadContext;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.torrent.utp.UtpRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public final class UtpRequestQueue {
    private static final Logger LOGGER = LoggerFactory.getLogger(UtpRequestQueue.class);
    private static final UtpRequestQueue INSTANCE = new UtpRequestQueue();
    private boolean available = true;
    private final int queueSize = SystemThreadContext.DEFAULT_THREAD_SIZE;
    private final AtomicInteger queueIndex = new AtomicInteger(0);
    private final ExecutorService executor;
    private final List<BlockingQueue<UtpRequest>> queues = new ArrayList<BlockingQueue<UtpRequest>>(this.queueSize);

    public static final UtpRequestQueue getInstance() {
        return INSTANCE;
    }

    private UtpRequestQueue() {
        this.executor = SystemThreadContext.newExecutor(this.queueSize, this.queueSize, 10000, 60L, "ST-UTP-Queue");
        this.buildQueues();
        LOGGER.debug("\u542f\u52a8UTP\u8bf7\u6c42\u961f\u5217\uff1a{}", this.queueSize);
    }

    public BlockingQueue<UtpRequest> queue() {
        int index = this.queueIndex.getAndIncrement() % this.queueSize;
        return this.queues.get(Math.abs(index));
    }

    private void buildQueues() {
        for (int index = 0; index < this.queueSize; ++index) {
            LinkedBlockingQueue queue = new LinkedBlockingQueue();
            this.executor.submit(() -> this.queueExecute(queue));
            this.queues.add(queue);
        }
    }

    private void queueExecute(BlockingQueue<UtpRequest> queue) {
        while (this.available) {
            try {
                queue.take().execute();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.debug("UTP\u5904\u7406\u8bf7\u6c42\u5f02\u5e38", e);
            }
            catch (Exception e) {
                LOGGER.error("UTP\u5904\u7406\u8bf7\u6c42\u5f02\u5e38", e);
            }
        }
    }

    public void shutdown() {
        LOGGER.debug("\u5173\u95edUTP\u8bf7\u6c42\u961f\u5217\u5904\u7406\u7ebf\u7a0b\u6c60", new Object[0]);
        this.available = false;
        SystemThreadContext.shutdown(this.executor);
    }
}

