/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.utp;

import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.codec.IMessageDecoder;
import com.acgist.snail.net.torrent.utp.UtpRequest;
import com.acgist.snail.net.torrent.utp.UtpRequestQueue;
import com.acgist.snail.net.torrent.utp.UtpWindowData;
import com.acgist.snail.utils.ByteUtils;
import com.acgist.snail.utils.DateUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public final class UtpWindow {
    private static final Logger LOGGER = LoggerFactory.getLogger(UtpWindow.class);
    private static final int MIN_WND_SIZE = 16;
    private static final int MAX_WND_SIZE = 64;
    private static final int MAX_TIMEOUT = 500000;
    private static final int SEMAPHORE_TIMEOUT = 2;
    private volatile int wnd = 16;
    private volatile int rtt = 0;
    private volatile int rttVar = 0;
    private volatile int timeout = 500000;
    private volatile boolean close = false;
    private volatile short seqnr = 1;
    private volatile int timestamp = 0;
    private volatile int wndSize = 0;
    private final Map<Short, UtpWindowData> wndMap = new LinkedHashMap<Short, UtpWindowData>();
    private final Semaphore semaphore;
    private final BlockingQueue<UtpRequest> requests;
    private final IMessageDecoder<ByteBuffer> messageDecoder;

    private UtpWindow() {
        this(null);
    }

    private UtpWindow(IMessageDecoder<ByteBuffer> messageDecoder) {
        if (messageDecoder == null) {
            this.requests = null;
            this.messageDecoder = null;
            this.semaphore = new Semaphore(16);
        } else {
            this.requests = UtpRequestQueue.getInstance().queue();
            this.messageDecoder = messageDecoder;
            this.semaphore = null;
        }
    }

    public static final UtpWindow newSendInstance() {
        return new UtpWindow();
    }

    public static final UtpWindow newRecvInstance(IMessageDecoder<ByteBuffer> messageDecoder) {
        return new UtpWindow(messageDecoder);
    }

    public void connect(int timestamp, short seqnr) {
        this.seqnr = seqnr;
        this.timestamp = timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int wndSize() {
        UtpWindow utpWindow = this;
        synchronized (utpWindow) {
            return 0x100000 - this.wndSize;
        }
    }

    public UtpWindowData build() {
        return this.build(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UtpWindowData build(byte[] data) {
        this.acquire();
        UtpWindow utpWindow = this;
        synchronized (utpWindow) {
            this.timestamp = DateUtils.timestampUs();
            UtpWindowData windowData = this.storage(this.timestamp, this.seqnr, data);
            this.seqnr = (short)(this.seqnr + 1);
            return windowData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UtpWindowData> timeoutWindowData() {
        UtpWindow utpWindow = this;
        synchronized (utpWindow) {
            int timeout = this.timeout;
            int timestamp = DateUtils.timestampUs();
            return this.wndMap.values().stream().filter(windowData -> timestamp - windowData.getTimestamp() > timeout).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ack(short acknr, int wndSize) {
        UtpWindow utpWindow = this;
        synchronized (utpWindow) {
            this.wndSize = wndSize;
            boolean loss = true;
            int timestamp = DateUtils.timestampUs();
            Iterator<Map.Entry<Short, UtpWindowData>> iterator = this.wndMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Short, UtpWindowData> entry = iterator.next();
                short diff = (short)(acknr - entry.getKey());
                if (diff < 0) continue;
                loss = false;
                this.timeout(timestamp - entry.getValue().getTimestamp());
                this.release();
                iterator.remove();
            }
            if (!loss) {
                this.wndControl();
            }
            return loss;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(int timestamp, short seqnr, ByteBuffer buffer) throws IOException {
        UtpWindow utpWindow = this;
        synchronized (utpWindow) {
            UtpWindowData nextWindowData;
            short diff = (short)(this.seqnr - seqnr);
            if (diff >= 0) {
                return;
            }
            this.storage(timestamp, seqnr, buffer);
            short nextSeqnr = this.seqnr;
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            while ((nextWindowData = this.take(nextSeqnr = (short)(nextSeqnr + 1))) != null) {
                this.seqnr = nextWindowData.getSeqnr();
                this.timestamp = nextWindowData.getTimestamp();
                output.write(nextWindowData.getData());
            }
            byte[] bytes = output.toByteArray();
            if (bytes.length == 0) {
                return;
            }
            if (this.requests.offer(UtpRequest.newInstance(ByteBuffer.wrap(bytes), this.messageDecoder))) {
                LOGGER.debug("\u5904\u7406UTP\u6570\u636e\u6d88\u606f\uff1a{}-{}", seqnr, this.seqnr);
            } else {
                LOGGER.warn("\u5904\u7406UTP\u6570\u636e\u6d88\u606f\u5931\u8d25\uff1a{}-{}", seqnr, this.seqnr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UtpWindowData lastUnack() {
        UtpWindow utpWindow = this;
        synchronized (utpWindow) {
            return this.wndMap.get((short)(this.seqnr + 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discard(short seqnr) {
        UtpWindow utpWindow = this;
        synchronized (utpWindow) {
            this.take(seqnr);
        }
    }

    private UtpWindowData take(short seqnr) {
        UtpWindowData windowData = this.wndMap.remove(seqnr);
        if (windowData == null) {
            return windowData;
        }
        this.wndSize -= windowData.getLength();
        return windowData;
    }

    private UtpWindowData storage(int timestamp, short seqnr, ByteBuffer buffer) {
        byte[] bytes = ByteUtils.remainingToBytes(buffer);
        return this.storage(timestamp, seqnr, bytes);
    }

    private UtpWindowData storage(int timestamp, short seqnr, byte[] bytes) {
        UtpWindowData windowData = UtpWindowData.newInstance(seqnr, timestamp, bytes);
        this.wndMap.put(seqnr, windowData);
        this.wndSize += windowData.getLength();
        return windowData;
    }

    private void timeout(int packetRtt) {
        int rtt = this.rtt;
        int rttVar = this.rttVar;
        int delta = rtt - packetRtt;
        rtt += (packetRtt - rtt) / 8;
        rttVar += (Math.abs(delta) - rttVar) / 4;
        this.rtt = rtt;
        this.rttVar = rttVar;
        this.timeout = Math.max(rtt + rttVar * 4, 500000);
        LOGGER.debug("UTP\u8d85\u65f6\u65f6\u95f4\uff1a{}", this.timeout);
    }

    private void wndControl() {
        int wnd = this.wnd;
        if (this.timeout <= 500000) {
            if (wnd < 64) {
                ++wnd;
                this.release();
            }
        } else if ((wnd /= 2) < 16) {
            wnd = 16;
        }
        this.wnd = wnd;
        LOGGER.debug("UTP\u7a97\u53e3\u5927\u5c0f\uff1a{}", this.wnd);
    }

    private void acquire() {
        if (this.close) {
            return;
        }
        try {
            if (!this.semaphore.tryAcquire(2L, TimeUnit.SECONDS)) {
                LOGGER.debug("\u83b7\u53d6\u4fe1\u53f7\u91cf\u5931\u8d25\uff1a{}-{}", this.wnd, this.wndSize);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.debug("\u83b7\u53d6\u4fe1\u53f7\u91cf\u5f02\u5e38", e);
        }
    }

    private void release() {
        if (this.semaphore == null) {
            return;
        }
        int available = this.semaphore.availablePermits();
        if (available < this.wnd) {
            LOGGER.debug("\u4fe1\u53f7\u91cf\u91ca\u653e\uff1a{}", available);
            this.semaphore.release();
        }
    }

    public void close() {
        this.close = true;
        this.release();
    }

    public short seqnr() {
        return this.seqnr;
    }

    public int timestamp() {
        return this.timestamp;
    }
}

