/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.torrent.utp;

import com.acgist.snail.utils.BeanUtils;
import com.acgist.snail.utils.DateUtils;

public final class UtpWindowData {
    private final short seqnr;
    private final byte[] data;
    private final int length;
    private volatile int timestamp;
    private volatile byte pushTimes;

    private UtpWindowData(short seqnr, int timestamp, byte[] data) {
        this.seqnr = seqnr;
        this.data = data == null ? new byte[0] : data;
        this.length = this.data.length;
        this.timestamp = timestamp;
        this.pushTimes = 0;
    }

    public static final UtpWindowData newInstance(short seqnr, int timestamp, byte[] data) {
        return new UtpWindowData(seqnr, timestamp, data);
    }

    public short getSeqnr() {
        return this.seqnr;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getLength() {
        return this.length;
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public byte getPushTimes() {
        return this.pushTimes;
    }

    public boolean discard() {
        return this.pushTimes > 3;
    }

    public int updateGetTimestamp() {
        this.pushTimes = (byte)(this.pushTimes + 1);
        this.timestamp = DateUtils.timestampUs();
        return this.timestamp;
    }

    public String toString() {
        return BeanUtils.toString(this, this.seqnr, this.pushTimes);
    }
}

