/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.upnp;

import com.acgist.snail.config.SymbolConfig;
import com.acgist.snail.context.wrapper.HeaderWrapper;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.NetException;
import com.acgist.snail.net.UdpClient;
import com.acgist.snail.net.upnp.UpnpMessageHandler;
import com.acgist.snail.net.upnp.UpnpServer;
import com.acgist.snail.utils.NetUtils;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;

public final class UpnpClient
extends UdpClient<UpnpMessageHandler> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpnpClient.class);
    private static final String PROTOCOL = "M-SEARCH * HTTP/1.1";

    private UpnpClient(InetSocketAddress socketAddress) {
        super("UPNP Client", new UpnpMessageHandler(socketAddress));
    }

    public static final UpnpClient newInstance() {
        return new UpnpClient(NetUtils.buildSocketAddress(UpnpServer.upnpHost(), 1900));
    }

    @Override
    public boolean open() {
        return this.open((DatagramChannel)UpnpServer.getInstance().getChannel());
    }

    public void mSearch() {
        LOGGER.debug("\u53d1\u9001M-SEARCH\u6d88\u606f", new Object[0]);
        try {
            this.send(this.buildMSearch());
        }
        catch (NetException e) {
            LOGGER.error("\u53d1\u9001M-SEARCH\u6d88\u606f\u5f02\u5e38", e);
        }
    }

    private String buildMSearch() {
        HeaderWrapper builder = HeaderWrapper.newBuilder(PROTOCOL);
        builder.setHeader("HOST", SymbolConfig.Symbol.COLON.join(UpnpServer.upnpHost(), 1900)).setHeader("ST", "upnp:rootdevice").setHeader("MAN", "\"ssdp:discover\"").setHeader("MX", "3");
        return builder.build();
    }
}

