/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.upnp;

import com.acgist.snail.config.SystemConfig;
import com.acgist.snail.context.IContext;
import com.acgist.snail.context.wrapper.URIWrapper;
import com.acgist.snail.format.XML;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.NetException;
import com.acgist.snail.net.http.HttpClient;
import com.acgist.snail.net.torrent.dht.NodeContext;
import com.acgist.snail.net.upnp.UpnpRequest;
import com.acgist.snail.net.upnp.UpnpResponse;
import com.acgist.snail.protocol.Protocol;
import com.acgist.snail.utils.CollectionUtils;
import com.acgist.snail.utils.NetUtils;
import com.acgist.snail.utils.StringUtils;
import com.acgist.snail.utils.UrlUtils;
import java.util.List;

public final class UpnpContext
implements IContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpnpContext.class);
    private static final UpnpContext INSTANCE = new UpnpContext();
    private static final String SERVICE_WANIPC = "urn:schemas-upnp-org:service:WANIPConnection:";
    private String location;
    private String controlUrl;
    private String serviceType;
    private volatile boolean available = false;

    public static final UpnpContext getInstance() {
        return INSTANCE;
    }

    private UpnpContext() {
    }

    public boolean available() {
        return this.available;
    }

    public UpnpContext load(String location) throws NetException {
        URIWrapper wrapper = URIWrapper.newInstance(location).decode();
        if (!NetUtils.lan(wrapper.getHost())) {
            LOGGER.info("UPNP\u63cf\u8ff0\u6587\u4ef6\u9519\u8bef\uff1a{}", location);
            return this;
        }
        String body = HttpClient.newInstance(location).get().responseToString();
        XML xml = XML.load(body);
        List<String> serviceTypes = xml.elementValues("serviceType");
        if (CollectionUtils.isEmpty(serviceTypes)) {
            LOGGER.warn("UPNP\u8bbe\u7f6e\u5931\u8d25\uff08\u670d\u52a1\u7c7b\u578b\uff09\uff1a{}", body);
            return this;
        }
        boolean success = false;
        List<String> controlUrls = xml.elementValues("controlURL");
        for (int index = 0; index < serviceTypes.size(); ++index) {
            String serviceType = serviceTypes.get(index);
            if (!StringUtils.startsWith(serviceType, SERVICE_WANIPC)) continue;
            success = true;
            this.available = true;
            this.location = location;
            this.serviceType = serviceType;
            this.controlUrl = UrlUtils.redirect(this.location, controlUrls.get(index));
            LOGGER.debug("UPNP\u63cf\u8ff0\u6587\u4ef6\uff1a{}", this.location);
            LOGGER.debug("UPNP\u670d\u52a1\u7c7b\u578b\uff1a{}", this.serviceType);
            LOGGER.debug("UPNP\u63a7\u5236\u5730\u5740\uff1a{}", this.controlUrl);
            break;
        }
        if (!success) {
            LOGGER.info("UPNP\u63cf\u8ff0\u6587\u4ef6\u65e0\u6548\uff1a{}", location);
        }
        return this;
    }

    public String getExternalIPAddress() throws NetException {
        if (!this.available) {
            return null;
        }
        UpnpRequest upnpRequest = UpnpRequest.newRequest(this.serviceType);
        String xml = upnpRequest.buildGetExternalIPAddress();
        String body = HttpClient.newInstance(this.controlUrl).header("SOAPAction", "\"" + this.serviceType + "#GetExternalIPAddress\"").post(xml).responseToString();
        return UpnpResponse.parseGetExternalIPAddress(body);
    }

    public Status getSpecificPortMappingEntry(int portExt, Protocol.Type protocol) throws NetException {
        if (!this.available) {
            return Status.UNINIT;
        }
        UpnpRequest upnpRequest = UpnpRequest.newRequest(this.serviceType);
        String xml = upnpRequest.buildGetSpecificPortMappingEntry(portExt, protocol);
        HttpClient client = HttpClient.newInstance(this.controlUrl).header("SOAPAction", "\"" + this.serviceType + "#GetSpecificPortMappingEntry\"").post(xml);
        if (client.internalError()) {
            return Status.MAPABLE;
        }
        String body = client.responseToString();
        String mappingIP = UpnpResponse.parseGetSpecificPortMappingEntry(body);
        if (NetUtils.LOCAL_HOST_ADDRESS.equals(mappingIP)) {
            return Status.USEABLE;
        }
        LOGGER.debug("UPNP\u7aef\u53e3\u5df2\u88ab\u6620\u5c04\uff1a{}-{}", mappingIP, portExt);
        return Status.DISABLE;
    }

    public boolean addPortMapping(int port, int portExt, Protocol.Type protocol) throws NetException {
        if (!this.available) {
            return false;
        }
        UpnpRequest upnpRequest = UpnpRequest.newRequest(this.serviceType);
        String xml = upnpRequest.buildAddPortMapping(port, NetUtils.LOCAL_HOST_ADDRESS, portExt, protocol);
        return HttpClient.newInstance(this.controlUrl).header("SOAPAction", "\"" + this.serviceType + "#AddPortMapping\"").post(xml).ok();
    }

    public boolean deletePortMapping(int portExt, Protocol.Type protocol) throws NetException {
        if (!this.available) {
            return false;
        }
        UpnpRequest upnpRequest = UpnpRequest.newRequest(this.serviceType);
        String xml = upnpRequest.buildDeletePortMapping(portExt, protocol);
        return HttpClient.newInstance(this.controlUrl).header("SOAPAction", "\"" + this.serviceType + "#DeletePortMapping\"").post(xml).ok();
    }

    public boolean mapping() throws NetException {
        int torrentPort;
        if (!this.available) {
            return false;
        }
        String externalIPAddress = this.getExternalIPAddress();
        if (NetUtils.localIP(externalIPAddress)) {
            LOGGER.warn("UPNP\u7aef\u53e3\u6620\u5c04\u5931\u8d25\uff08\u591a\u91cd\u8def\u7531\u73af\u5883\uff09\uff1a{}", externalIPAddress);
            return false;
        }
        SystemConfig.setExternalIPAddress(externalIPAddress);
        NodeContext.getInstance().buildNodeId(externalIPAddress);
        Status udpStatus = Status.DISABLE;
        int portExt = torrentPort = SystemConfig.getTorrentPort();
        while (portExt < 65536) {
            udpStatus = this.getSpecificPortMappingEntry(portExt, Protocol.Type.UDP);
            if (udpStatus == Status.DISABLE) {
                ++portExt;
                continue;
            }
            Status tcpStatus = this.getSpecificPortMappingEntry(portExt, Protocol.Type.TCP);
            if (udpStatus == tcpStatus) break;
            this.deletePortMapping(portExt, Protocol.Type.UDP);
            ++portExt;
        }
        if (udpStatus == Status.MAPABLE) {
            SystemConfig.setTorrentPortExt(portExt);
            boolean udpOk = this.addPortMapping(torrentPort, portExt, Protocol.Type.UDP);
            boolean tcpOk = this.addPortMapping(torrentPort, portExt, Protocol.Type.TCP);
            LOGGER.debug("UPNP\u7aef\u53e3\u6620\u5c04\uff08\u6ce8\u518c\uff09\uff1aUDP\uff08{}-{}-{}\uff09\u3001TCP\uff08{}-{}-{}\uff09", torrentPort, portExt, udpOk, torrentPort, portExt, tcpOk);
            return true;
        }
        if (udpStatus == Status.USEABLE) {
            SystemConfig.setTorrentPortExt(portExt);
            LOGGER.debug("UPNP\u7aef\u53e3\u6620\u5c04\uff08\u53ef\u7528\uff09\uff1aUDP\uff08{}-{}\uff09\u3001TCP\uff08{}-{}\uff09", torrentPort, portExt, torrentPort, portExt);
            return true;
        }
        LOGGER.warn("UPNP\u7aef\u53e3\u6620\u5c04\u5931\u8d25", new Object[0]);
        return false;
    }

    public void release() {
        if (this.available) {
            try {
                boolean udpOk = this.deletePortMapping(SystemConfig.getTorrentPortExt(), Protocol.Type.UDP);
                boolean tcpOk = this.deletePortMapping(SystemConfig.getTorrentPortExt(), Protocol.Type.TCP);
                LOGGER.debug("\u91ca\u653eUPNP\u7aef\u53e3\uff1aUDP\uff1a{}\u3001TCP\uff1a{}", udpOk, tcpOk);
            }
            catch (NetException e) {
                LOGGER.error("\u91ca\u653eUPNP\u7aef\u53e3\u5f02\u5e38", e);
            }
            this.available = false;
        }
    }

    public static enum Status {
        UNINIT,
        DISABLE,
        MAPABLE,
        USEABLE;

    }
}

