/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.upnp;

import com.acgist.snail.context.wrapper.HeaderWrapper;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.NatContext;
import com.acgist.snail.net.NetException;
import com.acgist.snail.net.UdpMessageHandler;
import com.acgist.snail.net.codec.IMessageDecoder;
import com.acgist.snail.net.codec.StringMessageCodec;
import com.acgist.snail.net.upnp.UpnpContext;
import com.acgist.snail.utils.StringUtils;
import java.net.InetSocketAddress;

public final class UpnpMessageHandler
extends UdpMessageHandler
implements IMessageDecoder<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpnpMessageHandler.class);
    private static final String HEADER_LOCATION = "location";

    public UpnpMessageHandler() {
        this(null);
    }

    public UpnpMessageHandler(InetSocketAddress socketAddress) {
        super(socketAddress);
        this.messageDecoder = new StringMessageCodec(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(String message, InetSocketAddress address) {
        HeaderWrapper headers = HeaderWrapper.newInstance(message);
        boolean support = headers.getHeaders().values().stream().anyMatch(list -> list.stream().anyMatch(value -> StringUtils.startsWith(value, "upnp:rootdevice")));
        if (!support) {
            LOGGER.warn("UPNP\u8bbe\u7f6e\u5931\u8d25\uff08\u4e0d\u652f\u6301\u7684\u9a71\u52a8\uff09\uff1a{}", message);
            return;
        }
        String location = headers.getHeader(HEADER_LOCATION);
        if (StringUtils.isEmpty(location)) {
            LOGGER.warn("UPNP\u8bbe\u7f6e\u5931\u8d25\uff08\u6ca1\u6709\u63cf\u8ff0\u6587\u4ef6\u5730\u5740\uff09\uff1a{}", message);
            return;
        }
        UpnpContext upnpContext = UpnpContext.getInstance();
        try {
            upnpContext.load(location);
        }
        catch (NetException e) {
            LOGGER.error("UPNP\u7aef\u53e3\u6620\u5c04\u5f02\u5e38\uff1a{}", location, e);
        }
        finally {
            if (upnpContext.available()) {
                NatContext.getInstance().unlock();
            }
        }
    }
}

