/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.net.upnp;

import com.acgist.snail.config.SystemConfig;
import com.acgist.snail.format.XML;
import com.acgist.snail.protocol.Protocol;
import org.w3c.dom.Element;

public final class UpnpRequest {
    private static final String NAMESPACE_ENVELOPE = "http://schemas.xmlsoap.org/soap/envelope/";
    private static final String NAMESPANCE_ENCODING = "http://schemas.xmlsoap.org/soap/encoding/";
    private XML xml;
    private Element body;
    private final String serviceType;

    private UpnpRequest(String serviceType) {
        this.serviceType = serviceType;
    }

    public static final UpnpRequest newRequest(String serviceType) {
        UpnpRequest request = new UpnpRequest(serviceType);
        request.build();
        return request;
    }

    private void build() {
        this.xml = XML.build();
        Element envelope = this.xml.elementNS(this.xml.document(), "s:Envelope", NAMESPACE_ENVELOPE);
        envelope.setAttributeNS(NAMESPACE_ENVELOPE, "encodingStyle", NAMESPANCE_ENCODING);
        this.body = this.xml.element(envelope, "s:Body");
    }

    public String buildGetExternalIPAddress() {
        this.xml.elementNS(this.body, "u:GetExternalIPAddress", this.serviceType);
        return this.xml();
    }

    public String buildGetSpecificPortMappingEntry(int portExt, Protocol.Type protocol) {
        Element mapping = this.xml.elementNS(this.body, "u:GetSpecificPortMappingEntry", this.serviceType);
        this.xml.element(mapping, "NewRemoteHost", "");
        this.xml.element(mapping, "NewExternalPort", String.valueOf(portExt));
        this.xml.element(mapping, "NewProtocol", protocol.name().toUpperCase());
        return this.xml();
    }

    public String buildAddPortMapping(int port, String address, int portExt, Protocol.Type protocol) {
        Element mapping = this.xml.elementNS(this.body, "u:AddPortMapping", this.serviceType);
        this.xml.element(mapping, "NewRemoteHost", "");
        this.xml.element(mapping, "NewExternalPort", String.valueOf(portExt));
        this.xml.element(mapping, "NewProtocol", protocol.name().toUpperCase());
        this.xml.element(mapping, "NewInternalPort", String.valueOf(port));
        this.xml.element(mapping, "NewInternalClient", address);
        this.xml.element(mapping, "NewEnabled", "1");
        this.xml.element(mapping, "NewPortMappingDescription", SystemConfig.getNameEn());
        this.xml.element(mapping, "NewLeaseDuration", "0");
        return this.xml();
    }

    public String buildDeletePortMapping(int portExt, Protocol.Type protocol) {
        Element mapping = this.xml.elementNS(this.body, "u:DeletePortMapping", this.serviceType);
        this.xml.element(mapping, "NewRemoteHost", "");
        this.xml.element(mapping, "NewExternalPort", String.valueOf(portExt));
        this.xml.element(mapping, "NewProtocol", protocol.name().toUpperCase());
        return this.xml();
    }

    private String xml() {
        return this.xml.xml(false);
    }
}

