/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.protocol;

import com.acgist.snail.config.DownloadConfig;
import com.acgist.snail.config.SymbolConfig;
import com.acgist.snail.context.EntityContext;
import com.acgist.snail.context.ITaskSession;
import com.acgist.snail.context.ITaskSessionStatus;
import com.acgist.snail.context.entity.TaskEntity;
import com.acgist.snail.context.session.TaskSession;
import com.acgist.snail.downloader.IDownloader;
import com.acgist.snail.net.DownloadException;
import com.acgist.snail.protocol.IProtocol;
import com.acgist.snail.utils.FileUtils;
import com.acgist.snail.utils.StringUtils;
import java.io.File;

public abstract class Protocol
implements IProtocol {
    private static final String MAGNET_BASIC = "magnet:\\?.+";
    private static final String MAGNET_HASH_32 = "[a-zA-Z0-9]{32}";
    private static final String MAGNET_HASH_40 = "[a-zA-Z0-9]{40}";
    protected final Type type;
    protected final String name;
    protected String url;
    protected TaskEntity taskEntity;

    protected Protocol(Type type, String name) {
        this.type = type;
        this.name = name;
    }

    public final Type type() {
        return this.type;
    }

    public final String name() {
        return this.name;
    }

    public boolean verify(String url) {
        if (this.type == null) {
            return false;
        }
        return this.type.verify(url);
    }

    public abstract boolean available();

    public abstract IDownloader buildDownloader(ITaskSession var1);

    public synchronized ITaskSession buildTaskSession(String url) throws DownloadException {
        this.url = url.strip();
        boolean success = true;
        try {
            this.buildTaskEntity();
            ITaskSession iTaskSession = TaskSession.newInstance(this.taskEntity);
            return iTaskSession;
        }
        catch (DownloadException e) {
            success = false;
            throw e;
        }
        catch (Exception e) {
            success = false;
            throw new DownloadException("\u4e0b\u8f7d\u5931\u8d25", e);
        }
        finally {
            if (success) {
                this.success();
            }
            this.release(success);
        }
    }

    protected void buildTaskEntity() throws DownloadException {
        this.taskEntity = new TaskEntity();
        this.prep();
        this.buildUrl();
        this.buildType();
        this.buildStatus();
        String fileName = this.buildFileName();
        this.buildName(fileName);
        this.buildFile(fileName);
        this.buildFileType(fileName);
        this.buildSize();
        this.done();
        this.persistentTaskEntity();
    }

    protected void prep() throws DownloadException {
    }

    protected void buildUrl() throws DownloadException {
        this.taskEntity.setUrl(this.url);
    }

    protected void buildType() throws DownloadException {
        this.taskEntity.setType(this.type);
    }

    protected void buildStatus() throws DownloadException {
        this.taskEntity.setStatus(ITaskSessionStatus.Status.AWAIT);
    }

    protected String buildFileName() throws DownloadException {
        return FileUtils.fileName(this.url);
    }

    protected void buildName(String fileName) throws DownloadException {
        String taskName = fileName;
        int index = fileName.lastIndexOf(SymbolConfig.Symbol.DOT.toChar());
        if (index != -1) {
            taskName = fileName.substring(0, index);
        }
        this.taskEntity.setName(taskName);
    }

    protected void buildFile(String fileName) throws DownloadException {
        String filePath = DownloadConfig.getPath(fileName);
        File file = new File(filePath);
        if (file.exists()) {
            throw new DownloadException("\u4e0b\u8f7d\u6587\u4ef6\u5df2\u7ecf\u5b58\u5728\uff1a" + file);
        }
        this.taskEntity.setFile(filePath);
    }

    protected void buildFileType(String fileName) throws DownloadException {
        this.taskEntity.setFileType(FileUtils.fileType(fileName));
    }

    protected void buildSize() throws DownloadException {
    }

    protected void done() throws DownloadException {
    }

    protected void persistentTaskEntity() throws DownloadException {
        EntityContext.getInstance().save(this.taskEntity);
    }

    protected void success() {
    }

    protected void release(boolean success) {
        this.url = null;
        this.taskEntity = null;
    }

    public static enum Type {
        UDP(new String[]{"udp://.+"}, new String[]{"udp://"}, new String[0], "udp://", ""),
        TCP(new String[]{"tcp://.+"}, new String[]{"tcp://"}, new String[0], "tcp://", ""),
        FTP(new String[]{"ftp://.+"}, new String[]{"ftp://"}, new String[0], "ftp://", ""),
        HLS(new String[]{"http://.+\\.m3u8", "https://.+\\.m3u8"}, new String[0], new String[]{".m3u8"}, "", ".m3u8"),
        HTTP(new String[]{"http://.+", "https://.+"}, new String[]{"http://", "https://"}, new String[0], "http://", ""),
        MAGNET(new String[]{"magnet:\\?.+", "[a-zA-Z0-9]{32}", "[a-zA-Z0-9]{40}"}, new String[]{"magnet:?xt=urn:btih:"}, new String[0], "magnet:?xt=urn:btih:", ""),
        THUNDER(new String[]{"thunder://.+"}, new String[]{"thunder://"}, new String[0], "thunder://", ""),
        TORRENT(new String[]{".+\\.torrent"}, new String[0], new String[]{".torrent"}, "", ".torrent");

        private final String[] regexs;
        private final String[] prefix;
        private final String[] suffix;
        private final String defaultPrefix;
        private final String defaultSuffix;

        private Type(String[] regexs, String[] prefix, String[] suffix, String defaultPrefix, String defaultSuffix) {
            this.regexs = regexs;
            this.prefix = prefix;
            this.suffix = suffix;
            this.defaultPrefix = defaultPrefix;
            this.defaultSuffix = defaultSuffix;
        }

        public String[] regexs() {
            return this.regexs;
        }

        public String[] prefix() {
            return this.prefix;
        }

        public String prefix(String url) {
            for (String value : this.prefix) {
                if (!StringUtils.startsWith(url, value)) continue;
                return value;
            }
            return null;
        }

        public String[] suffix() {
            return this.suffix;
        }

        public String suffix(String url) {
            for (String value : this.suffix) {
                if (!StringUtils.endsWith(url, value)) continue;
                return value;
            }
            return null;
        }

        public String defaultPrefix() {
            return this.defaultPrefix;
        }

        public String defaultSuffix() {
            return this.defaultSuffix;
        }

        public boolean verify(String url) {
            for (String regex : this.regexs) {
                if (!StringUtils.regex(url, regex, true)) continue;
                return true;
            }
            return false;
        }

        public static final String buildMagnet(String hash) {
            if (Type.verifyMagnet(hash)) {
                return hash;
            }
            return Type.MAGNET.defaultPrefix + hash.toLowerCase();
        }

        public static final boolean verifyMagnet(String url) {
            return StringUtils.regex(url, Protocol.MAGNET_BASIC, true);
        }

        public static final boolean verifyMagnetHash32(String url) {
            return StringUtils.regex(url, Protocol.MAGNET_HASH_32, true);
        }

        public static final boolean verifyMagnetHash40(String url) {
            return StringUtils.regex(url, Protocol.MAGNET_HASH_40, true);
        }
    }
}

