/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.protocol;

import com.acgist.snail.Snail;
import com.acgist.snail.context.IContext;
import com.acgist.snail.context.ITaskSession;
import com.acgist.snail.downloader.IDownloader;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.DownloadException;
import com.acgist.snail.protocol.Protocol;
import com.acgist.snail.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ProtocolContext
implements IContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtocolContext.class);
    private static final ProtocolContext INSTANCE = new ProtocolContext();
    private final List<Protocol> protocols = new ArrayList<Protocol>();
    private final AtomicBoolean availableLock = new AtomicBoolean(false);

    public static final ProtocolContext getInstance() {
        return INSTANCE;
    }

    private ProtocolContext() {
    }

    public ProtocolContext register(Protocol protocol) {
        if (this.protocols.contains(protocol)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u4e0b\u8f7d\u534f\u8bae\u5df2\u7ecf\u6ce8\u518c\uff1a{}", protocol.name());
            }
        } else {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("\u6ce8\u518c\u4e0b\u8f7d\u534f\u8bae\uff1a{}", protocol.name());
            }
            this.protocols.add(protocol);
        }
        return this;
    }

    public IDownloader buildDownloader(ITaskSession taskSession) throws DownloadException {
        Protocol.Type type = taskSession.getType();
        Optional<Protocol> optional = this.protocols.stream().filter(Protocol::available).filter(protocol -> protocol.type() == type).findFirst();
        if (optional.isEmpty()) {
            throw new DownloadException("\u4e0d\u652f\u6301\u7684\u4e0b\u8f7d\u7c7b\u578b\uff1a" + type);
        }
        IDownloader downloader = optional.get().buildDownloader(taskSession);
        if (downloader == null) {
            throw new DownloadException("\u4e0d\u652f\u6301\u7684\u4e0b\u8f7d\u7c7b\u578b\uff1a" + type);
        }
        return downloader;
    }

    public ITaskSession buildTaskSession(String url) throws DownloadException {
        Optional<Protocol> protocol = this.protocol(url);
        if (protocol.isEmpty()) {
            throw new DownloadException("\u4e0d\u652f\u6301\u7684\u4e0b\u8f7d\u94fe\u63a5\uff1a" + url);
        }
        return protocol.get().buildTaskSession(url);
    }

    public boolean support(String url) {
        return this.protocol(url).isPresent();
    }

    public Optional<Protocol> protocol(String url) {
        if (StringUtils.isEmpty(url)) {
            return Optional.empty();
        }
        String verify = url.strip();
        return this.protocols.stream().filter(Protocol::available).filter(protocol -> protocol.verify(verify)).findFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean available() throws DownloadException {
        if (!this.availableLock.get()) {
            AtomicBoolean atomicBoolean = this.availableLock;
            synchronized (atomicBoolean) {
                if (!this.availableLock.get()) {
                    try {
                        this.availableLock.wait(32767L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        LOGGER.debug("\u7ebf\u7a0b\u7b49\u5f85\u5f02\u5e38", e);
                    }
                }
            }
        }
        if (Snail.available()) {
            return true;
        }
        throw new DownloadException("\u7cfb\u7edf\u6ca1\u6709\u542f\u52a8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void available(boolean available) {
        AtomicBoolean atomicBoolean = this.availableLock;
        synchronized (atomicBoolean) {
            this.availableLock.set(available);
            this.availableLock.notifyAll();
        }
    }
}

