/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.protocol.ftp;

import com.acgist.snail.context.ITaskSession;
import com.acgist.snail.downloader.IDownloader;
import com.acgist.snail.downloader.ftp.FtpDownloader;
import com.acgist.snail.net.DownloadException;
import com.acgist.snail.net.ftp.FtpClient;
import com.acgist.snail.protocol.Protocol;

public final class FtpProtocol
extends Protocol {
    private static final FtpProtocol INSTANCE = new FtpProtocol();

    public static final FtpProtocol getInstance() {
        return INSTANCE;
    }

    private FtpProtocol() {
        super(Protocol.Type.FTP, "FTP");
    }

    @Override
    public boolean available() {
        return true;
    }

    @Override
    public IDownloader buildDownloader(ITaskSession taskSession) {
        return FtpDownloader.newInstance(taskSession);
    }

    @Override
    protected void buildSize() throws DownloadException {
        try (FtpClient client = FtpClient.newInstance(this.url);){
            client.connect();
            long size = client.size();
            this.taskEntity.setSize(size);
        }
    }
}

