/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.protocol.hls;

import com.acgist.snail.config.SymbolConfig;
import com.acgist.snail.context.ITaskSession;
import com.acgist.snail.context.wrapper.DescriptionWrapper;
import com.acgist.snail.context.wrapper.URIWrapper;
import com.acgist.snail.downloader.IDownloader;
import com.acgist.snail.downloader.hls.HlsDownloader;
import com.acgist.snail.net.DownloadException;
import com.acgist.snail.net.NetException;
import com.acgist.snail.net.hls.HlsContext;
import com.acgist.snail.net.hls.M3u8;
import com.acgist.snail.net.http.HttpClient;
import com.acgist.snail.protocol.Protocol;
import com.acgist.snail.protocol.hls.M3u8Builder;
import com.acgist.snail.utils.FileUtils;
import com.acgist.snail.utils.StringUtils;

public final class HlsProtocol
extends Protocol {
    private static final HlsProtocol INSTANCE = new HlsProtocol();
    private static final String INDEX_M3U8 = "/index.m3u8";
    private M3u8 m3u8;

    public static final HlsProtocol getInstance() {
        return INSTANCE;
    }

    private HlsProtocol() {
        super(Protocol.Type.HLS, "HLS");
    }

    @Override
    public boolean available() {
        return true;
    }

    @Override
    public IDownloader buildDownloader(ITaskSession taskSession) {
        return HlsDownloader.newInstance(taskSession);
    }

    @Override
    protected void prep() throws DownloadException {
        try {
            this.buildM3u8();
        }
        catch (NetException e) {
            throw new DownloadException("\u7f51\u7edc\u5f02\u5e38", e);
        }
    }

    @Override
    protected String buildFileName() throws DownloadException {
        String path = URIWrapper.newInstance(this.url).decode().getPath();
        if (StringUtils.endsWithIgnoreCase(path, INDEX_M3U8)) {
            return path.substring(1, path.length() - INDEX_M3U8.length()).replace(SymbolConfig.Symbol.SLASH.toChar(), SymbolConfig.Symbol.MINUS.toChar()) + Protocol.Type.HLS.defaultSuffix();
        }
        return super.buildFileName();
    }

    @Override
    protected void buildSize() throws DownloadException {
        this.taskEntity.setSize(0L);
    }

    @Override
    protected void done() throws DownloadException {
        this.buildFolder();
        this.selectFiles();
    }

    private void buildM3u8() throws NetException, DownloadException {
        String response = HttpClient.newInstance(this.url).get().responseToString();
        M3u8 m3u8Check = M3u8Builder.newInstance(response, this.url).build();
        if (m3u8Check.getType() == M3u8.Type.M3U8) {
            this.url = m3u8Check.getMaxRateLink();
            this.buildM3u8();
        } else {
            if (m3u8Check.getType() == M3u8.Type.STREAM) {
                throw new DownloadException("\u4e0d\u652f\u6301\u76f4\u64ad\u6d41\u5a92\u4f53\u4e0b\u8f7d");
            }
            this.m3u8 = m3u8Check;
        }
    }

    private void buildFolder() {
        FileUtils.buildFolder(this.taskEntity.getFile());
    }

    private void selectFiles() {
        this.taskEntity.setDescription(DescriptionWrapper.newEncoder(this.m3u8.getLinks()).serialize());
    }

    @Override
    protected void success() {
        HlsContext.getInstance().m3u8(this.taskEntity.getId(), this.m3u8);
    }

    @Override
    protected void release(boolean success) {
        this.m3u8 = null;
        super.release(success);
    }
}

