/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.protocol.hls;

import com.acgist.snail.config.SymbolConfig;
import com.acgist.snail.context.wrapper.KeyValueWrapper;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.DownloadException;
import com.acgist.snail.net.NetException;
import com.acgist.snail.net.hls.M3u8;
import com.acgist.snail.net.http.HttpClient;
import com.acgist.snail.utils.CollectionUtils;
import com.acgist.snail.utils.StringUtils;
import com.acgist.snail.utils.UrlUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class M3u8Builder {
    private static final Logger LOGGER = LoggerFactory.getLogger(M3u8Builder.class);
    private static final int IV_LENGTH = 32;
    private static final String IV_HEX_PREFIX = "0x";
    private static final String LABEL_EXTM3U = "EXTM3U";
    private static final String LABEL_EXTINF = "EXTINF";
    private static final String LABEL_EXT_X_BITRATE = "EXT-X-BITRATE";
    private static final String LABEL_EXT_X_KEY = "EXT-X-KEY";
    private static final String LABEL_EXT_X_ENDLIST = "EXT-X-ENDLIST";
    private static final String LABEL_EXT_X_STREAM_INF = "EXT-X-STREAM-INF";
    private static final String LABEL_EXT_X_MEDIA_SEQUENCE = "EXT-X-MEDIA-SEQUENCE";
    private static final String ATTR_BANDWIDTH = "BANDWIDTH";
    private static final String ATTR_IV = "IV";
    private static final String ATTR_URI = "URI";
    private static final String ATTR_METHOD = "METHOD";
    private final String source;
    private final List<String> lines;
    private final List<Label> labels;

    private M3u8Builder(String source, List<String> lines) {
        this.source = source;
        this.lines = lines;
        this.labels = new ArrayList<Label>();
    }

    public static final M3u8Builder newInstance(File file, String source) throws DownloadException {
        try {
            return new M3u8Builder(source, Files.readAllLines(file.toPath()));
        }
        catch (IOException e) {
            throw new DownloadException("M3U8\u6587\u4ef6\u89e3\u6790\u5931\u8d25", e);
        }
    }

    public static final M3u8Builder newInstance(String content, String source) {
        return new M3u8Builder(source, StringUtils.readLines(content));
    }

    public M3u8 build() throws NetException, DownloadException {
        if (CollectionUtils.isEmpty(this.lines)) {
            throw new DownloadException("M3U8\u6587\u4ef6\u89e3\u6790\u5931\u8d25\uff08\u6ca1\u6709\u63cf\u8ff0\u4fe1\u606f\uff09");
        }
        this.buildLabels();
        this.checkLabels();
        return this.buildM3u8();
    }

    private void buildLabels() {
        Label label = null;
        for (int index = 0; index < this.lines.size(); ++index) {
            String line = this.lines.get(index).strip();
            if (StringUtils.isEmpty(line)) continue;
            if (line.indexOf(SymbolConfig.Symbol.POUND.toChar()) == 0) {
                label = new Label();
                this.labels.add(label);
                int jndex = line.indexOf(SymbolConfig.Symbol.COLON.toChar());
                if (jndex < 0) {
                    label.setName(line.substring(1).strip());
                    continue;
                }
                label.setName(line.substring(1, jndex).strip());
                label.setValue(line.substring(jndex + 1).strip());
                continue;
            }
            if (label == null) {
                LOGGER.warn("\u94fe\u63a5\u6ca1\u6709\u6807\u7b7e\u4fe1\u606f\uff1a{}-{}", this.source, line);
                continue;
            }
            label.setUrl(line);
        }
    }

    private void checkLabels() throws DownloadException {
        if (this.labels.isEmpty()) {
            throw new DownloadException("M3U8\u683c\u5f0f\u9519\u8bef\uff08\u6ca1\u6709\u6807\u7b7e\uff09");
        }
        String type = this.labels.get(0).getName();
        if (!LABEL_EXTM3U.equalsIgnoreCase(type)) {
            throw new DownloadException("M3U8\u683c\u5f0f\u9519\u8bef\uff08\u5934\u90e8\u9519\u8bef\uff09");
        }
    }

    private M3u8 buildM3u8() throws NetException {
        List<String> links;
        M3u8.Type type = this.buildType();
        Cipher cipher = this.buildCipher();
        if (type == M3u8.Type.M3U8) {
            links = this.buildM3u8Links();
        } else {
            links = this.buildFileLinks(LABEL_EXTINF);
            if (CollectionUtils.isEmpty(links)) {
                links = this.buildFileLinks(LABEL_EXT_X_BITRATE);
            }
            if (CollectionUtils.isEmpty(links)) {
                throw new NetException("\u6ca1\u6709\u4e0b\u8f7d\u6587\u4ef6");
            }
        }
        return new M3u8(type, cipher, links);
    }

    private M3u8.Type buildType() {
        boolean multiM3u8 = this.labels.stream().anyMatch(label -> LABEL_EXT_X_STREAM_INF.equalsIgnoreCase(label.getName()));
        if (multiM3u8) {
            return M3u8.Type.M3U8;
        }
        boolean streamM3u8 = this.labels.stream().noneMatch(label -> LABEL_EXT_X_ENDLIST.equalsIgnoreCase(label.getName()));
        if (streamM3u8) {
            return M3u8.Type.STREAM;
        }
        return M3u8.Type.FILE;
    }

    private Cipher buildCipher() throws NetException {
        Optional<Label> optional = this.labels.stream().filter(label -> LABEL_EXT_X_KEY.equalsIgnoreCase(label.getName())).findFirst();
        if (optional.isEmpty()) {
            return null;
        }
        KeyValueWrapper wrapper = optional.get().attrs();
        String method = wrapper.getIgnoreCase(ATTR_METHOD);
        M3u8.Protocol protocol = M3u8.Protocol.of(method);
        LOGGER.debug("HLS\u52a0\u5bc6\u7b97\u6cd5\uff1a{}", method);
        if (protocol == null || protocol == M3u8.Protocol.NONE) {
            throw new NetException("\u4e0d\u652f\u6301\u7684HLS\u52a0\u5bc6\u7b97\u6cd5\uff1a" + method);
        }
        if (protocol == M3u8.Protocol.AES_128) {
            return this.buildCipherAes128(wrapper.getIgnoreCase(ATTR_IV), wrapper.getIgnoreCase(ATTR_URI));
        }
        throw new NetException("\u4e0d\u652f\u6301\u7684HLS\u52a0\u5bc6\u7b97\u6cd5\uff1a" + method);
    }

    private Cipher buildCipherAes128(String iv, String uri) throws NetException {
        byte[] secret = HttpClient.newInstance(UrlUtils.redirect(this.source, uri)).get().responseToBytes();
        try {
            return this.buildCipher(this.buildCipherIv(iv), secret, "AES", "AES/CBC/NoPadding");
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new NetException("\u83b7\u53d6\u52a0\u5bc6\u5957\u4ef6\u5931\u8d25", e);
        }
    }

    private byte[] buildCipherIv(String iv) {
        int length;
        if (iv == null) {
            iv = this.buildCiperSequenceIv();
        }
        if (iv.startsWith(IV_HEX_PREFIX) || iv.startsWith(IV_HEX_PREFIX.toUpperCase())) {
            iv = iv.substring(IV_HEX_PREFIX.length());
        }
        if ((length = iv.length()) == 32) {
            return StringUtils.unhex(iv);
        }
        if (length < 32) {
            String padding = SymbolConfig.Symbol.ZERO.toString().repeat(32 - length);
            return StringUtils.unhex(padding + iv);
        }
        return StringUtils.unhex(iv.substring(length - 32));
    }

    private String buildCiperSequenceIv() {
        Optional<Label> optional = this.labels.stream().filter(label -> LABEL_EXT_X_MEDIA_SEQUENCE.equalsIgnoreCase(label.getName())).findFirst();
        if (optional.isEmpty()) {
            return SymbolConfig.Symbol.ZERO.toString().repeat(32);
        }
        String sequence = optional.get().getValue();
        int length = sequence.length();
        if (length < 32) {
            String padding = SymbolConfig.Symbol.ZERO.toString().repeat(32 - length);
            return padding + sequence;
        }
        if (length > 32) {
            return sequence.substring(length - 32);
        }
        return sequence;
    }

    private Cipher buildCipher(byte[] iv, byte[] secret, String algorithm, String transformation) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        SecretKeySpec secretKeySpec = new SecretKeySpec(secret, algorithm);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
        Cipher cipher = Cipher.getInstance(transformation);
        cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
        return cipher;
    }

    private List<String> buildM3u8Links() {
        return this.labels.stream().filter(label -> LABEL_EXT_X_STREAM_INF.equalsIgnoreCase(label.getName())).sorted((sourceLabel, targetLabel) -> {
            String sourceBandwidth = sourceLabel.attrs().getIgnoreCase(ATTR_BANDWIDTH);
            String targetBandwidth = targetLabel.attrs().getIgnoreCase(ATTR_BANDWIDTH);
            if (sourceBandwidth == null || targetBandwidth == null) {
                return 0;
            }
            return Integer.valueOf(sourceBandwidth).compareTo(Integer.valueOf(targetBandwidth));
        }).map(label -> UrlUtils.redirect(this.source, label.getUrl())).collect(Collectors.toList());
    }

    private List<String> buildFileLinks(String labelName) {
        return this.labels.stream().filter(label -> labelName.equalsIgnoreCase(label.getName())).filter(label -> StringUtils.isNotEmpty(label.getUrl())).map(label -> UrlUtils.redirect(this.source, label.getUrl())).collect(Collectors.toList());
    }

    public static final class Label {
        private String name;
        private String value;
        private String url;
        private KeyValueWrapper wrapper;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public KeyValueWrapper attrs() {
            if (this.wrapper == null) {
                this.wrapper = KeyValueWrapper.newInstance(SymbolConfig.Symbol.COMMA.toChar(), SymbolConfig.Symbol.EQUALS.toChar(), this.value);
                this.wrapper.decode();
            }
            return this.wrapper;
        }
    }
}

