/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.protocol.http;

import com.acgist.snail.context.ITaskSession;
import com.acgist.snail.context.wrapper.HttpHeaderWrapper;
import com.acgist.snail.downloader.IDownloader;
import com.acgist.snail.downloader.http.HttpDownloader;
import com.acgist.snail.net.DownloadException;
import com.acgist.snail.net.NetException;
import com.acgist.snail.net.http.HttpClient;
import com.acgist.snail.protocol.Protocol;

public final class HttpProtocol
extends Protocol {
    private static final HttpProtocol INSTANCE = new HttpProtocol();
    private HttpHeaderWrapper httpHeaderWrapper;

    public static final HttpProtocol getInstance() {
        return INSTANCE;
    }

    private HttpProtocol() {
        super(Protocol.Type.HTTP, "HTTP");
    }

    @Override
    public boolean available() {
        return true;
    }

    @Override
    public IDownloader buildDownloader(ITaskSession taskSession) {
        return HttpDownloader.newInstance(taskSession);
    }

    @Override
    protected void prep() throws DownloadException {
        this.buildHttpHeader();
    }

    @Override
    protected String buildFileName() throws DownloadException {
        String defaultName = super.buildFileName();
        return this.httpHeaderWrapper.getFileName(defaultName);
    }

    @Override
    protected void buildSize() {
        this.taskEntity.setSize(this.httpHeaderWrapper.fileSize());
    }

    @Override
    protected void release(boolean success) {
        this.httpHeaderWrapper = null;
        super.release(success);
    }

    private void buildHttpHeader() throws DownloadException {
        try {
            this.httpHeaderWrapper = HttpClient.newInstance(this.url).head().responseHeader();
        }
        catch (NetException e) {
            throw new DownloadException("\u83b7\u53d6HTTP\u5934\u90e8\u4fe1\u606f\u5931\u8d25", e);
        }
    }
}

